'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiHistogramSeries = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactVis = require('react-vis');

var _chart_utils = require('../utils/chart_utils');

var _services = require('../../../services');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EuiHistogramSeries = exports.EuiHistogramSeries = function (_AbstractSeries) {
  _inherits(EuiHistogramSeries, _AbstractSeries);

  function EuiHistogramSeries() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, EuiHistogramSeries);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = EuiHistogramSeries.__proto__ || Object.getPrototypeOf(EuiHistogramSeries)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      isMouseOverValue: false
    }, _this._onValueMouseOver = function () {
      _this.setState(function () {
        return { isMouseOverValue: true };
      });
    }, _this._onValueMouseOut = function () {
      _this.setState(function () {
        return { isMouseOverValue: false };
      });
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(EuiHistogramSeries, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          _orientation = _props._orientation,
          name = _props.name,
          data = _props.data,
          color = _props.color,
          onValueClick = _props.onValueClick,
          rest = _objectWithoutProperties(_props, ['_orientation', 'name', 'data', 'color', 'onValueClick']);

      var isMouseOverValue = this.state.isMouseOverValue;

      var isHighDataVolume = data.length > 80 ? true : false;
      var classes = (0, _classnames2.default)('euiHistogramSeries', isHighDataVolume && 'euiHistogramSeries--highDataVolume', isMouseOverValue && onValueClick && 'euiHistogramSeries--hoverEnabled');
      var HistogramSeriesComponent = _orientation === _chart_utils.ORIENTATION.HORIZONTAL ? _reactVis.HorizontalRectSeries : _reactVis.VerticalRectSeries;
      return _react2.default.createElement(HistogramSeriesComponent, _extends({
        name: name,
        className: classes,
        onValueClick: onValueClick,
        onValueMouseOver: this._onValueMouseOver,
        onValueMouseOut: this._onValueMouseOut,
        color: color,
        data: data
      }, rest));
    }
  }], [{
    key: 'getParentConfig',
    value: function getParentConfig(attr, props) {
      var _orientation = props._orientation;

      return _orientation === _chart_utils.ORIENTATION.HORIZONTAL ? _reactVis.HorizontalRectSeries.getParentConfig(attr) : _reactVis.VerticalRectSeries.getParentConfig(attr);
    }
  }]);

  return EuiHistogramSeries;
}(_reactVis.AbstractSeries);

EuiHistogramSeries.displayName = 'EuiHistogramSeries';

EuiHistogramSeries.propTypes = {
  /** The name used to define the data in tooltips and legends */
  name: _propTypes2.default.string.isRequired,
  /** Array<{x: number, y: string|number}> */
  data: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    x: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.number]),
    y: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.number])
  })).isRequired,
  /** An EUI visualization color, the default value is enforced by EuiXYChart */
  color: _propTypes2.default.oneOf(_services.VISUALIZATION_COLORS),

  /**
   * @private passed via XYChart
   */
  // _orientation: PropTypes.string,
  /**
   * Callback when clicking on a bar. Returns { x, y } object.
   */
  onValueClick: _propTypes2.default.func

};

EuiHistogramSeries.defaultProps = {};
EuiHistogramSeries.__docgenInfo = [{
  'description': '',
  'displayName': 'EuiHistogramSeries',
  'methods': [{
    'name': 'getParentConfig',
    'docblock': null,
    'modifiers': ['static'],
    'params': [{
      'name': 'attr',
      'type': null
    }, {
      'name': 'props',
      'type': null
    }],
    'returns': null
  }, {
    'name': '_onValueMouseOver',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }, {
    'name': '_onValueMouseOut',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }],
  'props': {
    'name': {
      'type': {
        'name': 'string'
      },
      'required': true,
      'description': 'The name used to define the data in tooltips and legends'
    },
    'data': {
      'type': {
        'name': 'arrayOf',
        'value': {
          'name': 'shape',
          'value': {
            'x': {
              'name': 'union',
              'value': [{
                'name': 'string'
              }, {
                'name': 'number'
              }],
              'required': false
            },
            'y': {
              'name': 'union',
              'value': [{
                'name': 'string'
              }, {
                'name': 'number'
              }],
              'required': false
            }
          }
        }
      },
      'required': true,
      'description': 'Array<{x: number, y: string|number}>'
    },
    'color': {
      'type': {
        'name': 'enum',
        'computed': true,
        'value': 'VISUALIZATION_COLORS'
      },
      'required': false,
      'description': 'An EUI visualization color, the default value is enforced by EuiXYChart'
    },
    'onValueClick': {
      'type': {
        'name': 'func'
      },
      'required': false,
      'description': 'Callback when clicking on a bar. Returns { x, y } object.'
    }
  }
}];