'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiAreaSeries = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _reactVis = require('react-vis');

var _chart_utils = require('../utils/chart_utils');

var _visualization_color_type = require('../utils/visualization_color_type');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// TODO: needs to send a PR to react-vis for incorporate these changes into AreaSeries class for vertical
// area chart visualizations.
// class ExtendedAreaSeries extends AreaSeries {
//   _renderArea(data, x, y0, y, curve, getNull) {
//     const x0 = this._getAttr0Functor('x');
//     let area = d3Area();
//     if (curve !== null) {
//       if (typeof curve === 'string' && curves[curve]) {
//         area = area.curve(curves[curve]);
//       } else if (typeof curve === 'function') {
//         area = area.curve(curve);
//       }
//     }
//     console.log(Object.getPrototypeOf(this))
//     area = area.defined(getNull);
//     area = area
//       .x1(x)
//       .x0(x0) // this is required for displaying vertical area charts.
//       .y0(y0)
//       .y1(y);
//     return area(data);
//   }
// }

var EuiAreaSeries = exports.EuiAreaSeries = function (_AbstractSeries) {
  _inherits(EuiAreaSeries, _AbstractSeries);

  function EuiAreaSeries() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, EuiAreaSeries);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = EuiAreaSeries.__proto__ || Object.getPrototypeOf(EuiAreaSeries)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      isMouseOverSeries: false
    }, _this._onSeriesMouseOver = function () {
      _this.setState(function () {
        return { isMouseOverSeries: true };
      });
    }, _this._onSeriesMouseOut = function () {
      _this.setState(function () {
        return { isMouseOverSeries: false };
      });
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(EuiAreaSeries, [{
    key: 'render',
    value: function render() {
      var isMouseOverSeries = this.state.isMouseOverSeries;

      var _props = this.props,
          name = _props.name,
          data = _props.data,
          curve = _props.curve,
          color = _props.color,
          onSeriesClick = _props.onSeriesClick,
          rest = _objectWithoutProperties(_props, ['name', 'data', 'curve', 'color', 'onSeriesClick']);

      return _react2.default.createElement(_reactVis.AreaSeries, _extends({
        key: name + '-area',
        className: 'euiAreaSeries',
        curve: curve,
        color: color,
        data: data,
        onSeriesClick: onSeriesClick,
        onSeriesMouseOver: this._onSeriesMouseOver,
        onSeriesMouseOut: this._onSeriesMouseOut,
        style: {
          cursor: isMouseOverSeries && onSeriesClick ? 'pointer' : 'default'
        }
      }, rest));
    }
  }]);

  return EuiAreaSeries;
}(_reactVis.AbstractSeries);

EuiAreaSeries.displayName = 'EuiAreaSeries';
EuiAreaSeries.propTypes = {
  /** The name used to define the data in tooltips and legends */
  name: _propTypes2.default.string.isRequired,
  /** Array<{x: string|number, y: string|number}> */
  data: _propTypes2.default.arrayOf(_propTypes2.default.shape({
    x: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.number]),
    y: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.number])
  })).isRequired,
  /** An EUI visualization color, the default value is enforced by EuiXYChart */
  color: _visualization_color_type.VisualizationColorType,
  curve: _propTypes2.default.oneOf(Object.values(_chart_utils.CURVE)),
  onSeriesClick: _propTypes2.default.func
};

EuiAreaSeries.defaultProps = {
  curve: _chart_utils.CURVE.LINEAR
};
EuiAreaSeries.__docgenInfo = [{
  'description': '',
  'displayName': 'EuiAreaSeries',
  'methods': [{
    'name': '_onSeriesMouseOver',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }, {
    'name': '_onSeriesMouseOut',
    'docblock': null,
    'modifiers': [],
    'params': [],
    'returns': null
  }],
  'props': {
    'name': {
      'type': {
        'name': 'string'
      },
      'required': true,
      'description': 'The name used to define the data in tooltips and legends'
    },
    'data': {
      'type': {
        'name': 'arrayOf',
        'value': {
          'name': 'shape',
          'value': {
            'x': {
              'name': 'union',
              'value': [{
                'name': 'string'
              }, {
                'name': 'number'
              }],
              'required': false
            },
            'y': {
              'name': 'union',
              'value': [{
                'name': 'string'
              }, {
                'name': 'number'
              }],
              'required': false
            }
          }
        }
      },
      'required': true,
      'description': 'Array<{x: string|number, y: string|number}>'
    },
    'color': {
      'type': {
        'name': 'custom',
        'raw': 'VisualizationColorType'
      },
      'required': false,
      'description': 'An EUI visualization color, the default value is enforced by EuiXYChart'
    },
    'curve': {
      'type': {
        'name': 'enum',
        'computed': true,
        'value': 'Object.values(CURVE)'
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': 'CURVE.LINEAR',
        'computed': true
      }
    },
    'onSeriesClick': {
      'type': {
        'name': 'func'
      },
      'required': false,
      'description': ''
    }
  }
}];