'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiTableRow = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var EuiTableRow = function EuiTableRow(_ref) {
  var children = _ref.children,
      className = _ref.className,
      isSelected = _ref.isSelected,
      isSelectable = _ref.isSelectable,
      hasActions = _ref.hasActions,
      isExpandedRow = _ref.isExpandedRow,
      isExpandable = _ref.isExpandable,
      rest = _objectWithoutProperties(_ref, ['children', 'className', 'isSelected', 'isSelectable', 'hasActions', 'isExpandedRow', 'isExpandable']);

  var classes = (0, _classnames2.default)('euiTableRow', className, {
    'euiTableRow-isSelectable': isSelectable,
    'euiTableRow-isSelected': isSelected,
    'euiTableRow-hasActions': hasActions,
    'euiTableRow-isExpandedRow': isExpandedRow,
    'euiTableRow-isExpandable': isExpandable
  });

  return _react2.default.createElement(
    'tr',
    _extends({
      className: classes
    }, rest),
    children
  );
};

exports.EuiTableRow = EuiTableRow;
EuiTableRow.propTypes = {
  children: _propTypes2.default.node,
  className: _propTypes2.default.string,
  /**
   * Indicates if the table has a single column of checkboxes for selecting rows (affects mobile only)
   */
  isSelectable: _propTypes2.default.bool,
  /**
   * Indicates the current row has been selected
   */
  isSelected: _propTypes2.default.bool,
  /**
   * Indicates if the table has a dedicated column for icon-only actions (affects mobile only)
   */
  hasActions: _propTypes2.default.bool,
  /**
   * Indicates if the row will have an expanded row
   */
  isExpandable: _propTypes2.default.bool,
  /**
   * Indicates if the row will be the expanded row
   */
  isExpandedRow: _propTypes2.default.bool
};
EuiTableRow.__docgenInfo = [{
  'description': '',
  'methods': [],
  'props': {
    'children': {
      'type': {
        'name': 'node'
      },
      'required': false,
      'description': ''
    },
    'className': {
      'type': {
        'name': 'string'
      },
      'required': false,
      'description': ''
    },
    'isSelectable': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': 'Indicates if the table has a single column of checkboxes for selecting rows (affects mobile only)'
    },
    'isSelected': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': 'Indicates the current row has been selected'
    },
    'hasActions': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': 'Indicates if the table has a dedicated column for icon-only actions (affects mobile only)'
    },
    'isExpandable': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': 'Indicates if the row will have an expanded row'
    },
    'isExpandedRow': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': 'Indicates if the row will be the expanded row'
    }
  }
}];