'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiOutsideClickDetector = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _accessibility = require('../../services/accessibility');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var EuiOutsideClickDetector = exports.EuiOutsideClickDetector = function (_Component) {
  _inherits(EuiOutsideClickDetector, _Component);

  function EuiOutsideClickDetector() {
    var _ref;

    _classCallCheck(this, EuiOutsideClickDetector);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    // the id is used to identify which EuiOutsideClickDetector
    // is the source of a click event; as the click event bubbles
    // up and reaches the click detector's child component the
    // id value is stamped on the event. This id is inspected
    // in the document's click handler, and if the id doesn't
    // exist or doesn't match this detector's id, then trigger
    // the outsideClick callback.
    //
    // Taking this approach instead of checking if the event's
    // target element exists in this component's DOM sub-tree is
    // necessary for handling clicks originating from children
    // rendered through React's portals (EuiPortal). The id tracking
    // works because React guarantees the event bubbles through the
    // virtual DOM and executes EuiClickDetector's onClick handler,
    // stamping the id even though the event originates outside
    // this component's reified DOM tree.
    var _this = _possibleConstructorReturn(this, (_ref = EuiOutsideClickDetector.__proto__ || Object.getPrototypeOf(EuiOutsideClickDetector)).call.apply(_ref, [this].concat(args)));

    _this.onClickOutside = function (event) {
      var _this$props = _this.props,
          isDisabled = _this$props.isDisabled,
          onOutsideClick = _this$props.onOutsideClick;


      if (isDisabled) {
        return;
      }

      if (event.euiGeneratedBy === _this.id) {
        return;
      }

      onOutsideClick();
    };

    _this.onChildClick = function (event) {
      event.nativeEvent.euiGeneratedBy = _this.id;
      if (_this.props.onClick) _this.props.onClick(event);
    };

    _this.id = (0, _accessibility.htmlIdGenerator)();
    return _this;
  }

  _createClass(EuiOutsideClickDetector, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      document.addEventListener('click', this.onClickOutside);
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      document.removeEventListener('click', this.onClickOutside);
    }
  }, {
    key: 'render',
    value: function render() {
      var props = _extends({}, this.props.children.props, {
        onClick: this.onChildClick
      });

      var child = _react.Children.only(this.props.children);
      return (0, _react.cloneElement)(child, props);
    }
  }]);

  return EuiOutsideClickDetector;
}(_react.Component);

EuiOutsideClickDetector.propTypes = {
  children: _propTypes2.default.node.isRequired,
  onOutsideClick: _propTypes2.default.func.isRequired,
  isDisabled: _propTypes2.default.bool
};
EuiOutsideClickDetector.__docgenInfo = [{
  'description': '',
  'displayName': 'EuiOutsideClickDetector',
  'methods': [{
    'name': 'onClickOutside',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'event',
      'type': null
    }],
    'returns': null
  }, {
    'name': 'onChildClick',
    'docblock': null,
    'modifiers': [],
    'params': [{
      'name': 'event',
      'type': null
    }],
    'returns': null
  }],
  'props': {
    'children': {
      'type': {
        'name': 'node'
      },
      'required': true,
      'description': ''
    },
    'onOutsideClick': {
      'type': {
        'name': 'func'
      },
      'required': true,
      'description': ''
    },
    'isDisabled': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': ''
    }
  }
}];