'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiLoadingChart = exports.SIZES = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

var sizeToClassNameMap = {
  m: 'euiLoadingChart--medium',
  l: 'euiLoadingChart--large',
  xl: 'euiLoadingChart--xLarge'
};

var SIZES = exports.SIZES = Object.keys(sizeToClassNameMap);

var EuiLoadingChart = function EuiLoadingChart(_ref) {
  var size = _ref.size,
      mono = _ref.mono,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, ['size', 'mono', 'className']);

  var classes = (0, _classnames2.default)('euiLoadingChart', mono === true ? 'euiLoadingChart--mono' : '', className, sizeToClassNameMap[size]);

  return _react2.default.createElement(
    'div',
    _extends({
      className: classes
    }, rest),
    _react2.default.createElement('div', { className: 'euiLoadingChart__bar' }),
    _react2.default.createElement('div', { className: 'euiLoadingChart__bar' }),
    _react2.default.createElement('div', { className: 'euiLoadingChart__bar' }),
    _react2.default.createElement('div', { className: 'euiLoadingChart__bar' })
  );
};

exports.EuiLoadingChart = EuiLoadingChart;
EuiLoadingChart.propTypes = {
  mono: _propTypes2.default.bool,
  size: _propTypes2.default.oneOf(SIZES)
};

EuiLoadingChart.defaultProps = {
  mono: false
};
EuiLoadingChart.__docgenInfo = [{
  'description': '',
  'methods': [],
  'props': {
    'mono': {
      'type': {
        'name': 'bool'
      },
      'required': false,
      'description': '',
      'defaultValue': {
        'value': 'false',
        'computed': false
      }
    },
    'size': {
      'type': {
        'name': 'enum',
        'value': [{
          'value': '"m"',
          'computed': false
        }, {
          'value': '"l"',
          'computed': false
        }, {
          'value': '"xl"',
          'computed': false
        }]
      },
      'required': false,
      'description': ''
    }
  }
}];