/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.swingviews;

import gnu.kawa.models.Button;
import gnu.kawa.models.Model;
import gnu.kawa.models.ModelListener;
import gnu.kawa.swingviews.SwModel;
import gnu.kawa.swingviews.SwingDisplay;
import java.awt.Color;
import javax.swing.JButton;

public class SwingButton
extends JButton
implements ModelListener {
    Button model;

    public SwingButton(Button button) {
        super(button.getText());
        Color color;
        this.setModel(new SwModel(button));
        this.model = button;
        Object object2 = button.getAction();
        if (object2 != null) {
            this.addActionListener(SwingDisplay.makeActionListener(object2));
        }
        button.addListener(this);
        Color color2 = button.getForeground();
        if (color2 != null) {
            super.setBackground(color2);
        }
        if ((color = button.getBackground()) != null) {
            super.setBackground(color);
        }
    }

    public void setText(String string) {
        if (this.model == null) {
            super.setText(string);
        } else {
            this.model.setText(string);
        }
    }

    public void setForeground(Color color) {
        if (this.model == null) {
            super.setForeground(color);
        } else {
            this.model.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        if (this.model == null) {
            super.setBackground(color);
        } else {
            this.model.setBackground(color);
        }
    }

    public void modelUpdated(Model model, Object object2) {
        if (object2 == "text" && model == this.model) {
            super.setText(this.model.getText());
        } else if (object2 == "foreground" && model == this.model) {
            super.setForeground(this.model.getForeground());
        } else if (object2 == "background" && model == this.model) {
            super.setBackground(this.model.getBackground());
        }
    }
}

