/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Method;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CanInline;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.IfExp;
import gnu.expr.IgnoreTarget;
import gnu.expr.InlineCalls;
import gnu.expr.Inlineable;
import gnu.expr.LambdaExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.Procedure;
import gnu.mapping.Values;
import gnu.math.IntNum;

public class ValuesMap
extends MethodProc
implements CanInline,
Inlineable {
    public static final ValuesMap valuesMap = new ValuesMap(-1);
    public static final ValuesMap valuesMapWithPos = new ValuesMap(1);
    private final int startCounter;

    private ValuesMap(int n) {
        this.startCounter = n;
    }

    public int numArgs() {
        return 8194;
    }

    public void apply(CallContext callContext) throws Throwable {
        Procedure procedure = (Procedure)callContext.getNextArg();
        Consumer consumer = callContext.consumer;
        Object object2 = callContext.getNextArg();
        Procedure.checkArgCount(procedure, 1);
        if (object2 instanceof Values) {
            int n = 0;
            int n2 = this.startCounter;
            Values values = (Values)object2;
            while ((n = values.nextPos(n)) != 0) {
                Object object3 = values.getPosPrevious(n);
                if (this.startCounter >= 0) {
                    procedure.check2(object3, IntNum.make(n2++), callContext);
                } else {
                    procedure.check1(object3, callContext);
                }
                callContext.runUntilDone();
            }
        } else {
            if (this.startCounter >= 0) {
                procedure.check2(object2, IntNum.make(this.startCounter), callContext);
            } else {
                procedure.check1(object2, callContext);
            }
            callContext.runUntilDone();
        }
    }

    private LambdaExp canInline(ApplyExp applyExp) {
        Expression expression;
        Expression[] expressionArray = applyExp.getArgs();
        if (expressionArray.length == 2 && (expression = expressionArray[0]) instanceof LambdaExp) {
            LambdaExp lambdaExp = (LambdaExp)expression;
            if (lambdaExp.min_args == lambdaExp.max_args && lambdaExp.min_args == (this.startCounter >= 0 ? 2 : 1)) {
                return lambdaExp;
            }
        }
        return null;
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, boolean bl) {
        applyExp.walkArgs(inlineCalls, bl);
        LambdaExp lambdaExp = this.canInline(applyExp);
        if (lambdaExp != null) {
            lambdaExp.setInlineOnly(true);
            lambdaExp.returnContinuation = applyExp;
            lambdaExp.inlineHome = inlineCalls.getCurrentLambda();
        }
        return applyExp;
    }

    public void compile(ApplyExp applyExp, Compilation compilation, Target target) {
        LambdaExp lambdaExp = this.canInline(applyExp);
        if (lambdaExp == null) {
            ApplyExp.compile(applyExp, compilation, target);
            return;
        }
        Expression[] expressionArray = applyExp.getArgs();
        if (!(target instanceof IgnoreTarget) && !(target instanceof ConsumerTarget)) {
            ConsumerTarget.compileUsingConsumer(applyExp, compilation, target);
            return;
        }
        Expression expression = expressionArray[1];
        ValuesMap.compileInlined(lambdaExp, expression, this.startCounter, null, compilation, target);
    }

    public static void compileInlined(LambdaExp lambdaExp, Expression expression, int n, Method method, Compilation compilation, Target target) {
        Expression[] expressionArray;
        Declaration declaration;
        Variable variable;
        Declaration declaration2 = lambdaExp.firstDecl();
        CodeAttr codeAttr = compilation.getCode();
        Scope scope = codeAttr.pushScope();
        Type type = declaration2.getType();
        if (n >= 0) {
            variable = scope.addVariable(codeAttr, Type.intType, "position");
            codeAttr.emitPushInt(n);
            codeAttr.emitStore(variable);
            declaration = new Declaration(variable);
        } else {
            variable = null;
            declaration = null;
        }
        if (declaration2.isSimple() && method == null) {
            declaration2.allocateVariable(codeAttr);
        } else {
            expressionArray = Compilation.mangleNameIfNeeded(declaration2.getName());
            declaration2 = new Declaration(codeAttr.addLocal(type.getImplementationType(), (String)expressionArray));
        }
        expressionArray = n >= 0 ? new Expression[]{new ReferenceExp(declaration2), new ReferenceExp(declaration)} : new Expression[]{new ReferenceExp(declaration2)};
        Expression expression2 = new ApplyExp(lambdaExp, expressionArray);
        if (method != null) {
            if (expression2.getType().getImplementationType() != Type.booleanType) {
                expression2 = new ApplyExp(method, new Expression[]{expression2, new ReferenceExp(declaration)});
            }
            expression2 = new IfExp(expression2, new ReferenceExp(declaration2), QuoteExp.voidExp);
        }
        Variable variable2 = codeAttr.addLocal(Type.intType);
        Variable variable3 = codeAttr.addLocal(Type.pointer_type);
        Variable variable4 = codeAttr.addLocal(Type.intType);
        expression.compileWithPosition(compilation, Target.pushObject);
        codeAttr.emitStore(variable3);
        codeAttr.emitPushInt(0);
        codeAttr.emitStore(variable2);
        Label label = new Label(codeAttr);
        Label label2 = new Label(codeAttr);
        label.define(codeAttr);
        codeAttr.emitLoad(variable3);
        codeAttr.emitLoad(variable2);
        codeAttr.emitInvokeStatic(Compilation.typeValues.getDeclaredMethod("nextIndex", 2));
        codeAttr.emitDup(Type.intType);
        codeAttr.emitStore(variable4);
        codeAttr.emitGotoIfIntLtZero(label2);
        codeAttr.emitLoad(variable3);
        codeAttr.emitLoad(variable2);
        codeAttr.emitInvokeStatic(Compilation.typeValues.getDeclaredMethod("nextValue", 2));
        StackTarget.convert(compilation, Type.objectType, type);
        declaration2.compileStore(compilation);
        expression2.compile(compilation, target);
        if (n >= 0) {
            codeAttr.emitInc(variable, (short)1);
        }
        codeAttr.emitLoad(variable4);
        codeAttr.emitStore(variable2);
        codeAttr.emitGoto(label);
        label2.define(codeAttr);
        codeAttr.popScope();
    }

    public Type getReturnType(Expression[] expressionArray) {
        return Type.pointer_type;
    }
}

