/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.brl;

import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.ModuleBody;
import gnu.kawa.brl.BRLRead;
import gnu.kawa.brl.Prompter;
import gnu.kawa.functions.AppendValues;
import gnu.lists.Consumer;
import gnu.lists.FString;
import gnu.mapping.Environment;
import gnu.mapping.InPort;
import gnu.mapping.Procedure;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.xml.XMLPrinter;
import java.io.Writer;
import kawa.standard.Scheme;

public class BRL
extends Scheme {
    static BRL instance;
    static final Object emptyForm;
    boolean brlCompatible = false;

    public BRL() {
        instance = this;
        ModuleBody.setMainPrintValues(true);
        Environment.setCurrent(this.getEnvironment());
        try {
            this.loadClass("gnu.brl.stringfun");
            this.loadClass("gnu.kawa.brl.progfun");
            this.loadClass("gnu.kawa.slib.HTTP");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("caught " + classNotFoundException);
        }
    }

    public static Interpreter getInstance(boolean bl) {
        if (instance == null) {
            new BRL();
        }
        instance.setBrlCompatible(bl);
        return instance;
    }

    public static BRL getKrlInstance() {
        BRL.getInstance(false);
        return instance;
    }

    public static BRL getBrlInstance() {
        BRL.getInstance(true);
        return instance;
    }

    public boolean isBrlCompatible() {
        return this.brlCompatible;
    }

    public void setBrlCompatible(boolean bl) {
        this.brlCompatible = bl;
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        Compilation.defaultCallConvention = 2;
        BRLRead bRLRead = new BRLRead(inPort, sourceMessages);
        bRLRead.setBrlCompatible(this.isBrlCompatible());
        return bRLRead;
    }

    public Consumer getOutputConsumer(Writer writer) {
        if (this.isBrlCompatible()) {
            return super.getOutputConsumer(writer);
        }
        return new XMLPrinter(writer, false);
    }

    public static void registerEnvironment() {
        BRL bRL = new BRL();
        Interpreter.defaultInterpreter = bRL;
        Environment.setCurrent(bRL.getEnvironment());
    }

    public Expression makeBody(Expression[] expressionArray) {
        if (this.isBrlCompatible()) {
            return super.makeBody(expressionArray);
        }
        return new ApplyExp(AppendValues.appendValues, expressionArray);
    }

    public Procedure getPrompter() {
        return new Prompter();
    }

    static {
        emptyForm = new FString();
    }
}

