/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.CompilationException;
import gnu.jel.OPfunction;
import gnu.jel.OPlist;
import gnu.jel.OPload;
import gnu.jel.TypesStack;
import gnu.jel.debug.Debug;
import gnu.jel.reflect.Method;

public class OPunary
extends OPfunction {
    protected int code;
    private static final Method sb_constructor;
    private static final Method sb_toString;
    protected static final Class sb_class;
    protected static final Class string_class;
    private static Method[] unwrap;
    protected static final int[] unary_prmtns;
    private static final int[][] una;
    private static final String[] opSymbols;
    private static final String[] opNames;

    public OPunary(TypesStack typesStk, int code) throws CompilationException {
        Debug.assert(code >= 0 && code <= 3);
        if (code == 3) {
            code = 12;
        }
        this.code = code;
        int opTypeID = typesStk.peekID();
        Class opType = typesStk.peek();
        if (una[code][opTypeID] == 255) {
            Object[] paramsExc = new Object[]{opNames[code], opType};
            throw new CompilationException(-1, 16, paramsExc);
        }
        typesStk.pop();
        if (code != 12) {
            this.resID = unary_prmtns[opTypeID];
            typesStk.pushID(this.resID, null);
        } else {
            int unwrapID;
            this.resID = opTypeID;
            if (opTypeID == 8 && (unwrapID = TypesStack.unwrapTypeID(opType)) > 0) {
                this.resID = unwrapID;
            }
        }
    }

    public OPunary(TypesStack typesStk, int targetID, Class targetClass, boolean allownarrowing) throws CompilationException {
        Debug.assert(targetID >= 0 && targetID <= 8 && (targetID != 8 || targetClass != null));
        this.resID = targetID;
        this.resType = targetClass;
        Class currClass = typesStk.peek();
        int currID = typesStk.peekID();
        this.code = -1;
        if (currID == 8 && targetID == 8) {
            this.code = TypesStack.isString(currClass) && TypesStack.isTSB(targetClass) ? 13 : (TypesStack.isString(targetClass) && TypesStack.isTSB(currClass) ? 14 : 11);
        } else if (currID <= 8 && targetID < 8) {
            int unwrapID;
            if (currID == 8 && (unwrapID = TypesStack.unwrapTypeID(currClass)) > 0) {
                currID = unwrapID;
            }
            if (una[targetID + 3][currID] != 255) {
                this.code = targetID + 3;
            }
            this.resType = TypesStack.primitiveTypes[targetID];
        }
        if (this.code < 0) {
            Object[] paramsExc = new Object[]{currClass, this.resType};
            throw new CompilationException(-1, 21, paramsExc);
        }
        if (!allownarrowing && !TypesStack.isWidening(currClass, this.resType)) {
            Object[] paramsExc = new Object[]{currClass, this.resType};
            throw new CompilationException(-1, 22, paramsExc);
        }
        typesStk.pop();
        typesStk.pushID(this.resID, this.resType);
    }

    public OPunary(TypesStack typesStk, Class cls, boolean allownarrowing) throws CompilationException {
        this(typesStk, TypesStack.primitiveID(cls), cls, allownarrowing);
    }

    public int getNParams() {
        return 1;
    }

    protected void compile_pre(ClassFile cf) {
        if (this.code == 2) {
            cf.labels_block();
        }
        if (this.code == 13) {
            cf.code(187);
            cf.codeI(cf.getIndex(sb_class, 9));
            cf.code(89);
            cf.typesStk.pushID(8, sb_class);
            cf.typesStk.pushID(8, sb_class);
        }
    }

    protected void compile(ClassFile cf) {
        if (this.code == 2) {
            cf.labels_unblock_not();
        } else if (this.code == 13) {
            cf.code(183);
            cf.codeI(cf.getIndex(sb_constructor, 10));
            cf.typesStk.pop();
            cf.typesStk.pop();
        } else if (this.code == 14) {
            cf.code(182);
            cf.codeI(cf.getIndex(sb_toString, 10));
            cf.typesStk.pop();
            cf.typesStk.pushID(8, string_class);
        } else {
            int unwrapID;
            cf.ensure_value();
            int currID = cf.typesStk.peekID();
            if (currID == 8 && (this.code < 11 || this.code == 12) && (unwrapID = TypesStack.unwrapTypeID(cf.typesStk.peek())) > 0) {
                cf.code(185);
                cf.codeI(cf.getIndex(unwrap[unwrapID], 11));
                cf.codeI(256);
                cf.typesStk.pop();
                cf.typesStk.pushID(unwrapID);
                currID = unwrapID;
            }
            cf.code(una[this.code][currID]);
            if (this.code == 1) {
                cf.typesStk.tempExcessWords(TypesStack.stkoccup[this.resID]);
            } else if (this.code == 11) {
                cf.codeI(cf.getIndex(this.resType, 9));
            }
            cf.typesStk.pop();
            if (this.code != 12) {
                cf.typesStk.pushID(this.resID, this.resType);
            }
        }
    }

    protected void eval(OPlist list) {
        if (this.code == 12) {
            return;
        }
        if (!(this.prev instanceof OPload)) {
            return;
        }
        OPload opl = (OPload)this.prev;
        if (this.code == 2) {
            opl.what = ((Boolean)opl.what).booleanValue() ? Boolean.FALSE : Boolean.TRUE;
        } else if (this.code < 2) {
            Number val = TypesStack.widen(opl.what, opl.resID);
            switch (this.code) {
                case 0: {
                    if (opl.resID > 5) {
                        val = new Double(-val.doubleValue());
                        break;
                    }
                    val = new Long(-val.longValue());
                    break;
                }
                case 1: {
                    val = new Long(val.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    break;
                }
                default: {
                    Debug.assert(this.code >= 0, "Wrong unary opcode.");
                }
            }
            opl.what = TypesStack.narrow(val, this.resID);
            opl.resID = this.resID;
        } else if (opl.resID != this.resID) {
            opl.what = TypesStack.narrow(TypesStack.widen(opl.what, opl.resID), this.resID);
            opl.resID = this.resID;
        } else if (this.code == 13) {
            opl.what = new StringBuffer((String)opl.what);
        } else if (this.code == 14) {
            opl.what = opl.what.toString();
        }
        list.remove(this);
    }

    public String toString() {
        if (this.code == 13) {
            return "->TSB";
        }
        if (this.code == 14) {
            return "TSB->";
        }
        return opSymbols[this.code];
    }

    static {
        Method sb_constructor_1 = null;
        Method sb_toString_1 = null;
        Class<?> sb_class_1 = null;
        Class<?> string_class_1 = null;
        unwrap = new Method[8];
        try {
            sb_class_1 = Class.forName("java.lang.StringBuffer");
            string_class_1 = Class.forName("java.lang.String");
            Class[] params = new Class[]{string_class_1};
            sb_constructor_1 = new Method(sb_class_1.getConstructor(params));
            params = new Class[]{};
            sb_toString_1 = new Method(sb_class_1.getMethod("toString", params));
            int i = 0;
            while (i < 8) {
                OPunary.unwrap[i] = new Method(TypesStack.unwrapClasses[i].getMethod("getValue", params));
                ++i;
            }
        }
        catch (Exception e) {
            Debug.reportThrowable(e);
        }
        sb_class = sb_class_1;
        string_class = string_class_1;
        sb_constructor = sb_constructor_1;
        sb_toString = sb_toString_1;
        unary_prmtns = new int[]{0, 4, 4, 4, 4, 5, 6, 7, 8, 9};
        una = new int[][]{{116, 116, 255, 116, 116, 117, 118, 119, 255, 255}, {255, 33282, 33282, 33282, 33282, 8619266, 255, 255, 255, 255}, {0, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {0, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {145, 0, 145, 145, 145, 37256, 37259, 37262, 255, 255}, {146, 146, 0, 146, 146, 37512, 37515, 37518, 255, 255}, {147, 147, 147, 0, 147, 37768, 37771, 37774, 255, 255}, {0, 0, 0, 0, 0, 136, 139, 142, 255, 255}, {133, 133, 133, 133, 133, 0, 140, 143, 255, 255}, {134, 134, 134, 134, 134, 137, 0, 144, 255, 255}, {135, 135, 135, 135, 135, 138, 141, 0, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 192, 255}, {172, 172, 172, 172, 172, 173, 174, 175, 176, 177}};
        opSymbols = new String[]{"--", "~", "!", "(Z)", "(B)", "(C)", "(S)", "(I)", "(J)", "(F)", "(D)", "(L)", "<RET>"};
        opNames = new String[]{"negation", "bitwise inversion", "logical inversion", "cast to boolean", "cast to byte", "cast to char", "cast to short", "cast to int", "cast to long", "cast to float", "cast to double", "cast to reference", "return"};
        Debug.assert(opNames.length == opSymbols.length && opNames.length == una.length);
    }
}

