/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.debug.Debug;
import gnu.jel.generated.Token;
import java.text.MessageFormat;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class CompilationException
extends Exception {
    int col;
    private int code = -1;
    private Object[] params = null;
    private static final ResourceBundle msgs;

    public CompilationException(int col, String message) {
        super(message);
        this.col = col;
    }

    public CompilationException(Token tok, String message) {
        super(message);
        this.col = tok.beginColumn;
    }

    public CompilationException(int col, int code, Object param) {
        this.code = code;
        Object[] temp = new Object[]{param};
        this.params = temp;
        this.col = col;
    }

    public CompilationException(int col, int code, Object[] params) {
        this.code = code;
        this.params = params;
        this.col = col;
    }

    public int getColumn() {
        return this.col;
    }

    public void setColumn(int col) {
        this.col = col;
    }

    public int getType() {
        return this.code;
    }

    public String getMessage() {
        Debug.assert(this.col >= 0);
        if (this.code >= 0) {
            return MessageFormat.format(msgs.getString("e" + this.code), this.params);
        }
        return super.getMessage();
    }

    static {
        PropertyResourceBundle resB = null;
        try {
            Class<?> c = Class.forName("gnu.jel.CompilationException");
            resB = new PropertyResourceBundle(c.getResourceAsStream("JEL.properties"));
        }
        catch (Exception exc) {
            Debug.reportThrowable(exc);
        }
        msgs = resB;
    }
}

