/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.CompilationException;
import gnu.jel.CompiledExpression;
import gnu.jel.ImageLoader;
import gnu.jel.IntegerStack;
import gnu.jel.Library;
import gnu.jel.LocalField;
import gnu.jel.LocalMethod;
import gnu.jel.OP;
import gnu.jel.OPbinary;
import gnu.jel.OPcall;
import gnu.jel.OPcondtnl;
import gnu.jel.OPload;
import gnu.jel.OPunary;
import gnu.jel.TableKeeper;
import gnu.jel.debug.Debug;
import gnu.jel.debug.Tester;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Stack;

public class ClassFile
implements Cloneable {
    private int poolEntries = 1;
    private ByteArrayOutputStream constPoolData;
    private DataOutputStream constPool;
    private Hashtable Items = new Hashtable();
    private Hashtable UTFs = new Hashtable();
    private int nMethods = 0;
    private int nMethodsPatch;
    private byte[] text;
    int tsize = 0;
    private boolean isInterface;
    private IntegerStack[] cstk = new IntegerStack[6];
    private int startCodeAttr = 0;
    private int startCode = 0;
    private static final byte[] prologue;
    private LocalMethod currMethod = null;
    int[] paramsVars = null;
    private int cW = 0;
    private int mW = 0;
    private static final Class[] specialClasses;
    private static final Member[] specialMethods;
    private IntegerStack branchStack = new IntegerStack();
    int currJump = 0;
    private boolean iNJ = false;

    void write(int b) {
        try {
            this.text[this.tsize++] = (byte)b;
        }
        catch (ArrayIndexOutOfBoundsException exc) {
            byte[] new_text = new byte[this.text.length << 1];
            System.arraycopy(this.text, 0, new_text, 0, this.tsize - 1);
            this.text = new_text;
            this.text[this.tsize - 1] = (byte)b;
        }
    }

    void writeShort(int v) {
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    void writeInt(int v) {
        this.write(v >>> 24 & 0xFF);
        this.write(v >>> 16 & 0xFF);
        this.write(v >>> 8 & 0xFF);
        this.write(v & 0xFF);
    }

    public ClassFile(int modifiers, String name, Class superClass, Class[] interfaces, LocalField[] fields) {
        this.constPoolData = new ByteArrayOutputStream();
        this.constPool = new DataOutputStream(this.constPoolData);
        this.text = new byte[256];
        Debug.assert(this.cstk.length == 6);
        int i = 0;
        while (i < 6) {
            this.cstk[i] = new IntegerStack();
            ++i;
        }
        try {
            Debug.assert(name.indexOf(46) == -1);
            this.getUTFIndex(name);
            Debug.assert((modifiers & 0xFFFFF9EE) == 0);
            this.isInterface = (modifiers & 0x200) > 0;
            this.writeShort(modifiers | 0x20);
            Debug.assert(this.poolEntries == 2);
            ++this.poolEntries;
            this.constPool.write(7);
            this.constPool.writeShort(1);
            this.writeShort(2);
            this.writeShort(this.getIndex(superClass, 9));
            int nInterfaces = interfaces == null ? 0 : interfaces.length;
            this.writeShort(nInterfaces);
            int i2 = 0;
            while (i2 < nInterfaces) {
                Debug.assert(interfaces[i2].isInterface());
                this.writeShort(this.getIndex(interfaces[i2], 9));
                ++i2;
            }
            int nFields = fields == null ? 0 : fields.length;
            this.writeShort(nFields);
            int i3 = 0;
            while (i3 < nFields) {
                LocalField cLF = fields[i3];
                Debug.assert(!(cLF instanceof LocalMethod));
                this.writeShort(cLF.getModifiers());
                this.writeShort(this.getUTFIndex(cLF.getName()));
                this.writeShort(this.getUTFIndex(Library.getSignature(cLF.getType())));
                this.writeShort(0);
                ++i3;
            }
            this.nMethodsPatch = this.tsize;
            this.writeShort(0);
        }
        catch (IOException exc) {
            // empty catch block
        }
    }

    public Object clone() {
        ClassFile res = null;
        try {
            res = (ClassFile)super.clone();
            res.Items = (Hashtable)res.Items.clone();
            res.UTFs = (Hashtable)res.UTFs.clone();
            res.paramsVars = (int[])res.paramsVars.clone();
            res.branchStack = res.branchStack.copy();
            Debug.assert(this.cstk.length == 6);
            res.cstk = new IntegerStack[6];
            int i = 0;
            while (i < 6) {
                res.cstk[i] = this.cstk[i].copy();
                ++i;
            }
            res.constPoolData = new ByteArrayOutputStream();
            this.constPool.flush();
            this.constPoolData.writeTo(res.constPoolData);
            res.constPool = new DataOutputStream(res.constPoolData);
            res.text = (byte[])res.text.clone();
        }
        catch (IOException exc) {
            Debug.reportThrowable(exc);
        }
        catch (CloneNotSupportedException exc) {
            Debug.reportThrowable(exc);
        }
        return res;
    }

    public void newMethod(LocalMethod m, Class[] vars) {
        Debug.assert(this.cW == 0);
        int i = 0;
        while (i < 6) {
            Debug.assert(this.cstk[i].size() == 0);
            ++i;
        }
        Debug.assert(this.currJump == 0);
        this.finishMethod();
        ++this.nMethods;
        int mdfrs = m.getModifiers();
        if (this.isInterface) {
            mdfrs |= 0x400;
        }
        boolean isAbstract = (mdfrs & 0x400) > 0;
        this.writeShort(mdfrs);
        this.writeShort(this.getUTFIndex(m.getName()));
        this.writeShort(this.getUTFIndex(Library.getSignature(m)));
        int temp = 0;
        Class[] exceptions = m.getExceptionTypes();
        if (exceptions != null) {
            ++temp;
        }
        if (!isAbstract) {
            ++temp;
        }
        this.writeShort(temp);
        if (exceptions != null) {
            temp = exceptions.length;
            this.writeShort(this.getUTFIndex("Exceptions"));
            this.writeInt((temp + 1) * 2);
            this.writeShort(temp);
            int i2 = 0;
            while (i2 < temp) {
                this.writeShort(this.getIndex(exceptions[i2], 9));
                ++i2;
            }
        }
        if (!isAbstract) {
            this.startCodeAttr = this.tsize;
            this.writeShort(this.getUTFIndex("Code"));
            this.writeInt(0);
            this.writeShort(0);
            Class[] params = m.getParameterTypes();
            int parlen = params == null ? 0 : params.length;
            int varlen = vars == null ? 0 : vars.length;
            int this_num = (mdfrs & 8) == 0 ? 1 : 0;
            int nLocalVars = parlen + varlen + this_num;
            this.paramsVars = new int[nLocalVars];
            Debug.assert(this.cW == 0);
            int i3 = 0;
            while (i3 < this.paramsVars.length) {
                int j = i3 - this_num;
                this.paramsVars[i3] = this.cW;
                this.noteStk(-1, i3 < this_num ? 8 : OP.typeID(j < parlen ? params[j] : vars[j - parlen]));
                ++i3;
            }
            this.writeShort(this.cW);
            this.cW = 0;
            this.writeInt(0);
            this.startCode = this.tsize;
        }
        this.mW = 0;
        if (!isAbstract) {
            this.currMethod = m;
        }
    }

    private void finishMethod() {
        if (this.currMethod != null) {
            int codeEnd = this.tsize;
            this.writeShort(0);
            this.writeShort(0);
            int currPos = this.tsize;
            this.tsize = this.startCodeAttr + 2;
            this.writeInt(currPos - this.startCodeAttr - 6);
            this.tsize = this.startCodeAttr + 6;
            this.writeShort(this.mW);
            this.tsize = this.startCode - 2;
            this.writeShort(codeEnd - this.startCode);
            this.tsize = currPos;
            this.currMethod = null;
        }
    }

    public byte[] getImage() {
        ByteArrayOutputStream image = new ByteArrayOutputStream();
        try {
            this.finishMethod();
            this.writeShort(0);
            int otsize = this.tsize;
            this.tsize = this.nMethodsPatch;
            this.writeShort(this.nMethods);
            this.tsize = otsize;
            image.write(prologue);
            image.write(this.poolEntries >>> 8 & 0xFF);
            image.write(this.poolEntries >>> 0 & 0xFF);
            this.constPoolData.writeTo(image);
            image.write(this.text, 0, this.tsize);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return image.toByteArray();
    }

    public void noteStk(int s, int a) {
        Debug.assert(this.cW <= this.mW);
        Debug.assert(s != 9 && a != 9);
        if (s >= 0) {
            --this.cW;
            if ((s & 0xFFFFFFFD) == 5) {
                --this.cW;
            }
            Debug.assert(this.cW >= 0);
        }
        if (a >= 0) {
            ++this.cW;
            if ((a & 0xFFFFFFFD) == 5) {
                ++this.cW;
            }
            if (this.cW > this.mW) {
                this.mW = this.cW;
            }
        }
    }

    public final void codeB(long op) {
        while (op != 0L) {
            this.write((byte)(op & 0xFFL));
            op >>>= 8;
        }
    }

    public final void codeM(Member m) {
        int modifiers = m.getModifiers();
        if (Library.isField(m)) {
            if ((modifiers & 8) > 0) {
                this.code(178L);
            } else {
                this.code(180L);
            }
            this.writeShort(this.getIndex(m, 12));
        } else {
            boolean inInterface = false;
            int cfID = 10;
            if (m instanceof Constructor) {
                this.code(183L);
                ++cfID;
            } else if ((modifiers & 8) > 0) {
                this.code(184L);
            } else {
                Class<?> dClass = m.getDeclaringClass();
                inInterface = dClass != null && dClass.isInterface();
                if (inInterface) {
                    this.code(185L);
                } else {
                    this.code(182L);
                }
            }
            this.writeShort(this.getIndex(m, cfID));
            if (inInterface) {
                this.writeShort(1 + ((Method)m).getParameterTypes().length << 8);
            }
        }
    }

    public final void code(long op) {
        while (op != 0L) {
            char opc = (char)(op & 0xFFL);
            Debug.assert(opc != '\u00ff');
            switch (opc - 228) {
                case 0: {
                    this.code(244L);
                    this.branchStack.push(this.cW);
                    break;
                }
                case 1: {
                    this.code(59386L);
                    int beforeStk = this.branchStack.pop();
                    this.branchStack.push(this.cW);
                    Debug.assert(this.cW >= beforeStk);
                    this.cW = beforeStk;
                    this.code(3991728807L);
                    break;
                }
                case 2: {
                    this.code(250L);
                    Debug.assert(this.branchStack.pop() == this.cW, "Stack mismatch when compiling conditional");
                    this.code(61417L);
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.cstk[opc - 228].pop();
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    this.cstk[opc - 231].push(this.cstk[opc - 234].size());
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    int blocked_at = 0;
                    IntegerStack blk = this.cstk[opc - 234];
                    IntegerStack jmp = this.cstk[opc - 237];
                    if (blk.size() > 0) {
                        blocked_at = blk.peek();
                    }
                    while (jmp.size() > blocked_at) {
                        int addrpos;
                        int currpos = this.tsize;
                        this.tsize = addrpos = jmp.pop();
                        this.writeShort(currpos - addrpos + 1);
                        this.tsize = currpos;
                    }
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    this.cstk[opc - 240].push(this.tsize);
                    this.writeShort(0);
                    break;
                }
                case 15: {
                    this.currJump = (int)((op >>>= 8) & 0xFFL);
                    break;
                }
                case 16: 
                case 17: {
                    int s = opc - 244;
                    this.code(249L);
                    if (this.iNJ ^ s == 0) {
                        Debug.assert(this.currJump >= 153 && this.currJump <= 166, "Attempt to invert non jump bytecode (" + this.currJump + ")");
                        this.currJump = (this.currJump - 1 ^ 1) + 1;
                    }
                    this.iNJ = false;
                    this.code(62208 + this.currJump);
                    this.code(15396336 + (s << 16) + ((s ^ 1) << 8) + s);
                    break;
                }
                case 18: 
                case 19: {
                    this.cstk[opc - 243].pop();
                    break;
                }
                case 20: {
                    this.code(15198441L);
                    break;
                }
                case 21: {
                    if (this.currJump != 0) break;
                    this.noteStk(0, -1);
                    this.currJump = 157;
                    break;
                }
                case 22: {
                    boolean noPendingJumps = false;
                    if (this.currJump == 0) {
                        int blocked0 = 0;
                        if (this.cstk[3].size() > 0) {
                            blocked0 = this.cstk[3].peek();
                        }
                        int blocked1 = 0;
                        if (this.cstk[4].size() > 0) {
                            blocked1 = this.cstk[4].peek();
                        }
                        boolean bl = noPendingJumps = this.cstk[0].size() == blocked0 && this.cstk[1].size() == blocked1;
                    }
                    if (noPendingJumps) break;
                    this.code(228L);
                    this.codeLDC(Boolean.TRUE, 0);
                    this.code(229L);
                    this.codeLDC(Boolean.FALSE, 0);
                    this.code(230L);
                    break;
                }
                case 23: {
                    this.code(15395820L);
                    break;
                }
                case 24: {
                    this.code(249L);
                    IntegerStack.swap(this.cstk[1], this.cstk[4].pop(), this.cstk[0], this.cstk[3].pop());
                    this.cstk[5].pop();
                    this.iNJ = !this.iNJ;
                    break;
                }
                case 25: {
                    this.writeShort(this.getIndex(specialClasses[(int)((op >>>= 8) & 0xFFL)], 9));
                    break;
                }
                case 26: {
                    this.codeM(specialMethods[(int)((op >>>= 8) & 0xFFL)]);
                    break;
                }
                default: {
                    Debug.assert(opc != '\u00ff');
                    this.write(opc);
                }
            }
            op >>>= 8;
        }
    }

    public final void codeLDC(Object o, int primitiveID) {
        Debug.assert(primitiveID >= 0 && primitiveID < 8 || primitiveID == 8 && o == null || primitiveID == 10 && o instanceof StringBuffer || primitiveID == 11 && o instanceof String);
        int short_opcodes = 0;
        boolean tsb_store = false;
        int iv = -1;
        switch (primitiveID) {
            case 0: {
                iv = (Boolean)o != false ? 1 : 0;
            }
            case 2: {
                if (iv < 0) {
                    iv = ((Character)o).charValue();
                }
            }
            case 1: 
            case 3: 
            case 4: {
                if (iv < 0) {
                    iv = ((Number)o).intValue();
                }
                if (iv >= -1 && iv <= 5) {
                    short_opcodes = iv + 3;
                    break;
                }
                if (iv < -128 || iv > 127) break;
                short_opcodes = 0x10 | (iv & 0xFF) << 8;
                break;
            }
            case 5: {
                long lv = (Long)o;
                if (((lv | 1L) ^ 1L) == 0L) {
                    short_opcodes = 9 + (int)lv;
                    break;
                }
                if (lv < -1L || lv > 5L) break;
                short_opcodes = 34051 + (int)lv;
                break;
            }
            case 6: {
                float fv = ((Float)o).floatValue();
                if (fv == 0.0f) {
                    short_opcodes = 11;
                    break;
                }
                if (fv == 1.0f) {
                    short_opcodes = 12;
                    break;
                }
                if (fv != 2.0f) break;
                short_opcodes = 13;
                break;
            }
            case 7: {
                double dv = (Double)o;
                if (dv == 0.0) {
                    short_opcodes = 14;
                    break;
                }
                if (dv != 1.0) break;
                short_opcodes = 15;
                break;
            }
            case 8: {
                if (o != null) break;
                short_opcodes = 1;
                break;
            }
            case 10: {
                tsb_store = true;
            }
            case 11: {
                short_opcodes = 0;
                primitiveID = 8;
                break;
            }
            default: {
                Debug.assert(false, "Loading of object constants is not supported by the Java class files.");
            }
        }
        if (short_opcodes == 0) {
            int cpindex;
            boolean dword_const;
            boolean bl = dword_const = primitiveID == 5 || primitiveID == 7;
            if (tsb_store) {
                this.code(2191928458683L);
                this.noteStk(-1, 10);
                cpindex = this.getIndex(o.toString(), primitiveID);
            } else {
                cpindex = this.getIndex(o, primitiveID);
            }
            Debug.assert(cpindex >= 0 && cpindex <= 65535);
            if (!dword_const && cpindex <= 255) {
                this.write(18);
                this.write(cpindex);
            } else {
                int opc = 19;
                if (dword_const) {
                    ++opc;
                }
                this.write(opc);
                this.writeShort(cpindex);
            }
        } else {
            this.codeB(short_opcodes);
        }
        this.noteStk(-1, primitiveID);
        if (tsb_store) {
            this.code(2302L);
            this.noteStk(11, -1);
        }
    }

    private int getUTFIndex(String str) {
        Integer index = (Integer)this.UTFs.get(str);
        if (index == null) {
            index = new Integer(this.poolEntries++);
            try {
                this.constPool.write(1);
                this.constPool.writeUTF(str);
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            this.UTFs.put(str, index);
        }
        return index;
    }

    private int typeID(Object item) {
        int id = OP.typeIDObject(item);
        if (id < 8) {
            return id;
        }
        if (item instanceof String) {
            return 8;
        }
        if (item instanceof Class) {
            return 9;
        }
        if (item instanceof Member) {
            return 10;
        }
        return -1;
    }

    private final int getIndex(Object item) {
        return this.getIndex(item, this.typeID(item));
    }

    public int getIndex(Object item, int typeid) {
        Integer index = (Integer)this.Items.get(item);
        if (index == null) {
            int newIndex = -1;
            try {
                int ival = -1;
                switch (typeid) {
                    case 0: {
                        ival = (Boolean)item != false ? 1 : 0;
                    }
                    case 2: {
                        if (ival < 0) {
                            ival = ((Character)item).charValue();
                        }
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        if (ival < 0) {
                            ival = ((Number)item).intValue();
                        }
                        newIndex = this.poolEntries++;
                        this.constPool.write(3);
                        this.constPool.writeInt(ival);
                        break;
                    }
                    case 5: {
                        newIndex = this.poolEntries;
                        this.constPool.write(5);
                        this.constPool.writeLong((Long)item);
                        this.poolEntries += 2;
                        break;
                    }
                    case 6: {
                        newIndex = this.poolEntries++;
                        this.constPool.write(4);
                        this.constPool.writeFloat(((Float)item).floatValue());
                        break;
                    }
                    case 7: {
                        newIndex = this.poolEntries;
                        this.constPool.write(6);
                        this.constPool.writeDouble((Double)item);
                        this.poolEntries += 2;
                        break;
                    }
                    case 8: {
                        int UTFIndex = this.getUTFIndex((String)item);
                        newIndex = this.poolEntries++;
                        this.constPool.write(8);
                        this.constPool.writeShort(UTFIndex);
                        break;
                    }
                    case 9: {
                        String histNameStr = Library.toHistoricalForm(((Class)item).getName());
                        int UTFIndex = this.getUTFIndex(histNameStr);
                        newIndex = this.poolEntries++;
                        this.constPool.write(7);
                        this.constPool.writeShort(UTFIndex);
                        break;
                    }
                    case 10: 
                    case 11: 
                    case 12: {
                        Member member = (Member)item;
                        Class<?> dClass = member.getDeclaringClass();
                        int entryType = Library.isField(member) ? 9 : (dClass != null && dClass.isInterface() ? 11 : 10);
                        newIndex = this.writeMemberRef(member, entryType);
                        break;
                    }
                    default: {
                        Debug.println("Can't place an item of type \"" + item.getClass().getName() + "\" to the constant pool.");
                        break;
                    }
                }
            }
            catch (IOException e) {
                Debug.reportThrowable(e);
            }
            index = new Integer(newIndex);
            this.Items.put(item, index);
        }
        return index;
    }

    private int writeMemberRef(Member member, int entry) throws IOException {
        Debug.assert(entry == 10 || entry == 9 || entry == 11);
        int name_ind = this.getUTFIndex(member instanceof Constructor ? "<init>" : member.getName());
        int sign_ind = this.getUTFIndex(Library.getSignature(member));
        Class<?> dClass = member.getDeclaringClass();
        int cls_ind = dClass == null ? 2 : this.getIndex(dClass, 9);
        int nat_ind = this.poolEntries++;
        this.constPool.write(12);
        this.constPool.writeShort(name_ind);
        this.constPool.writeShort(sign_ind);
        int index = this.poolEntries++;
        this.constPool.write(entry);
        this.constPool.writeShort(cls_ind);
        this.constPool.writeShort(nat_ind);
        return index;
    }

    public static void main(String[] args) {
        Tester t = new Tester(System.out);
        ClassFile.test(t);
        t.summarize();
    }

    static void dumpImage(ClassFile cf) {
        try {
            FileOutputStream fos = new FileOutputStream("dump.class");
            fos.write(cf.getImage());
            fos.close();
        }
        catch (Exception e) {
            Debug.println("Can't dump generated class file.");
        }
    }

    public static void test(Tester t) {
        int i;
        LocalField[] lf = new LocalField[]{new LocalField(2, new Object[0].getClass(), "e", null)};
        ClassFile cf = new ClassFile(1, "dump", new Object().getClass(), null, lf);
        t.startTest("Add UTF twice");
        String s1 = "some string";
        int si = cf.getUTFIndex(s1);
        int sii = cf.getUTFIndex(s1);
        t.compare(sii, si);
        t.startTest("Add Long twice");
        int li = cf.getIndex(new Long(15L), 5);
        int lii = cf.getIndex(new Long(15L), 5);
        t.compare(lii, li);
        t.startTest("Add Integer twice");
        int ii = cf.getIndex(new Integer(15), 4);
        int iii = cf.getIndex(new Integer(15), 4);
        t.compare(iii, ii);
        t.startTest("Add Float twice");
        int ff = cf.getIndex(new Float(15.0f), 6);
        int fff = cf.getIndex(new Float(15.0f), 6);
        t.compare(fff, ff);
        t.startTest("Add Double twice");
        int di = cf.getIndex(new Double(15.0), 7);
        int dii = cf.getIndex(new Double(15.0), 7);
        t.compare(dii, di);
        t.startTest("Add a new String twice");
        String s2 = "some other string";
        int s2i = cf.getIndex(s2, 8);
        int s2ii = cf.getIndex(s2, 8);
        t.compare(s2ii, s2i);
        t.startTest("Add a string with existing UTF twice");
        int s3i = cf.getIndex(s1, 8);
        int s3ii = cf.getIndex(s1, 8);
        t.compare(s3ii, s3i);
        t.startTest("Add a class twice");
        int ci = cf.getIndex(cf.getClass(), 9);
        int cii = cf.getIndex(cf.getClass(), 9);
        t.compare(cii, ci);
        t.startTest("Add a method twice");
        Class[] params = new Class[1];
        try {
            params[0] = Class.forName("gnu.jel.debug.Tester");
            Method a_method = cf.getClass().getMethod("test", params);
            int mi = cf.getIndex(a_method, 10);
            int mii = cf.getIndex(a_method, 10);
            t.compare(mii, mi);
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        Library lib = null;
        Object[] dynalib = null;
        t.startTest("Construct a library of java.lang.Math functions");
        try {
            Class[] stat = new Class[]{Class.forName("java.lang.Math")};
            Class[] dyn = new Class[]{Class.forName("java.lang.Double")};
            lib = new Library(stat, dyn);
            dynalib = new Object[]{new Double(100.0)};
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        byte[] image = null;
        LocalMethod[] eval_methods = new LocalMethod[10];
        ClassFile cf_orig = null;
        int retID_patchback = 0;
        t.startTest("Construct a compiled expression subclass");
        try {
            Class[] paramsE = new Class[]{new Object[0].getClass()};
            i = 0;
            while (i < 9) {
                String name = "evaluate";
                Class<?> cls = OP.specialTypes[i];
                if (i != 8) {
                    name = name + '_' + cls;
                } else {
                    cls = new Object().getClass();
                }
                eval_methods[i] = new LocalMethod(1, cls, name, paramsE, null);
                ++i;
            }
            Class<?> cmplExpr = Class.forName("gnu.jel.CompiledExpression");
            cf = new ClassFile(1, "dump", cmplExpr, null, lf);
            LocalMethod cnstr = new LocalMethod(1, Void.TYPE, "<init>", null, null);
            cf.newMethod(cnstr, null);
            cf.code(42L);
            cf.noteStk(-1, 11);
            Constructor<?> supInit = cmplExpr.getConstructor(new Class[0]);
            cf.code(183L);
            cf.writeShort(cf.getIndex(supInit));
            cf.noteStk(11, -1);
            cf.code(177L);
            LocalMethod getType = new LocalMethod(1, Integer.TYPE, "getType", null, null);
            cf.newMethod(getType, null);
            cf.code(16L);
            retID_patchback = cf.tsize;
            cf.code(8L);
            cf.noteStk(-1, 4);
            cf.code(172L);
            cf.noteStk(4, -1);
            cf_orig = (ClassFile)cf.clone();
            cf.newMethod(eval_methods[8], null);
            cf.code(1L);
            cf.noteStk(-1, 11);
            cf.code(176L);
            cf.noteStk(11, -1);
            image = cf.getImage();
            t.testOK();
        }
        catch (Exception e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        t.startTest("Load and execute constructed class");
        try {
            boolean ok;
            ClassFile.dumpImage(cf);
            CompiledExpression expr = (CompiledExpression)ImageLoader.load(image).newInstance();
            boolean bl = ok = expr.getType() == 8 && expr.evaluate(null) == null;
            if (ok) {
                t.testOK();
            } else {
                t.testFail();
            }
        }
        catch (Throwable e) {
            t.testFail();
            Debug.reportThrowable(e);
        }
        ClassFile.exprTest("1 (I)", dynalib, lib, new Integer(1), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("1 -- (I)", dynalib, lib, new Integer(-1), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("1 --", dynalib, lib, new Integer(-1), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("1L --", dynalib, lib, new Long(-1L), cf_orig, retID_patchback, eval_methods, t, false);
        byte i2 = 0;
        while (i2 <= 6) {
            ClassFile.exprTest(String.valueOf(i2), dynalib, lib, new Byte(i2), cf_orig, retID_patchback, eval_methods, t, false);
            ClassFile.exprTest(String.valueOf(i2) + 'L', dynalib, lib, new Long(i2), cf_orig, retID_patchback, eval_methods, t, false);
            i2 = (byte)(i2 + 1);
        }
        i = 0;
        while (i <= 3) {
            ClassFile.exprTest(String.valueOf(i) + ".0F", dynalib, lib, new Float(i), cf_orig, retID_patchback, eval_methods, t, false);
            ClassFile.exprTest(String.valueOf(i) + ".0", dynalib, lib, new Double(i), cf_orig, retID_patchback, eval_methods, t, false);
            i = (byte)(i + 1);
        }
        ClassFile.exprTest("true", dynalib, lib, Boolean.TRUE, cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("false", dynalib, lib, Boolean.FALSE, cf_orig, retID_patchback, eval_methods, t, false);
        int i3 = 126;
        while (i3 <= 128) {
            ClassFile.exprTest(String.valueOf(i3) + " (I)", dynalib, lib, new Integer(i3), cf_orig, retID_patchback, eval_methods, t, false);
            ClassFile.exprTest(String.valueOf(i3) + " -- (I)", dynalib, lib, new Integer(-i3), cf_orig, retID_patchback, eval_methods, t, false);
            ++i3;
        }
        ClassFile.exprTest("( 1 , 2 , min)", dynalib, lib, new Integer(1), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("( ( E) , sin)", dynalib, lib, new Double(Math.sin(Math.E)), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("2 , 2 , *", dynalib, lib, new Integer(4), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("3 , 2 , * , 1 , -", dynalib, lib, new Integer(5), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("3 , 2 , * , 1 , - , 3 , - , 2 , *", dynalib, lib, new Integer(4), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("3 , 2 , * , 1 , - , 3 , - , 2 , * , 4 , ==", dynalib, lib, Boolean.TRUE, cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("\"a\" , \"b\" , + , 4 , + , true , +", dynalib, lib, "ab4true", cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("2 , 3 , > , 3 , 2 , >= , ||", dynalib, lib, Boolean.TRUE, cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("( isNaN)", dynalib, lib, Boolean.FALSE, cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("1 , ( doubleValue) , + , 101 , ==", dynalib, lib, Boolean.TRUE, cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("( true ? 1 : 2 ) (I)", dynalib, lib, new Integer(1), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("( false ? 1 : 2 ) (I)", dynalib, lib, new Integer(2), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("( false ? 1 : 2 , 2 , + ) (I)", dynalib, lib, new Integer(4), cf_orig, retID_patchback, eval_methods, t, false);
        ClassFile.exprTest("( true ? ( 1 , 3 , + , 5 , min) : 2 ) (I)", dynalib, lib, new Integer(4), cf_orig, retID_patchback, eval_methods, t, true);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void exprTest(String expr, Object[] thisPtrs, Library lib, Object expRes, ClassFile cf_orig, int retID_patchback, LocalMethod[] eval_methods, Tester t, boolean verbose) {
        try {
            testTitle = new StringBuffer();
            i = 0;
            while (i < expr.length()) {
                if (expr.charAt(i) != ' ') {
                    testTitle.append(expr.charAt(i));
                }
                ++i;
            }
            testTitle.append(" == ");
            id = OP.typeIDObject(expRes);
            if (id < 8) {
                testTitle.append(expRes);
                testTitle.append(id > 9 ? 'L' : "ZBCSIJFDLV".charAt(id));
            } else if (expRes instanceof String) {
                testTitle.append('\"');
                testTitle.append(expRes);
                testTitle.append('\"');
            } else {
                testTitle.append(expRes);
            }
            t.startTest(testTitle.toString());
            paramOPs = new Stack<OP>();
            paramsStart = new IntegerStack();
            oldLists = new Stack<E>();
            branchStack = new IntegerStack();
            try {
                sr = new StringReader(expr);
                cToken = new StringBuffer();
                block59: while ((cChar = sr.read()) > 0) {
                    while ((char)var17_21 == ' ' && (cChar = sr.read()) > 0) {
                    }
                    cToken.setLength(0);
                    while (cChar > 0 && (char)cChar != ' ') {
                        cToken.append((char)cChar);
                        cChar = sr.read();
                    }
                    if (cToken.length() <= 0) continue;
                    cTok = cToken.charAt(0);
                    switch (cTok) {
                        case '~': {
                            paramOPs.push(new OPunary(paramOPs, 1));
                            break;
                        }
                        case ',': {
                            break;
                        }
                        case '(': {
                            if (cToken.length() == 1) {
                                paramsStart.push(paramOPs.size());
                                break;
                            }
                            if (cToken.length() == 3) {
                                ttype = cToken.charAt(1);
                                primitiveCodes = new char[]{'Z', 'B', 'C', 'S', 'I', 'J', 'F', 'D', 'L', 'V', 'L', 'L'};
                                tid = 0;
                                while (tid < primitiveCodes.length && ttype != primitiveCodes[tid]) {
                                    ++tid;
                                }
                                paramOPs.push(new OPunary(paramOPs, tid, null, true));
                                break;
                            }
                            Debug.println("Wrong bracketed token \"" + cToken + "\".");
                            break;
                        }
                        case '?': {
                            break;
                        }
                        case ':': {
                            break;
                        }
                        case ')': {
                            paramOPs.push(new OPcondtnl(paramOPs));
                            break;
                        }
                        case '+': {
                            paramOPs.push(new OPbinary(paramOPs, 0));
                            break;
                        }
                        case '-': {
                            if (cToken.length() == 1) {
                                paramOPs.push(new OPbinary(paramOPs, 1));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '-') {
                                paramOPs.push(new OPunary(paramOPs, 0));
                                break;
                            }
                            Debug.println("Wrong token \"" + cTok + "\".");
                            break;
                        }
                        case '*': {
                            paramOPs.push(new OPbinary(paramOPs, 2));
                            break;
                        }
                        case '/': {
                            paramOPs.push(new OPbinary(paramOPs, 3));
                            break;
                        }
                        case '%': {
                            paramOPs.push(new OPbinary(paramOPs, 4));
                            break;
                        }
                        case '^': {
                            paramOPs.push(new OPbinary(paramOPs, 7));
                            break;
                        }
                        case '=': {
                            if (cToken.charAt(1) != '=') continue block59;
                            paramOPs.push(new OPbinary(paramOPs, 8));
                            break;
                        }
                        case '!': {
                            if (cToken.length() == 1) {
                                paramOPs.push(new OPunary(paramOPs, 2));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '=') {
                                paramOPs.push(new OPbinary(paramOPs, 9));
                                break;
                            }
                            Debug.println("Wrong ! token \"" + cTok + "\".");
                            break;
                        }
                        case '<': {
                            if (cToken.length() == 1) {
                                paramOPs.push(new OPbinary(paramOPs, 10));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '=') {
                                paramOPs.push(new OPbinary(paramOPs, 13));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '<') {
                                paramOPs.push(new OPbinary(paramOPs, 14));
                                break;
                            }
                            Debug.println("Wrong < token \"" + cTok + "\".");
                            break;
                        }
                        case '>': {
                            if (cToken.length() == 1) {
                                paramOPs.push(new OPbinary(paramOPs, 11));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '=') {
                                paramOPs.push(new OPbinary(paramOPs, 12));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '>') {
                                paramOPs.push(new OPbinary(paramOPs, 15));
                                break;
                            }
                            if (cToken.length() == 3 && cToken.charAt(2) == '>') {
                                paramOPs.push(new OPbinary(paramOPs, 16));
                                break;
                            }
                            Debug.println("Wrong > token \"" + cTok + "\".");
                            break;
                        }
                        case '&': {
                            if (cToken.length() == 1) {
                                paramOPs.push(new OPbinary(paramOPs, 5));
                                break;
                            }
                            if (cToken.length() == 3 && cToken.charAt(1) == '&') {
                                paramOPs.push(new OPbinary(paramOPs, 17));
                                break;
                            }
                            Debug.println("Wrong & token \"" + cTok + "\".");
                            break;
                        }
                        case '|': {
                            if (cToken.length() == 1) {
                                paramOPs.push(new OPbinary(paramOPs, 6));
                                break;
                            }
                            if (cToken.length() == 2 && cToken.charAt(1) == '|') {
                                paramOPs.push(new OPbinary(paramOPs, 18));
                                break;
                            }
                            Debug.println("Wrong | token \"" + cTok + "\".");
                            break;
                        }
                        case '[': {
                            if (cToken.length() == 3 && cToken.charAt(1) == ']') {
                                paramOPs.push(new OPbinary(paramOPs, 19));
                                break;
                            }
                            Debug.println("Wrong [ token \"" + cTok + "\".");
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            sval = cToken.toString();
                            if (sval.indexOf(46) > 0) {
                                lc = Character.toUpperCase(sval.charAt(sval.length() - 1));
                                makeFloat = lc == 'F';
                                svalue = sval;
                                if (lc == 'D' || lc == 'F') {
                                    svalue = svalue.substring(0, svalue.length() - 1);
                                }
                                value = null;
                                try {
                                    value = new Double(svalue);
                                }
                                catch (NumberFormatException e) {
                                    Debug.println("Can;t parse \"" + svalue + "\" as a floating point number.");
                                }
                                otl /* !! */  = null;
                                otlc /* !! */  = null;
                                if (makeFloat) {
                                    otl /* !! */  = new Float(value.floatValue());
                                    otlc /* !! */  = Float.TYPE;
                                } else {
                                    otl /* !! */  = value;
                                    otlc /* !! */  = Double.TYPE;
                                }
                                paramOPs.push(new OPload(otl /* !! */ ));
                                break;
                            }
                            svalue = sval.toUpperCase();
                            value = 0L;
                            makelong = svalue.endsWith("L");
                            if (makelong) {
                                svalue = svalue.substring(0, svalue.length() - 1);
                            }
                            try {
                                if (svalue.startsWith("0X")) {
                                    svalue = svalue.substring(2);
                                    value = Long.parseLong(svalue, 16);
                                } else {
                                    value = svalue.startsWith("0") ? Long.parseLong(svalue, 8) : Long.parseLong(svalue, 10);
                                }
                            }
                            catch (NumberFormatException e) {
                                Debug.println("Number \"" + svalue + "\" is too large, it does not fit even " + "into 64 bit long.");
                            }
                            otl /* !! */  = null;
                            otlc /* !! */  = null;
                            if (!makelong) {
                                if (value <= 127L) {
                                    otl /* !! */  = new Byte((byte)value);
                                    otlc /* !! */  = Byte.TYPE;
                                } else if (value <= 32767L) {
                                    otl /* !! */  = new Short((short)value);
                                    otlc /* !! */  = Short.TYPE;
                                } else if (value <= 0x7FFFFFFFL) {
                                    otl /* !! */  = new Integer((int)value);
                                    otlc /* !! */  = Integer.TYPE;
                                } else {
                                    Debug.println("Integer number \"" + svalue + "\" is too large for type 'int'. Be sure" + " to add 'L' suffix to use 'long' type.");
                                }
                            } else {
                                otl /* !! */  = new Long(value);
                                otlc /* !! */  = Long.TYPE;
                            }
                            paramOPs.push(new OPload(otl /* !! */ ));
                            break;
                        }
                        case '\'': {
                            sval = cToken.toString().substring(1, cToken.length() - 1);
                            chr = sval.charAt(0);
                            if (sval.length() != 1) {
                                ec = sval.charAt(1);
                                try {
                                    switch (ec) {
                                        case 110: {
                                            ec = 10;
                                            break;
                                        }
                                        case 116: {
                                            ec = 9;
                                            break;
                                        }
                                        case 98: {
                                            ec = 8;
                                            break;
                                        }
                                        case 114: {
                                            ec = 13;
                                            break;
                                        }
                                        case 102: {
                                            ec = 12;
                                            break;
                                        }
                                        case 92: {
                                            ec = 92;
                                            break;
                                        }
                                        case 39: {
                                            ec = 39;
                                            break;
                                        }
                                        case 34: {
                                            ec = 34;
                                            break;
                                        }
                                        default: {
                                            ec = (char)Integer.parseInt(sval.substring(1), 8);
                                            break;
                                        }
                                    }
                                }
                                catch (NumberFormatException e) {
                                    Debug.println("Can;t parse \"" + cToken + "\" as a character literal.");
                                }
                                chr = ec;
                            }
                            paramOPs.push(new OPload(new Character((char)chr)));
                            break;
                        }
                        case '\"': {
                            sval = cToken.toString().substring(1, cToken.length() - 1);
                            unescaped = new StringBuffer(sval.length());
                            i = 0;
                            while (i < sval.length()) {
                                ec = sval.charAt(i);
                                if (ec != 92) ** GOTO lbl336
                                ec = sval.charAt(++i);
                                switch (ec) {
                                    case 110: {
                                        ec = 10;
                                        break;
                                    }
                                    case 116: {
                                        ec = 9;
                                        break;
                                    }
                                    case 98: {
                                        ec = 8;
                                        break;
                                    }
                                    case 114: {
                                        ec = 13;
                                        break;
                                    }
                                    case 102: {
                                        ec = 12;
                                        break;
                                    }
                                    case 92: {
                                        ec = 92;
                                        break;
                                    }
                                    case 39: {
                                        ec = 39;
                                        break;
                                    }
                                    case 34: {
                                        ec = 34;
                                        break;
                                    }
                                    default: {
                                        nval = 0;
                                        if (true) ** GOTO lbl330
                                        do {
                                            nval <<= 3 + (ec - 48);
                                            ++i;
lbl330:
                                            // 2 sources

                                            if (i >= sval.length()) break;
                                            v0 = sval.charAt(i);
                                            ec = v0;
                                        } while (v0 >= '0' && ec <= 55);
                                        --i;
                                        ec = (char)nval;
                                    }
                                }
lbl336:
                                // 10 sources

                                unescaped.append((char)ec);
                                ++i;
                            }
                            paramOPs.push(new OPload(unescaped.toString()));
                            break;
                        }
                        default: {
                            if (cToken.toString().equals("true")) {
                                paramOPs.push(new OPload(Boolean.TRUE));
                                break;
                            }
                            if (cToken.toString().equals("false")) {
                                paramOPs.push(new OPload(Boolean.FALSE));
                                break;
                            }
                            cToken.setLength(cToken.length() - 1);
                            ps = paramsStart.pop();
                            np = paramOPs.size() - ps;
                            params = new Class[np];
                            paramsOPs = new OP[np];
                            i = np - 1;
                            while (i >= 0) {
                                paramsOPs[i] = (OP)paramOPs.pop();
                                params[i] = paramsOPs[i].resType;
                                --i;
                            }
                            m = null;
                            try {
                                m = lib.getMember(null, cToken.toString(), params);
                            }
                            catch (CompilationException exc) {
                                Debug.println("Can't find method \"" + cToken + "\".");
                            }
                            if ((m.getModifiers() & 8) == 0) {
                                paramOPs.push(new OPcall(1, new Object[0].getClass()));
                                classID = lib.getDynamicMethodClassID(m);
                                paramOPs.push(new OPload(new Integer(classID)));
                                paramOPs.push(new OPbinary(paramOPs, 19));
                            }
                            i = 0;
                            while (i < np) {
                                paramOPs.push(paramsOPs[i]);
                                ++i;
                            }
                            paramOPs.push(new OPcall(paramOPs, m, false));
                        }
                    }
                }
            }
            catch (IOException exc) {
                // empty catch block
            }
            if (((OP)paramOPs.peek()).resID == 10) {
                paramOPs.push(new OPunary(paramOPs, 11, null, false));
            }
            rop = (OP)paramOPs.peek();
            retID = rop.resID > 9 ? 8 : rop.resID;
            retType = rop.resType;
            paramOPs.push(new OPunary(paramOPs, 3));
            if (paramOPs.size() != 1) {
                Debug.println("Extra paramOPs left in stack when compiling.");
            }
            program = (OP)paramOPs.pop();
            name = "evaluate";
            if (retID != 8) {
                name = name + '_' + retType;
            }
            ok = true;
            i = 0;
            while (i < 2) {
                if (verbose) {
                    t.print(ClassFile.toStr(program));
                }
                cf = (ClassFile)cf_orig.clone();
                otsize = cf.tsize;
                cf.tsize = retID_patchback;
                cf.write(retID);
                cf.tsize = otsize;
                cf.newMethod(eval_methods[retID], null);
                program.compile(cf);
                image = cf.getImage();
                ClassFile.dumpImage(cf);
                cexpr = (CompiledExpression)ImageLoader.load(image).newInstance();
                res = cexpr.evaluate(thisPtrs);
                v1 = localOK = expRes == null && expRes == res || expRes.equals(res) != false;
                if (verbose) {
                    t.print(" == ");
                    t.print(res);
                    t.print("  ");
                    if (localOK) {
                        t.print("ok.");
                    } else {
                        t.print("WRONG !!!");
                    }
                    t.println("");
                }
                ok = ok != false && localOK != false;
                try {
                    program = new OPload(program, program.eval());
                }
                catch (Exception exc) {
                    // empty catch block
                }
                ++i;
            }
            if (ok) {
                t.testOK();
            } else {
                t.testFail();
            }
            if (!(ok | verbose)) {
                ClassFile.exprTest(expr, thisPtrs, lib, expRes, cf_orig, retID_patchback, eval_methods, t, true);
            }
        }
        catch (Throwable thr) {
            Debug.reportThrowable(thr);
            t.testFail();
            System.exit(9);
        }
    }

    public static String toStr(OP o) {
        if (o instanceof OPload) {
            OPload op = (OPload)o;
            if (op.resID == 8) {
                return "\"" + op.what + "\"";
            }
            return op.what.toString() + (op.resID > 9 ? (char)'L' : "ZBCSIJFDLV".charAt(op.resID));
        }
        if (o instanceof OPbinary) {
            String[] opSymbols = new String[]{"+", "-", "*", "/", "%", "&", "|", "^", "==", "!=", "<", ">=", ">", "<=", "<<", ">>", ">>>", "&&", "||", "{}", ".+."};
            OPbinary op = (OPbinary)o;
            return ClassFile.toStr(op.chi[0]) + opSymbols[op.code] + ClassFile.toStr(op.chi[1]);
        }
        if (o instanceof OPunary) {
            String[] opSymbols = new String[]{"--", "~", "!", "<RET>", "(Z)", "(B)", "(C)", "(S)", "(I)", "(J)", "(F)", "(D)", "(L)", "(POP)", "->TSB", "->STR"};
            OPunary op = (OPunary)o;
            return opSymbols[op.code] + ClassFile.toStr(op.chi[0]);
        }
        if (o instanceof OPcall) {
            OPcall op = (OPcall)o;
            if (op.m == null) {
                return "{" + op.nplv + "}";
            }
            StringBuffer res = new StringBuffer(op.m.getName());
            res.append('(');
            int i = 0;
            while (i < op.chi.length) {
                if (i > 0) {
                    res.append(",");
                }
                res.append(ClassFile.toStr(op.chi[i]));
                ++i;
            }
            res.append(')');
            return res.toString();
        }
        if (o instanceof OPcondtnl) {
            OPcondtnl op = (OPcondtnl)o;
            StringBuffer res = new StringBuffer();
            if (op.chi[1] != null) {
                res.append('(');
            }
            res.append(ClassFile.toStr(op.chi[0]));
            if (op.chi[1] != null) {
                res.append('?');
                res.append(ClassFile.toStr(op.chi[1]));
                res.append(':');
                res.append(ClassFile.toStr(op.chi[2]));
                res.append(')');
            }
            return res.toString();
        }
        return "<<<<<OP TYPE NOT IDENTIFIED>>>>";
    }

    /*
     * Unable to fully structure code
     */
    static {
        block10: {
            ClassFile.prologue = new byte[]{-54, -2, -70, -66, 0, 3, 0, 45};
            Debug.assert(OP.specialTypes.length == 29, "You changed special types in TypesStack please update specialClasses array in ClassFile.");
            ClassFile.specialClasses = (Class[])TableKeeper.getTable("specialClasses");
            specialMds = (char[][])TableKeeper.getTable("specialMds");
            specialMdsN = (String[])TableKeeper.getTable("specialMdsN");
            ClassFile.specialMethods = new Member[specialMds.length];
            definingClass = null;
            name = null;
            params = null;
            i = 0;
            try {
                i = 0;
                while (i < specialMds.length) {
                    defClassID = specialMds[i][0] % 100;
                    definingClass = ClassFile.specialClasses[defClassID];
                    name = specialMdsN[specialMds[i][1]];
                    params = new Class[specialMds[i].length - 2];
                    j = 0;
                    while (j < params.length) {
                        params[j] = ClassFile.specialClasses[specialMds[i][2 + j]];
                        ++j;
                    }
                    switch (specialMds[i][0] / 100) {
                        case 0: {
                            ClassFile.specialMethods[i] = definingClass.getMethod(name, params);
                            break;
                        }
                        case 1: {
                            ClassFile.specialMethods[i] = definingClass.getConstructor(params);
                            break;
                        }
                        case 2: {
                            Debug.assert(params.length == 0);
                            ClassFile.specialMethods[i] = definingClass.getField(name);
                            break;
                        }
                        default: {
                            throw new Exception("JEL: Wrong class ID modifier.");
                        }
                    }
                    ++i;
                }
                break block10;
            }
            catch (Exception exc) {
                Debug.println("JEL: Problem with special method [" + i + "] " + name + " in " + definingClass);
                j = 0;
                ** while (j < params.length)
            }
lbl-1000:
            // 1 sources

            {
                Debug.println("parameter[" + j + "]=" + params[j]);
                ++j;
                continue;
            }
lbl46:
            // 1 sources

            Debug.reportThrowable(exc);
        }
    }
}

