/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.util.TextUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LEFDEF
extends Input<Object> {
    protected static final boolean PLACELEFGEOMETRY = true;
    protected static final boolean PLACELEFEXPORTS = true;
    protected static Map<String, ViaDef> viaDefsFromLEF;
    protected static Map<ArcProto, Double> widthsFromLEF;
    protected static Map<String, Double> layerWidthsFromLEF;
    protected static Map<String, GetLayerInformation> knownLayers;
    protected static Variable.Key prXkey;
    protected static Variable.Key prYkey;
    protected Technology curTech;
    private boolean viaDigitsCombine;

    public static Collection<GetLayerInformation> getKnownLayers() {
        return knownLayers.values();
    }

    public static Map<String, Double> getLayerWidths() {
        return layerWidthsFromLEF;
    }

    LEFDEF(EditingPreferences ep) {
        super(ep);
    }

    protected void initializeLEFDEF(Technology tech) {
        this.curTech = tech;
        this.viaDigitsCombine = false;
        knownLayers = new HashMap<String, GetLayerInformation>();
        viaDefsFromLEF = new HashMap<String, ViaDef>();
    }

    protected GetLayerInformation getLayerInformation(String name) {
        GetLayerInformation li = knownLayers.get(name);
        if (li != null) {
            return li;
        }
        li = new GetLayerInformation(name);
        knownLayers.put(name, li);
        return li;
    }

    static {
        prXkey = Variable.newKey("ATTR_LEFwidth");
        prYkey = Variable.newKey("ATTR_LEFheight");
    }

    public class GetLayerInformation {
        String name;
        NodeProto pin;
        NodeProto pure;
        ArcProto arc;
        ArcProto.Function arcFun;
        Layer.Function layerFun;
        ArcProto viaArc1;
        ArcProto viaArc2;

        public boolean equals(GetLayerInformation other) {
            if (other == null) {
                return false;
            }
            return this.layerFun == other.layerFun && this.arcFun == other.arcFun;
        }

        public String getName() {
            return this.name;
        }

        public double getWidth(EditingPreferences ep) {
            if (this.arc != null) {
                return this.arc.getDefaultLambdaBaseWidth(ep);
            }
            if (this.pure != null) {
                return this.pure.getDefWidth(ep);
            }
            return 0.0;
        }

        private NodeProto getPureLayerNode() {
            if (LEFDEF.this.curTech == null) {
                return null;
            }
            Iterator<Layer> it = LEFDEF.this.curTech.getLayers();
            while (it.hasNext()) {
                Layer lay = it.next();
                if (lay.getFunction() != this.layerFun) continue;
                return lay.getPureLayerNode();
            }
            return null;
        }

        GetLayerInformation(String name) {
            this.initialize(name, null);
        }

        GetLayerInformation(String name, String type) {
            this.initialize(name, type);
        }

        private void initialize(String name, String type) {
            Layer lay;
            Iterator<Layer> it;
            String layerName;
            Layer lay2;
            this.name = name;
            this.pin = null;
            this.pure = null;
            this.arc = null;
            this.arcFun = ArcProto.Function.UNKNOWN;
            this.layerFun = Layer.Function.UNKNOWN;
            this.viaArc2 = null;
            this.viaArc1 = null;
            Technology tech = null;
            int colonPos = name.indexOf(58);
            tech = colonPos >= 0 ? Technology.findTechnology(name.substring(0, colonPos)) : LEFDEF.this.curTech;
            if (tech != null && (lay2 = tech.findLayer(layerName = name.substring(colonPos + 1))) != null) {
                this.layerFun = lay2.getFunction();
                this.pure = lay2.getPureLayerNode();
                Iterator<ArcProto> it2 = tech.getArcs();
                while (it2.hasNext()) {
                    ArcProto ap = it2.next();
                    Technology.ArcLayer[] parts = ap.getArcLayers();
                    for (int i = 0; i < parts.length; ++i) {
                        if (parts[i].getLayer() != lay2) continue;
                        this.arc = ap;
                        this.arcFun = this.arc.getFunction();
                        this.pin = this.arc.findPinProto();
                        break;
                    }
                    if (this.arc == null) continue;
                    break;
                }
                if (this.pin == null && layerName.toUpperCase().startsWith("VIA") && !this.setupViaLayer(layerName.substring(3))) {
                    System.out.println("ERROR: problems matching VIA '" + layerName + "' found in technology '" + tech.getTechName() + "'");
                }
                return;
            }
            if ((name = name.toUpperCase()).startsWith("POLY")) {
                this.setupPolyLayer(name.substring(4), name);
                return;
            }
            if (name.equals("PO")) {
                this.setupPolyLayer(name, name);
                return;
            }
            if (name.startsWith("PDIF")) {
                this.arcFun = ArcProto.Function.DIFFP;
                this.layerFun = Layer.Function.DIFFP;
                this.pure = this.getPureLayerNode();
                this.arc = this.getArc(this.arcFun);
                if (this.arc != null) {
                    this.pin = this.arc.findPinProto();
                }
                return;
            }
            if (name.startsWith("NDIF")) {
                this.arcFun = ArcProto.Function.DIFFN;
                this.layerFun = Layer.Function.DIFFN;
                this.pure = this.getPureLayerNode();
                this.arc = this.getArc(this.arcFun);
                if (this.arc != null) {
                    this.pin = this.arc.findPinProto();
                }
                return;
            }
            if (name.startsWith("PWEL")) {
                this.layerFun = Layer.Function.WELLP;
                this.pin = this.pure = this.getPureLayerNode();
                return;
            }
            if (name.startsWith("NWEL") || name.equals("NW")) {
                this.layerFun = Layer.Function.WELLN;
                this.pin = this.pure = this.getPureLayerNode();
                return;
            }
            if (name.equals("DIFF") || name.equals("OD")) {
                this.arcFun = ArcProto.Function.DIFF;
                this.layerFun = Layer.Function.DIFF;
                this.pure = this.getPureLayerNode();
                this.arc = this.getArc(this.arcFun);
                if (this.arc != null) {
                    this.pin = this.arc.findPinProto();
                }
                return;
            }
            if (name.equals("NP")) {
                this.layerFun = Layer.Function.IMPLANTN;
                this.pin = this.pure = this.getPureLayerNode();
                return;
            }
            if (name.equals("PP")) {
                this.layerFun = Layer.Function.IMPLANTP;
                this.pin = this.pure = this.getPureLayerNode();
                return;
            }
            if (name.equals("PDK") || name.equals("AP")) {
                this.layerFun = Layer.Function.ART;
                this.pin = this.pure = this.getPureLayerNode();
                return;
            }
            if (name.equals("CONT") || name.equals("CON") || name.equals("CO")) {
                this.layerFun = Layer.Function.CONTACT1;
                this.pin = this.pure = this.getPureLayerNode();
                return;
            }
            int j = 0;
            if (name.startsWith("VIA")) {
                j = 3;
            } else if (name.startsWith("V")) {
                j = 1;
            }
            if (j != 0 && this.setupViaLayer(name.substring(j))) {
                return;
            }
            j = 0;
            if (name.startsWith("METAL")) {
                j = 5;
            } else if (name.startsWith("MET")) {
                j = 3;
            } else if (name.startsWith("M")) {
                j = 1;
            }
            if (j != 0) {
                this.setupMetalLayer(name.substring(j));
                return;
            }
            if (type != null) {
                if (type.equalsIgnoreCase("masterslice")) {
                    name = name.toUpperCase();
                    j = 0;
                    if (name.startsWith("POLY")) {
                        j = 4;
                    } else if (name.startsWith("P")) {
                        j = 1;
                    }
                    this.setupPolyLayer(name.substring(j), name);
                    return;
                }
                if (type.equalsIgnoreCase("cut")) {
                    j = 0;
                    if ((name = name.toUpperCase()).startsWith("VIA")) {
                        j = 3;
                    } else if (name.startsWith("V")) {
                        j = 1;
                    }
                    if (this.setupViaLayer(name.substring(j))) {
                        return;
                    }
                }
                if (type.equalsIgnoreCase("routing")) {
                    j = 0;
                    if (name.startsWith("METAL")) {
                        j = 5;
                    } else if (name.startsWith("MET")) {
                        j = 3;
                    } else if (name.startsWith("M")) {
                        j = 1;
                    }
                    name = name.substring(j);
                    while (name.length() > 0 && !Character.isDigit(name.charAt(0))) {
                        name = name.substring(1);
                    }
                    this.setupMetalLayer(name);
                    return;
                }
            }
            if (LEFDEF.this.curTech != null) {
                it = LEFDEF.this.curTech.getLayers();
                while (it.hasNext()) {
                    lay = it.next();
                    if (!lay.getName().startsWith(name)) continue;
                    this.layerFun = lay.getFunction();
                    this.assignPureNodeBasedOnLay(lay);
                    return;
                }
            }
            if (name.indexOf("OVERLAP") >= 0) {
                if (LEFDEF.this.curTech != null) {
                    it = LEFDEF.this.curTech.getLayers();
                    while (it.hasNext()) {
                        lay = it.next();
                        if (lay.getName().toLowerCase().indexOf("prbound") < 0) continue;
                        this.layerFun = lay.getFunction();
                        this.assignPureNodeBasedOnLay(lay);
                        return;
                    }
                }
                this.layerFun = Layer.Function.ART;
                this.pin = this.pure = this.getPureLayerNode();
                return;
            }
            System.out.println("Error: cannot find a layer in technology " + (tech != null ? tech.getTechName() : "") + " named '" + name + "'");
        }

        private void assignPureNodeBasedOnLay(Layer lay) {
            Iterator<PrimitiveNode> pIt = LEFDEF.this.curTech.getNodes();
            while (pIt.hasNext()) {
                Technology.NodeLayer[] layersOnNode;
                PrimitiveNode pn = pIt.next();
                if (pn.getFunction() != PrimitiveNode.Function.NODE || (layersOnNode = pn.getNodeLayers())[0].getLayer() != lay) continue;
                this.pin = this.pure = pn;
                return;
            }
            System.out.println("Error: cannot find a pure layer node in technology " + LEFDEF.this.curTech.getTechName() + " for layer '" + lay.getName() + "'");
        }

        private void setupMetalLayer(String name) {
            int layNum = TextUtils.atoi(name);
            this.arcFun = ArcProto.Function.getMetal(layNum);
            this.layerFun = Layer.Function.getMetal(layNum);
            if (this.arcFun == null || this.layerFun == null || LEFDEF.this.curTech == null) {
                return;
            }
            this.arc = this.getArc(this.arcFun);
            if (this.arc != null) {
                this.pin = this.arc.findPinProto();
            }
            this.pure = this.getPureLayerNode();
        }

        private ArcProto getArc(ArcProto.Function fun) {
            if (LEFDEF.this.curTech == null) {
                return null;
            }
            Iterator<ArcProto> it = LEFDEF.this.curTech.getArcs();
            while (it.hasNext()) {
                ArcProto ap = it.next();
                if (ap.getFunction() != this.arcFun) continue;
                return ap;
            }
            return null;
        }

        private void setupPolyLayer(String name, String fullName) {
            try {
                int layNum = TextUtils.atoi(name);
                if (layNum == 0) {
                    layNum = 1;
                }
                this.arcFun = ArcProto.Function.getPoly(layNum);
                this.layerFun = Layer.Function.getPoly(layNum);
                if (this.arcFun == null || this.layerFun == null || LEFDEF.this.curTech == null) {
                    return;
                }
                this.arc = this.getArc(this.arcFun);
                if (this.arc != null) {
                    this.pin = this.arc.findPinProto();
                }
                this.pure = this.getPureLayerNode();
            }
            catch (Exception e) {
                System.out.println("ERROR Parsing Polysilicon layer '" + fullName + "'");
            }
        }

        private boolean setupViaLayer(String name) {
            if (LEFDEF.this.curTech == null) {
                return true;
            }
            ArcProto.Function aFunc1 = ArcProto.Function.UNKNOWN;
            ArcProto.Function aFunc2 = ArcProto.Function.UNKNOWN;
            if (name.length() <= 0) {
                aFunc1 = ArcProto.Function.METAL1;
                aFunc2 = ArcProto.Function.METAL2;
            } else if (name.length() <= 1) {
                int level = name.charAt(0) - 48;
                if (level < 0 || level > 9) {
                    return false;
                }
                aFunc1 = level == 0 ? ArcProto.Function.getPoly(1) : ArcProto.Function.getMetal(level);
                aFunc2 = ArcProto.Function.getMetal(level + 1);
            } else {
                int level1 = name.charAt(0) - 48;
                int level2 = name.charAt(1) - 48;
                if (level1 < 0 || level1 > 9) {
                    return false;
                }
                if (level2 < 0 || level2 > 9) {
                    return false;
                }
                if (!LEFDEF.this.viaDigitsCombine && level2 <= level1) {
                    LEFDEF.this.viaDigitsCombine = true;
                }
                if (LEFDEF.this.viaDigitsCombine) {
                    level1 = level1 * 10 + level2;
                    level2 = level1 + 1;
                }
                aFunc1 = level1 == 0 ? ArcProto.Function.getPoly(1) : ArcProto.Function.getMetal(level1);
                aFunc2 = ArcProto.Function.getMetal(level2);
            }
            Iterator<Comparable<ArcProto>> it = LEFDEF.this.curTech.getArcs();
            while (it.hasNext()) {
                ArcProto apTry = it.next();
                if (apTry.getFunction() == aFunc1) {
                    this.viaArc1 = apTry;
                }
                if (apTry.getFunction() != aFunc2) continue;
                this.viaArc2 = apTry;
            }
            if (this.viaArc1 == null || this.viaArc2 == null) {
                return false;
            }
            it = LEFDEF.this.curTech.getNodes();
            while (it.hasNext()) {
                PrimitiveNode np = (PrimitiveNode)it.next();
                if (np.getNumPorts() != 1) continue;
                PrimitivePort pp = np.getPort(0);
                boolean ap1Found = pp.connectsTo(this.viaArc1);
                boolean ap2Found = pp.connectsTo(this.viaArc2);
                if (!ap1Found || !ap2Found) continue;
                this.pin = np;
                break;
            }
            if (this.pin != null) {
                PrimitiveNode pNp = (PrimitiveNode)this.pin;
                Technology.NodeLayer[] nl = pNp.getNodeLayers();
                Layer viaLayer = null;
                for (int i = 0; i < nl.length; ++i) {
                    Technology.NodeLayer nLay = nl[i];
                    Layer lay = nLay.getLayer();
                    Layer.Function fun = lay.getFunction();
                    if (!fun.isContact()) continue;
                    viaLayer = lay;
                    this.layerFun = fun;
                    break;
                }
                if (viaLayer == null) {
                    return false;
                }
                this.pure = viaLayer.getPureLayerNode();
            }
            return true;
        }
    }

    protected static class ViaDef {
        protected String viaName;
        protected NodeProto via;
        protected GetLayerInformation gLay1;
        protected GetLayerInformation gLay2;
        protected double sX;
        protected double sY;

        public ViaDef(String name, NodeProto np) {
            this.viaName = name;
            this.sY = 0.0;
            this.sX = 0.0;
            this.via = np;
            this.gLay2 = null;
            this.gLay1 = null;
        }
    }
}

