/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.input;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.tool.io.input.Input;
import com.sun.electric.tool.simulation.ScalarSample;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.util.TextUtils;
import java.io.IOException;
import java.net.URL;

public class SmartSpiceOut
extends Input<Stimuli> {
    SmartSpiceOut() {
    }

    @Override
    protected Stimuli processInput(URL fileURL, Cell cell, Stimuli sd) throws IOException {
        sd.setNetDelimiter(" ");
        if (this.openBinaryInput(fileURL)) {
            return sd;
        }
        SmartSpiceOut.startProgressDialog("SmartSpice output", fileURL.getFile());
        this.readRawSmartSpiceFile(cell, sd);
        SmartSpiceOut.stopProgressDialog();
        this.closeInput();
        return sd;
    }

    private void readRawSmartSpiceFile(Cell cell, Stimuli sd) throws IOException {
        String line;
        boolean first = true;
        int signalCount = -1;
        String[] signalNames = null;
        int rowCount = -1;
        SignalCollection sc = null;
        double[][] values2 = null;
        double[] time = null;
        block0: while ((line = this.getLineFromBinary()) != null) {
            int j;
            int colonPos;
            if (first) {
                String hsFormat;
                first = false;
                if (line.length() >= 20 && ((hsFormat = line.substring(16, 20)).equals("9007") || hsFormat.equals("9601"))) {
                    System.out.println("This is an HSPICE file, not a SMARTSPICE file");
                    System.out.println("Change the SPICE format (in Preferences) and reread");
                    return;
                }
            }
            if ((colonPos = line.indexOf(58)) < 0) continue;
            String keyWord = line.substring(0, colonPos);
            String restOfLine = line.substring(colonPos + 1).trim();
            if (keyWord.equals("No. Variables")) {
                signalCount = TextUtils.atoi(restOfLine) - 1;
                continue;
            }
            if (keyWord.equals("No. Points")) {
                rowCount = TextUtils.atoi(restOfLine);
                continue;
            }
            if (keyWord.equals("Variables")) {
                if (signalCount < 0) {
                    System.out.println("Missing variable count in file");
                    return;
                }
                sc = Stimuli.newSignalCollection(sd, "SIGNALS");
                sd.setCell(cell);
                signalNames = new String[signalCount];
                values2 = new double[signalCount][rowCount];
                for (int i = 0; i <= signalCount; ++i) {
                    int nameEnd;
                    int nameStart;
                    int indexOnLine;
                    if (i != 0) {
                        restOfLine = this.getLineFromBinary();
                        if (restOfLine == null) continue block0;
                        restOfLine = restOfLine.trim();
                    }
                    if ((indexOnLine = TextUtils.atoi(restOfLine)) != i) {
                        System.out.println("Warning: Variable " + i + " has number " + indexOnLine);
                    }
                    for (nameStart = 0; nameStart < restOfLine.length() && !Character.isWhitespace(restOfLine.charAt(nameStart)); ++nameStart) {
                    }
                    while (nameStart < restOfLine.length() && Character.isWhitespace(restOfLine.charAt(nameStart))) {
                        ++nameStart;
                    }
                    for (nameEnd = nameStart; nameEnd < restOfLine.length() && !Character.isWhitespace(restOfLine.charAt(nameEnd)); ++nameEnd) {
                    }
                    String name = restOfLine.substring(nameStart, nameEnd);
                    if (name.startsWith("v(") && name.endsWith(")")) {
                        name = name.substring(2, name.length() - 1);
                    }
                    if (i == 0) {
                        if (name.equals("time")) continue;
                        System.out.println("Warning: the first variable (the sweep variable) should be time, is '" + name + "'");
                        continue;
                    }
                    signalNames[i - 1] = name;
                }
                continue;
            }
            if (keyWord.equals("Values")) {
                if (signalCount < 0) {
                    System.out.println("Missing variable count in file");
                    return;
                }
                if (rowCount < 0) {
                    System.out.println("Missing point count in file");
                    return;
                }
                time = new double[rowCount];
                for (j = 0; j < rowCount && (line = this.getLineFromBinary()) != null; ++j) {
                    int spacePos;
                    if (TextUtils.atoi(line) != j) {
                        System.out.println("Warning: data point " + j + " has number " + TextUtils.atoi(line));
                    }
                    if ((spacePos = line.indexOf(32)) >= 0) {
                        line = line.substring(spacePos + 1);
                    }
                    time[j] = TextUtils.atof(line.trim());
                    for (int i = 0; i < signalCount && (line = this.getLineFromBinary()) != null; ++i) {
                        double value2;
                        values2[i][j] = value2 = TextUtils.atof(line.trim());
                    }
                }
            }
            if (!keyWord.equals("Binary")) continue;
            if (signalCount < 0) {
                System.out.println("Missing variable count in file");
                return;
            }
            if (rowCount < 0) {
                System.out.println("Missing point count in file");
                return;
            }
            time = new double[rowCount];
            for (j = 0; j < rowCount; ++j) {
                long lval = this.dataInputStream.readLong();
                lval = Long.reverseBytes(lval);
                time[j] = Double.longBitsToDouble(lval);
                for (int i = 0; i < signalCount; ++i) {
                    double value3 = 0.0;
                    lval = this.dataInputStream.readLong();
                    lval = Long.reverseBytes(lval);
                    values2[i][j] = value3 = Double.longBitsToDouble(lval);
                }
            }
        }
        for (int i = 0; i < signalCount; ++i) {
            String name = signalNames[i];
            int lastDotPos = name.lastIndexOf(46);
            String context = null;
            if (lastDotPos >= 0) {
                context = name.substring(0, lastDotPos);
                name = name.substring(lastDotPos + 1);
            }
            ScalarSample.createSignal(sc, sd, (String)signalNames[i], context, time, values2[i]);
        }
    }
}

