/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.util.concurrent.datastructures;

import com.sun.electric.tool.util.concurrent.datastructures.IStructure;
import com.sun.electric.tool.util.concurrent.utils.EmptyException;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockFreeStack<T>
extends IStructure<T> {
    private AtomicReference<IStructure.Node<T>> top = new AtomicReference<Object>(null);
    private static final int MIN_DELAY = 10;
    private static final int MAX_DELAY = 100;
    private IStructure.Backoff backoff = new IStructure.Backoff(10, 100);

    @Override
    public void add(T item) {
        IStructure.Node<T> node = new IStructure.Node<T>(item);
        while (!this.tryPush(node)) {
            try {
                this.backoff.backoff();
            }
            catch (InterruptedException e) {
                return;
            }
        }
        return;
    }

    private boolean tryPush(IStructure.Node<T> node) {
        IStructure.Node<T> oldTop = this.top.get();
        node.next = new AtomicReference<IStructure.Node<T>>(oldTop);
        return this.top.compareAndSet(oldTop, node);
    }

    @Override
    public boolean isEmpty() {
        IStructure.Node<T> oldTop = this.top.get();
        return oldTop == null;
    }

    @Override
    public T remove() {
        while (true) {
            IStructure.Node<T> returnNode;
            try {
                returnNode = this.tryPop();
            }
            catch (EmptyException e) {
                return null;
            }
            if (returnNode != null) {
                return returnNode.value;
            }
            try {
                this.backoff.backoff();
            }
            catch (InterruptedException e) {
                return null;
            }
        }
    }

    private IStructure.Node<T> tryPop() throws EmptyException {
        IStructure.Node<T> oldTop = this.top.get();
        if (oldTop == null) {
            throw new EmptyException();
        }
        IStructure.Node newTop = oldTop.next.get();
        if (this.top.compareAndSet(oldTop, newTop)) {
            return oldTop;
        }
        return null;
    }
}

