/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.Link;
import com.sun.electric.database.MyClass;
import com.sun.electric.database.MyField;
import com.sun.electric.database.MyObject;
import com.sun.electric.database.MyString;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyzeHeap {
    private static final boolean REFERENCES = true;
    ArrayList<MyObject> objs = new ArrayList();

    private AnalyzeHeap() {
    }

    public static void analyze(String fileName) {
        AnalyzeHeap dumpHeap = new AnalyzeHeap();
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(fileName)));
            dumpHeap.read(in);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(dumpHeap.objs.size() - 1 + " objects");
        dumpHeap.garbageCollect();
        dumpHeap.dump("heapdump.txt");
        dumpHeap.makePaths();
        dumpHeap.dump("heapdump2.txt");
    }

    private void read(DataInputStream in) throws IOException {
        int classH;
        int length;
        int h;
        int numObjs = in.readInt();
        this.objs.clear();
        while (this.objs.size() <= numObjs) {
            this.objs.add(null);
        }
        ArrayList<String> staticFields = new ArrayList<String>();
        ArrayList<String> fields = new ArrayList<String>();
        while ((h = in.readInt()) != 0) {
            String className = in.readUTF();
            byte mode = in.readByte();
            int staticLength = in.readInt();
            staticFields.clear();
            fields.clear();
            for (int i = 0; i < staticLength; ++i) {
                staticFields.add(in.readUTF());
            }
            length = in.readInt();
            for (int i = 0; i < length; ++i) {
                fields.add(in.readUTF());
            }
            MyClass cls = new MyClass(className, mode, staticFields, fields);
            this.objs.set(h, cls);
        }
        while ((h = in.readInt()) != 0) {
            MyString s = new MyString(in.readUTF());
            this.objs.set(h, s);
        }
        for (h = 1; h < this.objs.size(); ++h) {
            MyObject obj = this.objs.get(h);
            if (obj != null) continue;
            this.objs.set(h, new MyObject());
        }
        h = 1;
        while ((classH = in.readInt()) != 0) {
            MyObject obj = this.objs.get(h);
            MyClass cls = (MyClass)this.objs.get(classH);
            obj.id = h;
            obj.setClass(cls);
            switch (cls.mode) {
                case 2: {
                    length = in.readInt();
                    for (int i = 0; i < length; ++i) {
                        int elem2 = in.readInt();
                        new Link(obj, MyField.getElem(i), this.objs.get(elem2));
                    }
                    break;
                }
                case 3: {
                    int i;
                    int mapLength = in.readInt();
                    for (i = 0; i < mapLength; ++i) {
                        int key = in.readInt();
                        new Link(obj, MyField.getKey(i), this.objs.get(key));
                        int value2 = in.readInt();
                        new Link(obj, MyField.getElem(i), this.objs.get(value2));
                    }
                    break;
                }
                case 1: {
                    break;
                }
                case 4: {
                    int value3;
                    int i;
                    obj.pathLink = new Link(null, ((MyClass)obj).classField, obj);
                    for (i = 0; i < cls.fields.length; ++i) {
                        value3 = in.readInt();
                        new Link(obj, cls.fields[i], this.objs.get(value3));
                    }
                    cls = (MyClass)this.objs.get(h);
                    for (i = 0; i < cls.staticFields.length; ++i) {
                        value3 = in.readInt();
                        new Link(obj, cls.staticFields[i], this.objs.get(value3));
                    }
                    break;
                }
                case 0: {
                    int value3;
                    int i;
                    for (i = 0; i < cls.fields.length; ++i) {
                        value3 = in.readInt();
                        new Link(obj, cls.fields[i], this.objs.get(value3));
                    }
                    break;
                }
            }
            ++h;
        }
    }

    private void garbageCollect(MyObject obj, HashSet<MyObject> visited) {
        if (obj == null || visited.contains(obj)) {
            return;
        }
        visited.add(obj);
        for (Link l : obj.linksFrom) {
            this.garbageCollect(l.to, visited);
        }
    }

    private void garbageCollect() {
        HashSet<MyObject> visited = new HashSet<MyObject>();
        for (int h = 1; h < this.objs.size(); ++h) {
            MyObject obj = this.objs.get(h);
            if (!(obj instanceof MyClass)) continue;
            this.garbageCollect(obj, visited);
        }
        int collected = 0;
        int remained = 0;
        for (int h = 1; h < this.objs.size(); ++h) {
            MyObject obj = this.objs.get(h);
            if (obj == null) continue;
            if (!visited.contains(obj)) {
                this.objs.set(h, null);
                ++collected;
            }
            Iterator<Link> it = obj.linksTo.iterator();
            while (it.hasNext()) {
                Link l = it.next();
                if (l.from == null || visited.contains(l.from)) continue;
                it.remove();
            }
            ++remained;
        }
        System.out.println(collected + " objects collected  " + remained + " remained");
    }

    private void makePaths() {
        int named;
        int k;
        for (k = 0; k < 100 && (named = this.stepPath(true, false, false)) != 0; ++k) {
        }
        for (k = 0; k < 100 && (named = this.stepPath(true, true, false)) != 0; ++k) {
        }
        this.countUnnamed();
        int singleRefered = 0;
        for (int h = 0; h < this.objs.size(); ++h) {
            MyObject obj = this.objs.get(h);
            if (obj == null || !obj.isSingleOwned()) continue;
            if (obj.linksTo.size() == 0) {
                System.out.println(obj + " has no access");
                continue;
            }
            ++singleRefered;
            Link pathLink = obj.linksTo.get(0);
            assert (obj.pathLink == null || obj.pathLink == pathLink);
            obj.pathLink = pathLink;
        }
        System.out.println(singleRefered + " single-refered");
        this.countUnnamed();
    }

    private int stepPath(boolean doMaps, boolean trackReferents, boolean verbose) {
        HashSet<MyObject> named = new HashSet<MyObject>();
        for (int h = 1; h < this.objs.size(); ++h) {
            MyObject obj = this.objs.get(h);
            if (obj == null || obj.pathLink == null || named.contains(obj)) continue;
            boolean doAll = doMaps || obj.cls.mode != 3 && obj.cls.mode != 2;
            for (Link l : obj.linksFrom) {
                if (l.to == null || l.to.pathLink != null || !trackReferents && l.field.referent) continue;
                boolean single = l.to.isSingleOwned();
                if (!doAll && !single) continue;
                l.to.pathLink = l;
                named.add(l.to);
                if (!verbose || single) continue;
                System.out.println(l.to.toString());
            }
        }
        System.out.println(named.size() + " named");
        return named.size();
    }

    private void countUnnamed() {
        int unnamed = 0;
        for (int h = 0; h < this.objs.size(); ++h) {
            MyObject obj = this.objs.get(h);
            if (obj == null || obj.pathLink != null) continue;
            ++unnamed;
        }
        System.out.println(unnamed + " unnamed");
    }

    private void dump(String dumpName) {
        try {
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(dumpName)));
            for (int h = 0; h < this.objs.size(); ++h) {
                MyObject obj = this.objs.get(h);
                if (obj == null) continue;
                out.println(obj.toString());
                for (Link l : obj.linksFrom) {
                    if (l.to == null) continue;
                    out.println("\t" + l.field.name + "\t" + (l.to != null ? l.to.toString() : "null"));
                }
                out.println("\t-");
                for (Link l : obj.linksTo) {
                    if (l == obj.pathLink) continue;
                    out.println("\t" + (l.from != null ? l.from.path() + "." : "") + l.field.name);
                }
                out.println();
            }
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

