/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io;

import com.sun.electric.database.text.ArrayIterator;
import com.sun.electric.database.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class GDSLayers {
    public static final GDSLayers EMPTY = new GDSLayers(Collections.<Integer>emptyList(), -1, -1);
    private final Integer[] normalLayers;
    private final int pinLayer;
    private final int textLayer;

    public GDSLayers(List<Integer> normalLayers, int pinLayer, int textLayer) {
        this.normalLayers = normalLayers.toArray(new Integer[normalLayers.size()]);
        this.pinLayer = pinLayer;
        this.textLayer = textLayer;
    }

    public int getNumLayers() {
        return this.normalLayers.length;
    }

    public Iterator<Integer> getLayers() {
        return ArrayIterator.iterator(this.normalLayers);
    }

    public Integer getFirstLayer() {
        if (this.normalLayers.length == 0) {
            return 0;
        }
        return this.normalLayers[0];
    }

    public int getPinLayer() {
        return this.pinLayer;
    }

    public int getTextLayer() {
        return this.textLayer;
    }

    public boolean equals(GDSLayers other) {
        if (this.pinLayer != other.pinLayer) {
            return false;
        }
        if (this.textLayer != other.textLayer) {
            return false;
        }
        return Arrays.equals((Object[])this.normalLayers, (Object[])other.normalLayers);
    }

    public String toString() {
        String s = "";
        for (Integer layVal : this.normalLayers) {
            int layNum = layVal & 0xFFFF;
            int layType = layVal >> 16 & 0xFFFF;
            s = s + Integer.toString(layNum);
            if (layType == 0) continue;
            s = s + "/" + layType;
        }
        if (this.pinLayer != -1) {
            s = s + "," + (this.pinLayer & 0xFFFF);
            int pinType = this.pinLayer >> 16 & 0xFFFF;
            if (pinType != 0) {
                s = s + "/" + pinType;
            }
            s = s + "p";
        }
        if (this.textLayer != -1) {
            s = s + "," + (this.textLayer & 0xFFFF);
            int textType = this.textLayer >> 16 & 0xFFFF;
            if (textType != 0) {
                s = s + "/" + textType;
            }
            s = s + "t";
        }
        return s;
    }

    public static GDSLayers parseLayerString(String string) {
        String trimmed;
        ArrayList<Integer> normalLayers = new ArrayList<Integer>();
        int pinLayer = -1;
        int textLayer = -1;
        while ((trimmed = string.trim()).length() != 0) {
            int number;
            int slashPos = trimmed.indexOf(47);
            int endPos = trimmed.indexOf(44);
            if (endPos < 0) {
                endPos = trimmed.length();
            }
            if ((number = TextUtils.atoi(trimmed)) != 0 || trimmed.equals("0")) {
                char lastCh;
                int type = 0;
                if (slashPos >= 0 && slashPos < endPos) {
                    type = TextUtils.atoi(trimmed.substring(slashPos + 1));
                }
                if ((lastCh = trimmed.charAt(endPos - 1)) == 't') {
                    textLayer = number | type << 16;
                } else if (lastCh == 'p') {
                    pinLayer = number | type << 16;
                } else {
                    Integer normalLayer = new Integer(number | type << 16);
                    normalLayers.add(normalLayer);
                }
                if (endPos == trimmed.length()) break;
            }
            string = trimmed.substring(endPos + 1);
        }
        if (normalLayers.isEmpty() && pinLayer == -1 && textLayer == -1) {
            return EMPTY;
        }
        return new GDSLayers(normalLayers, pinLayer, textLayer);
    }
}

