/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.ncc.strategy;

import com.sun.electric.tool.ncc.NccGlobals;
import com.sun.electric.tool.ncc.lists.LeafList;
import com.sun.electric.tool.ncc.lists.RecordList;
import com.sun.electric.tool.ncc.netlist.NetObject;
import com.sun.electric.tool.ncc.netlist.Port;
import com.sun.electric.tool.ncc.netlist.Wire;
import com.sun.electric.tool.ncc.strategy.Strategy;
import com.sun.electric.tool.ncc.trees.Circuit;
import com.sun.electric.tool.ncc.trees.EquivRecord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class StratPortName
extends Strategy {
    private int numWiresProcessed;
    private int numEquivProcessed;
    private Map theMap;
    private boolean doneOne;

    private StratPortName(NccGlobals globals) {
        super(globals);
    }

    public static LeafList doYourJob(NccGlobals globals) {
        if (globals.getWires() == null) {
            return new LeafList();
        }
        StratPortName wn = new StratPortName(globals);
        wn.preamble();
        Iterator frontier = globals.getWireLeafEquivRecs().getNotMatched();
        LeafList ll = new LeafList();
        while (frontier.hasNext()) {
            ll.add(frontier.next());
        }
        LeafList el = wn.doFor(ll);
        wn.summary(el);
        return el;
    }

    private void preamble() {
        this.startTime("StratPortName", "all active Wires");
    }

    private void summary(LeafList offspring) {
        this.globals.status2("StratPortName processed " + this.numWiresProcessed + " Wires from " + this.numEquivProcessed + " EquivRecords");
        this.globals.status2(this.offspringStats(offspring));
        this.globals.status2(offspring.sizeInfoString());
        this.elapsedTime();
    }

    private void printTheMap(Map m) {
        this.globals.status2("  printing an EquivRecord map of size= " + m.size());
        if (m.size() == 0) {
            return;
        }
        Iterator it = m.keySet().iterator();
        while (it.hasNext()) {
            Wire w = (Wire)it.next();
            Object oo = m.get(w);
            if (oo == null) {
                this.globals.status2(" " + w.instanceDescription() + " maps to null");
                continue;
            }
            Integer i = (Integer)oo;
            this.globals.status2(" " + w.instanceDescription() + " maps to " + i);
        }
    }

    private Map getMapFromExportNamesToWires(Circuit wires) {
        HashMap<String, Wire> out = new HashMap<String, Wire>();
        Iterator it = wires.getNetObjs();
        while (it.hasNext()) {
            NetObject n = (NetObject)it.next();
            this.error(!(n instanceof Wire), "getExportMap expects only Wires");
            Wire w = (Wire)n;
            Port p = w.getPort();
            if (p == null || p.getToBeRenamed()) continue;
            Iterator ni = p.getExportNames();
            while (ni.hasNext()) {
                String exportNm = (String)ni.next();
                this.error(out.containsKey(exportNm), "different wires have the same export name?");
                out.put(exportNm, w);
            }
        }
        return out;
    }

    private Map getWireExportMap(EquivRecord er) {
        ArrayList<Map> mapPerCkt = new ArrayList<Map>();
        HashSet keys = new HashSet();
        Iterator ci = er.getCircuits();
        while (ci.hasNext()) {
            Map exportToWire = this.getMapFromExportNamesToWires((Circuit)ci.next());
            mapPerCkt.add(exportToWire);
            keys.addAll(exportToWire.keySet());
        }
        if (keys.size() == 0) {
            return new HashMap();
        }
        HashMap<Wire, Integer> out = new HashMap<Wire, Integer>();
        int i = 0;
        Iterator ki = keys.iterator();
        while (ki.hasNext()) {
            String key = (String)ki.next();
            ArrayList<Wire> wires = new ArrayList<Wire>();
            Iterator hi = mapPerCkt.iterator();
            while (hi.hasNext()) {
                Map map = (Map)hi.next();
                if (!map.containsKey(key)) continue;
                Wire w = (Wire)map.get(key);
                wires.add(w);
            }
            if (wires.size() != mapPerCkt.size()) continue;
            ++i;
            hi = wires.iterator();
            while (hi.hasNext()) {
                Wire w = (Wire)hi.next();
                out.put(w, new Integer(i));
            }
        }
        this.printTheMap(out);
        return out;
    }

    public LeafList doFor(RecordList g) {
        LeafList gg = (LeafList)g;
        gg.sortByIncreasingSize();
        return super.doFor(gg);
    }

    public LeafList doFor(EquivRecord g) {
        LeafList out;
        if (g.isLeaf()) {
            EquivRecord er = g;
            if (this.doneOne) {
                return new LeafList();
            }
            ++this.numEquivProcessed;
            this.theMap = this.getWireExportMap(er);
            if (this.theMap.size() == 0) {
                return new LeafList();
            }
            this.doneOne = true;
            out = super.doFor(g);
            this.globals.status2(" processed " + g.nameString() + " with map size= " + this.theMap.size() + " yields " + out.size() + " offspring ");
        } else {
            out = super.doFor(g);
        }
        return out;
    }

    public Integer doFor(NetObject n) {
        this.error(!(n instanceof Wire), "StratPortName expects only Wires");
        ++this.numWiresProcessed;
        Wire w = (Wire)n;
        Integer i = (Integer)this.theMap.get(w);
        return i != null ? i : new Integer(0);
    }
}

