/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.geometry.PolyMerge;
import com.sun.electric.database.geometry.PolyQTree;
import com.sun.electric.database.geometry.PolySweepMerge;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public abstract class GeometryHandler {
    HashMap layers;
    public static final int ALGO_MERGE = 0;
    public static final int ALGO_QTREE = 1;
    public static final int ALGO_SWEEP = 2;
    public static final ShapeSort shapeSort = new ShapeSort();
    public static final AreaSort areaSort = new AreaSort();

    public static GeometryHandler createGeometryHandler(int mode, int initialSize, Rectangle2D root) {
        switch (mode) {
            case 0: {
                return new PolyMerge();
            }
            case 1: {
                return new PolyQTree(root);
            }
            case 2: {
                if (initialSize > 0) {
                    return new PolySweepMerge(initialSize);
                }
                return new PolySweepMerge();
            }
        }
        return null;
    }

    public GeometryHandler() {
        this.layers = new HashMap();
    }

    public GeometryHandler(int initialSize) {
        this.layers = new HashMap(initialSize);
    }

    public void add(Object key, Object value, boolean fasterAlgorithm) {
    }

    public void addAll(GeometryHandler subMerge, AffineTransform tTrans) {
    }

    public void subtract(Object key, Object element) {
        System.out.println("Error: subtract not implemented for GeometryHandler subclass " + this.getClass().getName());
    }

    public void subtractAll(HashMap map) {
        System.out.println("Error: subtractAll not implemented for GeometryHandler subclass " + this.getClass().getName());
    }

    public Collection getKeySet() {
        return this.layers.keySet();
    }

    public Iterator getKeyIterator() {
        return this.getKeySet().iterator();
    }

    public Iterator getIterator() {
        return this.layers.values().iterator();
    }

    public Collection getObjects(Object layer, boolean modified, boolean simple) {
        System.out.println("Error: getObjects not implemented for GeometryHandler subclass " + this.getClass().getName());
        return null;
    }

    public void postProcess(boolean merge) {
        if (!merge) {
            System.out.println("Error: postProcess not implemented for GeometryHandler subclass " + this.getClass().getName());
        }
    }

    private static class AreaSort
    implements Comparator {
        private AreaSort() {
        }

        public int compare(Object o1, Object o2) {
            double bb2;
            double bb1 = ((Area)o1).getBounds2D().getX();
            if (bb1 < (bb2 = ((Area)o2).getBounds2D().getX())) {
                return -1;
            }
            if (bb1 > bb2) {
                return 1;
            }
            return 0;
        }
    }

    private static class ShapeSort
    implements Comparator {
        private ShapeSort() {
        }

        public int compare(Object o1, Object o2) {
            double bb2;
            double bb1 = ((Shape)o1).getBounds2D().getX();
            if (bb1 < (bb2 = ((Shape)o2).getBounds2D().getX())) {
                return -1;
            }
            if (bb1 > bb2) {
                return 1;
            }
            return 0;
        }
    }
}

