/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.technology.technologies;

import com.sun.electric.database.geometry.EGraphics;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.prototype.ArcProto;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.technology.EdgeH;
import com.sun.electric.technology.EdgeV;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveArc;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.SizeOffset;
import com.sun.electric.technology.Technology;
import java.awt.Color;

public class RCMOS
extends Technology {
    public static final RCMOS tech = new RCMOS();

    private RCMOS() {
        this.setTechName("rcmos");
        this.setTechShortName("Round CMOS");
        this.setTechDesc("Complementary MOS (round, from MOSIS, P-Well, double metal)");
        this.setFactoryScale(2000.0, true);
        this.setNoNegatedArcs();
        this.setStaticTechnology();
        this.setFactoryTransparentLayers(new Color[]{new Color(96, 209, 255), new Color(255, 155, 192), new Color(107, 226, 96), new Color(240, 221, 181), new Color(224, 95, 255)});
        Layer metal1_lay = Layer.newInstance(this, "Metal-1", new EGraphics(0, 1, 1, 96, 209, 255, 0.8, true, new int[]{8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0}));
        Layer metal2_lay = Layer.newInstance(this, "Metal-2", new EGraphics(0, 1, 5, 224, 95, 255, 0.8, true, new int[]{4112, 8224, 16448, 32896, 257, 514, 1028, 2056, 4112, 8224, 16448, 32896, 257, 514, 1028, 2056}));
        Layer polysilicon_lay = Layer.newInstance(this, "Polysilicon", new EGraphics(0, 1, 2, 255, 155, 192, 0.8, true, new int[]{2056, 1028, 514, 257, 32896, 16448, 8224, 4112, 2056, 1028, 514, 257, 32896, 16448, 8224, 4112}));
        Layer sActive_lay = Layer.newInstance(this, "S-Active", new EGraphics(0, 1, 3, 107, 226, 96, 0.8, true, new int[]{0, 771, 18504, 771, 0, 12336, 33924, 12336, 0, 771, 18504, 771, 0, 12336, 33924, 12336}));
        Layer dActive_lay = Layer.newInstance(this, "D-Active", new EGraphics(0, 1, 3, 107, 226, 96, 0.8, true, new int[]{0, 771, 18504, 771, 0, 12336, 33924, 12336, 0, 771, 18504, 771, 0, 12336, 33924, 12336}));
        Layer select_lay = Layer.newInstance(this, "Select", new EGraphics(1, 1, 0, 255, 255, 0, 0.8, true, new int[]{4112, 8224, 16448, 32896, 257, 514, 1028, 2056, 4112, 8224, 16448, 32896, 257, 514, 1028, 2056}));
        Layer well_lay = Layer.newInstance(this, "Well", new EGraphics(0, 1, 4, 240, 221, 181, 0.8, true, new int[]{0, 192, 0, 0, 0, 192, 0, 0, 0, 192, 0, 0, 0, 192, 0, 0}));
        Layer cut_lay = Layer.newInstance(this, "Contact-Cut", new EGraphics(0, 0, 0, 0, 0, 0, 0.8, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        Layer via_lay = Layer.newInstance(this, "Via", new EGraphics(0, 0, 0, 0, 0, 0, 0.8, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        Layer passivation_lay = Layer.newInstance(this, "Passivation", new EGraphics(1, 1, 0, 100, 100, 100, 0.8, true, new int[]{7196, 15934, 13878, 15934, 7196, 0, 0, 0, 7196, 15934, 13878, 15934, 7196, 0, 0, 0}));
        Layer polyCut_lay = Layer.newInstance(this, "Poly-Cut", new EGraphics(0, 0, 0, 0, 0, 0, 0.8, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        Layer activeCut_lay = Layer.newInstance(this, "Active-Cut", new EGraphics(0, 0, 0, 0, 0, 0, 0.8, true, new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}));
        Layer pseudoMetal1_lay = Layer.newInstance(this, "Pseudo-Metal-1", new EGraphics(0, 0, 1, 96, 209, 255, 0.8, true, new int[]{8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0, 8738, 0, 34952, 0}));
        Layer pseudoMetal2_lay = Layer.newInstance(this, "Pseudo-Metal-2", new EGraphics(0, 0, 5, 224, 95, 255, 0.8, true, new int[]{4112, 8224, 16448, 32896, 257, 514, 1028, 2056, 4112, 8224, 16448, 32896, 257, 514, 1028, 2056}));
        Layer pseudoPolysilicon_lay = Layer.newInstance(this, "Pseudo-Polysilicon", new EGraphics(0, 0, 2, 255, 155, 192, 0.8, true, new int[]{2056, 1028, 514, 257, 32896, 16448, 8224, 4112, 2056, 1028, 514, 257, 32896, 16448, 8224, 4112}));
        Layer pseudoSActive_lay = Layer.newInstance(this, "Pseudo-S-Active", new EGraphics(0, 0, 3, 107, 226, 96, 0.8, true, new int[]{0, 771, 18504, 771, 0, 12336, 33924, 12336, 0, 771, 18504, 771, 0, 12336, 33924, 12336}));
        Layer pseudoDActive_lay = Layer.newInstance(this, "Pseudo-D-Active", new EGraphics(0, 0, 3, 107, 226, 96, 0.8, true, new int[]{0, 771, 18504, 771, 0, 12336, 33924, 12336, 0, 771, 18504, 771, 0, 12336, 33924, 12336}));
        Layer pseudoSelect_lay = Layer.newInstance(this, "Pseudo-Select", new EGraphics(1, 1, 0, 255, 255, 0, 0.8, true, new int[]{4112, 8224, 16448, 32896, 257, 514, 1028, 2056, 4112, 8224, 16448, 32896, 257, 514, 1028, 2056}));
        Layer pseudoWell_lay = Layer.newInstance(this, "Pseudo-Well", new EGraphics(0, 0, 4, 240, 221, 181, 0.8, true, new int[]{0, 192, 0, 0, 0, 192, 0, 0, 0, 192, 0, 0, 0, 192, 0, 0}));
        metal1_lay.setFunction(Layer.Function.METAL1);
        metal2_lay.setFunction(Layer.Function.METAL2);
        polysilicon_lay.setFunction(Layer.Function.POLY1);
        sActive_lay.setFunction(Layer.Function.DIFF);
        dActive_lay.setFunction(Layer.Function.DIFF);
        select_lay.setFunction(Layer.Function.IMPLANTP);
        well_lay.setFunction(Layer.Function.WELLP);
        cut_lay.setFunction(Layer.Function.CONTACT1);
        via_lay.setFunction(Layer.Function.CONTACT2);
        passivation_lay.setFunction(Layer.Function.OVERGLASS);
        polyCut_lay.setFunction(Layer.Function.CONTACT1);
        activeCut_lay.setFunction(Layer.Function.CONTACT1);
        pseudoMetal1_lay.setFunction(Layer.Function.METAL1, 4096);
        pseudoMetal2_lay.setFunction(Layer.Function.METAL2, 4096);
        pseudoPolysilicon_lay.setFunction(Layer.Function.POLY1, 4096);
        pseudoSActive_lay.setFunction(Layer.Function.DIFF, 4096);
        pseudoDActive_lay.setFunction(Layer.Function.DIFF, 4096);
        pseudoSelect_lay.setFunction(Layer.Function.IMPLANTP, 4096);
        pseudoWell_lay.setFunction(Layer.Function.WELLP, 4096);
        metal1_lay.setFactoryCIFLayer("CMF");
        metal2_lay.setFactoryCIFLayer("CMS");
        polysilicon_lay.setFactoryCIFLayer("CPG");
        sActive_lay.setFactoryCIFLayer("CAA");
        dActive_lay.setFactoryCIFLayer("CAA");
        select_lay.setFactoryCIFLayer("CSG");
        well_lay.setFactoryCIFLayer("CWG");
        cut_lay.setFactoryCIFLayer("CC");
        via_lay.setFactoryCIFLayer("CVA");
        passivation_lay.setFactoryCIFLayer("COG");
        polyCut_lay.setFactoryCIFLayer("CCP");
        activeCut_lay.setFactoryCIFLayer("CCA");
        pseudoMetal1_lay.setFactoryCIFLayer("");
        pseudoMetal2_lay.setFactoryCIFLayer("");
        pseudoPolysilicon_lay.setFactoryCIFLayer("");
        pseudoSActive_lay.setFactoryCIFLayer("");
        pseudoDActive_lay.setFactoryCIFLayer("");
        pseudoSelect_lay.setFactoryCIFLayer("");
        pseudoWell_lay.setFactoryCIFLayer("");
        PrimitiveArc metal1_arc = PrimitiveArc.newInstance(this, "Metal-1", 3.0, new Technology.ArcLayer[]{new Technology.ArcLayer(metal1_lay, 0.0, Poly.Type.FILLED)});
        metal1_arc.setFunction(ArcProto.Function.METAL1);
        metal1_arc.setFactoryFixedAngle(false);
        metal1_arc.setCurvable();
        metal1_arc.setExtended(false);
        metal1_arc.setFactoryAngleIncrement(0);
        PrimitiveArc metal2_arc = PrimitiveArc.newInstance(this, "Metal-2", 3.0, new Technology.ArcLayer[]{new Technology.ArcLayer(metal2_lay, 0.0, Poly.Type.FILLED)});
        metal2_arc.setFunction(ArcProto.Function.METAL1);
        metal2_arc.setFactoryFixedAngle(false);
        metal2_arc.setCurvable();
        metal2_arc.setExtended(false);
        metal2_arc.setFactoryAngleIncrement(0);
        PrimitiveArc polysilicon_arc = PrimitiveArc.newInstance(this, "Polysilicon", 2.0, new Technology.ArcLayer[]{new Technology.ArcLayer(polysilicon_lay, 0.0, Poly.Type.FILLED)});
        polysilicon_arc.setFunction(ArcProto.Function.METAL1);
        polysilicon_arc.setFactoryFixedAngle(false);
        polysilicon_arc.setCurvable();
        polysilicon_arc.setExtended(false);
        polysilicon_arc.setFactoryAngleIncrement(0);
        PrimitiveArc sActive_arc = PrimitiveArc.newInstance(this, "S-Active", 6.0, new Technology.ArcLayer[]{new Technology.ArcLayer(sActive_lay, 4.0, Poly.Type.FILLED), new Technology.ArcLayer(select_lay, 0.0, Poly.Type.FILLED)});
        sActive_arc.setFunction(ArcProto.Function.DIFFN);
        sActive_arc.setFactoryFixedAngle(false);
        sActive_arc.setCurvable();
        sActive_arc.setExtended(false);
        sActive_arc.setFactoryAngleIncrement(0);
        sActive_arc.setWidthOffset(4.0);
        PrimitiveArc dActive_arc = PrimitiveArc.newInstance(this, "D-Active", 10.0, new Technology.ArcLayer[]{new Technology.ArcLayer(dActive_lay, 8.0, Poly.Type.FILLED), new Technology.ArcLayer(well_lay, 0.0, Poly.Type.FILLED)});
        dActive_arc.setFunction(ArcProto.Function.DIFFP);
        dActive_arc.setFactoryFixedAngle(false);
        dActive_arc.setCurvable();
        dActive_arc.setExtended(false);
        dActive_arc.setFactoryAngleIncrement(0);
        dActive_arc.setWidthOffset(8.0);
        PrimitiveArc substrateActive_arc = PrimitiveArc.newInstance(this, "Substrate-Active", 2.0, new Technology.ArcLayer[]{new Technology.ArcLayer(dActive_lay, 0.0, Poly.Type.FILLED), new Technology.ArcLayer(sActive_lay, 0.0, Poly.Type.FILLED)});
        substrateActive_arc.setFunction(ArcProto.Function.DIFFS);
        substrateActive_arc.setFactoryFixedAngle(false);
        substrateActive_arc.setCurvable();
        substrateActive_arc.setExtended(false);
        substrateActive_arc.setFactoryAngleIncrement(0);
        PrimitiveArc wellActive_arc = PrimitiveArc.newInstance(this, "Well-Active", 6.0, new Technology.ArcLayer[]{new Technology.ArcLayer(dActive_lay, 4.0, Poly.Type.FILLED), new Technology.ArcLayer(sActive_lay, 4.0, Poly.Type.FILLED), new Technology.ArcLayer(well_lay, 0.0, Poly.Type.FILLED), new Technology.ArcLayer(select_lay, 0.0, Poly.Type.FILLED)});
        wellActive_arc.setFunction(ArcProto.Function.DIFFW);
        wellActive_arc.setFactoryFixedAngle(false);
        wellActive_arc.setCurvable();
        wellActive_arc.setExtended(false);
        wellActive_arc.setFactoryAngleIncrement(0);
        wellActive_arc.setWidthOffset(4.0);
        PrimitiveArc sTransistor_arc = PrimitiveArc.newInstance(this, "S-Transistor", 6.0, new Technology.ArcLayer[]{new Technology.ArcLayer(dActive_lay, 4.0, Poly.Type.FILLED), new Technology.ArcLayer(polysilicon_lay, 4.0, Poly.Type.FILLED), new Technology.ArcLayer(select_lay, 0.0, Poly.Type.FILLED)});
        sTransistor_arc.setFunction(ArcProto.Function.DIFFN);
        sTransistor_arc.setFactoryFixedAngle(false);
        sTransistor_arc.setCurvable();
        sTransistor_arc.setExtended(false);
        sTransistor_arc.setFactoryAngleIncrement(0);
        sTransistor_arc.setWidthOffset(4.0);
        PrimitiveArc dTransistor_arc = PrimitiveArc.newInstance(this, "D-Transistor", 10.0, new Technology.ArcLayer[]{new Technology.ArcLayer(dActive_lay, 8.0, Poly.Type.FILLED), new Technology.ArcLayer(polysilicon_lay, 8.0, Poly.Type.FILLED), new Technology.ArcLayer(well_lay, 0.0, Poly.Type.FILLED)});
        dTransistor_arc.setFunction(ArcProto.Function.DIFFP);
        dTransistor_arc.setFactoryFixedAngle(false);
        dTransistor_arc.setCurvable();
        dTransistor_arc.setExtended(false);
        dTransistor_arc.setFactoryAngleIncrement(0);
        dTransistor_arc.setWidthOffset(8.0);
        PrimitiveNode metal1Pin_node = PrimitiveNode.newInstance("Metal-1-Pin", this, 3.0, 3.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(metal1_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())})});
        metal1Pin_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, metal1Pin_node, new ArcProto[]{metal1_arc}, "metal-1", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        metal1Pin_node.setFunction(PrimitiveNode.Function.PIN);
        metal1Pin_node.setSquare();
        PrimitiveNode metal2Pin_node = PrimitiveNode.newInstance("Metal-2-Pin", this, 3.0, 3.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(metal2_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())})});
        metal2Pin_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, metal2Pin_node, new ArcProto[]{metal2_arc}, "metal-2", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        metal2Pin_node.setFunction(PrimitiveNode.Function.PIN);
        metal2Pin_node.setSquare();
        PrimitiveNode polysiliconPin_node = PrimitiveNode.newInstance("Polysilicon-Pin", this, 2.0, 2.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(polysilicon_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())})});
        polysiliconPin_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, polysiliconPin_node, new ArcProto[]{polysilicon_arc}, "polysilicon", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        polysiliconPin_node.setFunction(PrimitiveNode.Function.PIN);
        polysiliconPin_node.setSquare();
        PrimitiveNode sActivePin_node = PrimitiveNode.newInstance("S-Active-Pin", this, 6.0, 6.0, new SizeOffset(2.0, 2.0, 2.0, 2.0), new Technology.NodeLayer[]{new Technology.NodeLayer(sActive_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(2.0), EdgeV.makeCenter())}), new Technology.NodeLayer(select_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())})});
        sActivePin_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, sActivePin_node, new ArcProto[]{sActive_arc}, "s-active", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        sActivePin_node.setFunction(PrimitiveNode.Function.PIN);
        sActivePin_node.setSquare();
        PrimitiveNode dActivePin_node = PrimitiveNode.newInstance("D-Active-Pin", this, 10.0, 10.0, new SizeOffset(4.0, 4.0, 4.0, 4.0), new Technology.NodeLayer[]{new Technology.NodeLayer(dActive_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(4.0), EdgeV.makeCenter())}), new Technology.NodeLayer(well_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())})});
        dActivePin_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, dActivePin_node, new ArcProto[]{dActive_arc}, "d-active", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        dActivePin_node.setFunction(PrimitiveNode.Function.PIN);
        dActivePin_node.setSquare();
        PrimitiveNode substrateActivePin_node = PrimitiveNode.newInstance("Substrate-Active-Pin", this, 2.0, 2.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(dActive_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())}), new Technology.NodeLayer(sActive_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())})});
        substrateActivePin_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, substrateActivePin_node, new ArcProto[]{substrateActive_arc}, "active", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        substrateActivePin_node.setFunction(PrimitiveNode.Function.PIN);
        substrateActivePin_node.setSquare();
        PrimitiveNode wellActivePin_node = PrimitiveNode.newInstance("Well-Active-Pin", this, 6.0, 6.0, new SizeOffset(2.0, 2.0, 2.0, 2.0), new Technology.NodeLayer[]{new Technology.NodeLayer(dActive_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(2.0), EdgeV.makeCenter())}), new Technology.NodeLayer(sActive_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(2.0), EdgeV.makeCenter())}), new Technology.NodeLayer(well_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())}), new Technology.NodeLayer(select_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(1.0), EdgeV.makeCenter())})});
        wellActivePin_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, wellActivePin_node, new ArcProto[]{wellActive_arc}, "active", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        wellActivePin_node.setFunction(PrimitiveNode.Function.PIN);
        wellActivePin_node.setSquare();
        PrimitiveNode sTransistorPin_node = PrimitiveNode.newInstance("S-Transistor", this, 6.0, 6.0, new SizeOffset(2.0, 2.0, 2.0, 2.0), new Technology.NodeLayer[]{new Technology.NodeLayer(sActive_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(2.0), EdgeV.makeCenter())}), new Technology.NodeLayer(polysilicon_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(2.0), EdgeV.makeCenter())}), new Technology.NodeLayer(select_lay, -1, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())})});
        sTransistorPin_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, sTransistorPin_node, new ArcProto[]{sTransistor_arc, sActive_arc, polysilicon_arc}, "s-trans", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        sTransistorPin_node.setFunction(PrimitiveNode.Function.PIN);
        PrimitiveNode dTransistorPin_node = PrimitiveNode.newInstance("D-Transistor", this, 10.0, 10.0, new SizeOffset(4.0, 4.0, 4.0, 4.0), new Technology.NodeLayer[]{new Technology.NodeLayer(dActive_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(4.0), EdgeV.makeCenter())}), new Technology.NodeLayer(polysilicon_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(4.0), EdgeV.makeCenter())}), new Technology.NodeLayer(well_lay, -1, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())})});
        dTransistorPin_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, dTransistorPin_node, new ArcProto[]{dTransistor_arc, dActive_arc, polysilicon_arc}, "d-trans", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        dTransistorPin_node.setFunction(PrimitiveNode.Function.PIN);
        PrimitiveNode metal1SActiveCon_node = PrimitiveNode.newInstance("Metal-1-S-Active-Con", this, 10.0, 10.0, new SizeOffset(2.0, 2.0, 2.0, 2.0), new Technology.NodeLayer[]{new Technology.NodeLayer(metal1_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(3.0), EdgeV.makeCenter())}), new Technology.NodeLayer(sActive_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(2.0), EdgeV.makeCenter())}), new Technology.NodeLayer(select_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())}), new Technology.NodeLayer(activeCut_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromCenter(1.0), EdgeV.makeCenter())})});
        metal1SActiveCon_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, metal1SActiveCon_node, new ArcProto[]{sActive_arc, metal1_arc}, "metal-1-s-act", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        metal1SActiveCon_node.setFunction(PrimitiveNode.Function.CONTACT);
        metal1SActiveCon_node.setSquare();
        PrimitiveNode metal1DActiveCon_node = PrimitiveNode.newInstance("Metal-1-D-Active-Con", this, 14.0, 14.0, new SizeOffset(4.0, 4.0, 4.0, 4.0), new Technology.NodeLayer[]{new Technology.NodeLayer(metal1_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(5.0), EdgeV.makeCenter())}), new Technology.NodeLayer(dActive_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(4.0), EdgeV.makeCenter())}), new Technology.NodeLayer(well_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())}), new Technology.NodeLayer(activeCut_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromCenter(1.0), EdgeV.makeCenter())})});
        metal1DActiveCon_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, metal1DActiveCon_node, new ArcProto[]{dActive_arc, metal1_arc}, "metal-1-d-act", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        metal1DActiveCon_node.setFunction(PrimitiveNode.Function.CONTACT);
        metal1DActiveCon_node.setSquare();
        PrimitiveNode metal1PolyCon_node = PrimitiveNode.newInstance("Metal-1-Polysilicon-Con", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(metal1_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(1.0), EdgeV.makeCenter())}), new Technology.NodeLayer(polysilicon_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())}), new Technology.NodeLayer(polyCut_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromCenter(1.0), EdgeV.makeCenter())})});
        metal1PolyCon_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, metal1PolyCon_node, new ArcProto[]{polysilicon_arc, metal1_arc}, "metal-1-polysilicon", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        metal1PolyCon_node.setFunction(PrimitiveNode.Function.CONTACT);
        metal1PolyCon_node.setSquare();
        PrimitiveNode metal1Metal2Con_node = PrimitiveNode.newInstance("Metal-1-Metal-2-Con", this, 4.0, 4.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(metal1_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())}), new Technology.NodeLayer(metal2_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())}), new Technology.NodeLayer(via_lay, 0, Poly.Type.CIRCLE, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromCenter(1.0), EdgeV.makeCenter())})});
        metal1Metal2Con_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, metal1Metal2Con_node, new ArcProto[]{metal1_arc, metal2_arc}, "metal-1-metal-2", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        metal1Metal2Con_node.setFunction(PrimitiveNode.Function.CONTACT);
        metal1Metal2Con_node.setSquare();
        PrimitiveNode metal1WellCon_node = PrimitiveNode.newInstance("Metal-1-Well-Con", this, 10.0, 10.0, new SizeOffset(2.0, 2.0, 2.0, 2.0), new Technology.NodeLayer[]{new Technology.NodeLayer(metal1_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(5.0), EdgeV.makeCenter())}), new Technology.NodeLayer(sActive_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(2.0), EdgeV.makeCenter())}), new Technology.NodeLayer(well_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())}), new Technology.NodeLayer(select_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(2.0), EdgeV.makeCenter())}), new Technology.NodeLayer(activeCut_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromCenter(1.0), EdgeV.makeCenter())})});
        metal1WellCon_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, metal1WellCon_node, new ArcProto[]{metal1_arc, wellActive_arc}, "metal-1-well", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        metal1WellCon_node.setFunction(PrimitiveNode.Function.WELL);
        metal1WellCon_node.setSquare();
        PrimitiveNode metal1SubstrateCon_node = PrimitiveNode.newInstance("Metal-1-Substrate-Con", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(metal1_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromRight(1.0), EdgeV.makeCenter())}), new Technology.NodeLayer(sActive_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.makeRightEdge(), EdgeV.makeCenter())}), new Technology.NodeLayer(activeCut_lay, 0, Poly.Type.DISC, 0, new Technology.TechPoint[]{new Technology.TechPoint(EdgeH.makeCenter(), EdgeV.makeCenter()), new Technology.TechPoint(EdgeH.fromCenter(1.0), EdgeV.makeCenter())})});
        metal1SubstrateCon_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, metal1SubstrateCon_node, new ArcProto[]{metal1_arc, substrateActive_arc}, "metal-1-substrate", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        metal1SubstrateCon_node.setFunction(PrimitiveNode.Function.WELL);
        metal1SubstrateCon_node.setSquare();
        PrimitiveNode metal1_node = PrimitiveNode.newInstance("Metal-1-Node", this, 4.0, 4.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(metal1_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        metal1_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, metal1_node, new ArcProto[]{metal1_arc}, "metal-1", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        metal1_node.setFunction(PrimitiveNode.Function.NODE);
        metal1_node.setHoldsOutline();
        metal1_node.setSpecialType(2);
        PrimitiveNode metal2_node = PrimitiveNode.newInstance("Metal-2-Node", this, 4.0, 4.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(metal2_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        metal2_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, metal2_node, new ArcProto[]{metal2_arc}, "metal-2", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        metal2_node.setFunction(PrimitiveNode.Function.NODE);
        metal2_node.setHoldsOutline();
        metal2_node.setSpecialType(2);
        PrimitiveNode polysilicon_node = PrimitiveNode.newInstance("Polysilicon-Node", this, 4.0, 4.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(polysilicon_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        polysilicon_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, polysilicon_node, new ArcProto[]{polysilicon_arc}, "polysilicon", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        polysilicon_node.setFunction(PrimitiveNode.Function.NODE);
        polysilicon_node.setHoldsOutline();
        polysilicon_node.setSpecialType(2);
        PrimitiveNode active_node = PrimitiveNode.newInstance("Active-Node", this, 4.0, 4.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(sActive_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        active_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, active_node, new ArcProto[]{sActive_arc}, "active", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        active_node.setFunction(PrimitiveNode.Function.NODE);
        active_node.setHoldsOutline();
        active_node.setSpecialType(2);
        PrimitiveNode select_node = PrimitiveNode.newInstance("Select-Node", this, 4.0, 4.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(select_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        select_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, select_node, new ArcProto[0], "select", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        select_node.setFunction(PrimitiveNode.Function.NODE);
        select_node.setHoldsOutline();
        select_node.setSpecialType(2);
        PrimitiveNode cut_node = PrimitiveNode.newInstance("Cut-Node", this, 2.0, 2.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(cut_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        cut_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, cut_node, new ArcProto[0], "cut", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        cut_node.setFunction(PrimitiveNode.Function.NODE);
        cut_node.setHoldsOutline();
        cut_node.setSpecialType(2);
        PrimitiveNode polyCut_node = PrimitiveNode.newInstance("Poly-Cut-Node", this, 2.0, 2.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(polyCut_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        polyCut_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, polyCut_node, new ArcProto[0], "polycut", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        polyCut_node.setFunction(PrimitiveNode.Function.NODE);
        polyCut_node.setHoldsOutline();
        polyCut_node.setSpecialType(2);
        PrimitiveNode activeCut_node = PrimitiveNode.newInstance("Active-Cut-Node", this, 2.0, 2.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(activeCut_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        activeCut_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, activeCut_node, new ArcProto[0], "activecut", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        activeCut_node.setFunction(PrimitiveNode.Function.NODE);
        activeCut_node.setHoldsOutline();
        activeCut_node.setSpecialType(2);
        PrimitiveNode via_node = PrimitiveNode.newInstance("Via-Node", this, 2.0, 2.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(via_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        via_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, via_node, new ArcProto[0], "via", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        via_node.setFunction(PrimitiveNode.Function.NODE);
        via_node.setHoldsOutline();
        via_node.setSpecialType(2);
        PrimitiveNode well_node = PrimitiveNode.newInstance("Well-Node", this, 6.0, 6.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(well_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        well_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, well_node, new ArcProto[0], "well", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        well_node.setFunction(PrimitiveNode.Function.NODE);
        well_node.setHoldsOutline();
        well_node.setSpecialType(2);
        PrimitiveNode passivation_node = PrimitiveNode.newInstance("Passivation-Node", this, 8.0, 8.0, null, new Technology.NodeLayer[]{new Technology.NodeLayer(passivation_lay, 0, Poly.Type.FILLED, 1, Technology.TechPoint.makeFullBox())});
        passivation_node.addPrimitivePorts(new PrimitivePort[]{PrimitivePort.newInstance(this, passivation_node, new ArcProto[0], "passivation", 0, 180, 0, PortCharacteristic.UNKNOWN, EdgeH.makeCenter(), EdgeV.makeCenter(), EdgeH.makeCenter(), EdgeV.makeCenter())});
        passivation_node.setFunction(PrimitiveNode.Function.NODE);
        passivation_node.setHoldsOutline();
        passivation_node.setSpecialType(2);
        metal1_lay.setPureLayerNode(metal1_node);
        metal2_lay.setPureLayerNode(metal2_node);
        polysilicon_lay.setPureLayerNode(polysilicon_node);
        sActive_lay.setPureLayerNode(active_node);
        select_lay.setPureLayerNode(select_node);
        cut_lay.setPureLayerNode(cut_node);
        polyCut_lay.setPureLayerNode(polyCut_node);
        activeCut_lay.setPureLayerNode(activeCut_node);
        via_lay.setPureLayerNode(via_node);
        well_lay.setPureLayerNode(well_node);
        passivation_lay.setPureLayerNode(passivation_node);
    }
}

