/*
 * Decompiled with CFR 0.152.
 */
package wb;

import wb.Blink;
import wb.Del;
import wb.Ent;
import wb.Ents;
import wb.Han;
import wb.Pkt;
import wb.Prev;
import wb.Scan;
import wb.SchlepRT;
import wb.Stats;

public class Handle {
    public static boolean cleverCacheEnable_P = true;

    public static boolean hanError_P(Han han, String string) {
        if (!SchlepRT.a2b(han)) {
            System.err.print(">>>>ERROR<<<< " + string + ": called with NULL handle.\n");
            return true;
        }
        if (!SchlepRT.a2b(Han.han_Seg(han))) {
            System.err.print(">>>>ERROR<<<< " + string + ": called with handle having NULL segment.\n");
            return true;
        }
        return false;
    }

    public static boolean keyError_P(byte[] byArray, int n, int n2, String string) {
        if (n2 == n) {
            return false;
        }
        if (0 > n || n > 255) {
            System.err.print(">>>>ERROR<<<< " + string + ": key-length, " + n + ", was out of range 0 <= 255.\n");
            return true;
        }
        if (0 < n && 255 == (byArray[0] & 0xFF)) {
            System.err.print(">>>>ERROR<<<< " + string + ": first byte of key must not be 255.\n");
            return true;
        }
        return false;
    }

    public static int btGet(Han han, byte[] byArray, int n, byte[] byArray2) {
        int[] nArray = new int[6];
        Ent ent = null;
        if (Handle.keyError_P(byArray, n, 0, "btGet")) {
            return -13;
        }
        if (Handle.hanError_P(han, "btGet")) {
            return -15;
        }
        ent = Ents.chainFindEnt(han, 2, byArray, n, nArray);
        if (!SchlepRT.a2b(ent)) {
            Stats.getFct = 1 + Stats.getFct;
            return -90;
        }
        if (Pkt.pkt_MatchType(nArray) != 7) {
            Stats.getCt = 1 + Stats.getCt;
            Ents.releaseEnt(ent, 2);
            return -1;
        }
        int n2 = Blink.getThisVal(Ent.ent_Blk(ent), Pkt.pkt_MatchPos(nArray), byArray2);
        Stats.getCt = 1 + Stats.getCt;
        Ents.releaseEnt(ent, 2);
        return n2;
    }

    public static int btNext(Han han, byte[] byArray, int n, byte[] byArray2) {
        int[] nArray = new int[6];
        Ent ent = null;
        if (Handle.keyError_P(byArray, n, -2, "btNext")) {
            return -13;
        }
        if (Handle.hanError_P(han, "btNext")) {
            return -15;
        }
        ent = Ents.chainFindEnt(han, 2, byArray, n, nArray);
        if (!SchlepRT.a2b(ent)) {
            Stats.nextFct = 1 + Stats.nextFct;
            return -90;
        }
        Stats.nextCt = 1 + Stats.nextCt;
        int n2 = Blink.chainNext(ent, byArray, n, byArray2, nArray);
        if (cleverCacheEnable_P) {
            Han.han_SetLast(han, Pkt.pkt_BlkToCache(nArray));
        }
        return n2;
    }

    public static int btPrev(Han han, byte[] byArray, int n, byte[] byArray2) {
        int[] nArray = new int[6];
        Ent ent = null;
        if (Handle.keyError_P(byArray, n, -1, "btPrev")) {
            return -13;
        }
        if (Handle.hanError_P(han, "btPrev")) {
            return -15;
        }
        ent = Ents.chainFindPrevEnt(han, 2, byArray, n, nArray);
        if (SchlepRT.a2b(ent)) {
            ent = Prev.prev_PrevKEnt(ent, byArray, n, 48, nArray);
        }
        if (!SchlepRT.a2b(ent)) {
            Stats.prevFct = 1 + Stats.prevFct;
            return -90;
        }
        Stats.prevCt = 1 + Stats.prevCt;
        if (0 == Pkt.pkt_MatchPos(nArray)) {
            Ents.releaseEnt(ent, 2);
            return -1;
        }
        int n2 = Blink.reconThisKey(Ent.ent_Blk(ent), Pkt.pkt_MatchPos(nArray), byArray2, 0, 256);
        Han.han_SetLast(han, Ent.ent_Id(ent));
        Ents.releaseEnt(ent, 2);
        return n2;
    }

    public static int btRem(Han han, byte[] byArray, int n, byte[] byArray2) {
        int[] nArray = new int[6];
        Ent ent = null;
        if (Handle.keyError_P(byArray, n, 0, "btRem")) {
            return -13;
        }
        if (Handle.hanError_P(han, "btRem")) {
            return -15;
        }
        ent = Ents.chainFindEnt(han, 3, byArray, n, nArray);
        if (!SchlepRT.a2b(ent)) {
            Stats.remFct = 1 + Stats.remFct;
            return -90;
        }
        Stats.remCt = 1 + Stats.remCt;
        int n2 = Del.del_ChainRem(ent, byArray, n, byArray2, nArray, Han.han_Wcb(han));
        Ents.releaseEnt(ent, 3);
        return n2;
    }

    public static int btRemRange(Han han, byte[] byArray, int n, byte[] byArray2, int n2) {
        int[] nArray = new int[6];
        Pkt.pkt_SetSkeyCount(nArray, 0);
        return Scan.btScan(han, -1, byArray, n, byArray2, n2, null, null, nArray, -1);
    }

    public static int btPut(Han han, byte[] byArray, int n, byte[] byArray2, int n2) {
        Ent ent = null;
        int[] nArray = new int[6];
        if (Handle.keyError_P(byArray, n, 0, "btPut")) {
            return -13;
        }
        if (Handle.hanError_P(han, "btPut")) {
            return -15;
        }
        if (0 > n2 || n2 > 255) {
            return -15;
        }
        ent = Ents.chainFindEnt(han, 3, byArray, n, nArray);
        if (!SchlepRT.a2b(ent)) {
            return -90;
        }
        boolean bl = Blink.chainPut(ent, byArray, n, byArray2, n2, nArray, null, Han.han_Wcb(han));
        if (bl) {
            if (cleverCacheEnable_P) {
                Han.han_SetLast(han, Pkt.pkt_BlkToCache(nArray));
            }
            Stats.putCt = 1 + Stats.putCt;
            return 0;
        }
        Stats.putFct = 1 + Stats.putFct;
        return -90;
    }

    public static int btWrite(Han han, byte[] byArray, int n, byte[] byArray2, int n2) {
        Ent ent = null;
        int[] nArray = new int[6];
        if (Handle.keyError_P(byArray, n, 0, "btWrite")) {
            return -13;
        }
        if (Handle.hanError_P(han, "btWrite")) {
            return -15;
        }
        if (0 > n2 || n2 > 255) {
            return -15;
        }
        ent = Ents.chainFindEnt(han, 3, byArray, n, nArray);
        if (!SchlepRT.a2b(ent)) {
            return -90;
        }
        if (Pkt.pkt_MatchType(nArray) == 7) {
            Ents.releaseEnt(ent, 3);
            return -1;
        }
        boolean bl = Blink.chainPut(ent, byArray, n, byArray2, n2, nArray, null, Han.han_Wcb(han));
        if (bl) {
            if (cleverCacheEnable_P) {
                Han.han_SetLast(han, Pkt.pkt_BlkToCache(nArray));
            }
            Stats.putCt = 1 + Stats.putCt;
            return 0;
        }
        Stats.putFct = 1 + Stats.putFct;
        return -90;
    }
}

