/*
 * Decompiled with CFR 0.152.
 */
package gnu.jel;

import gnu.jel.ClassFile;
import gnu.jel.OPfunction;
import gnu.jel.OPlist;
import gnu.jel.OPload;
import gnu.jel.TypesStack;
import gnu.jel.reflect.Method;

public class OPunary
extends OPfunction {
    protected int code;
    private boolean str_to_tsb = false;
    private boolean tsb_to_str = false;
    private static Method sb_constructor;
    private static Method sb_toString;
    protected static Class sb_class;
    protected static Class string_class;
    protected static final int[] unary_prmtns;
    private static final int[][] una;
    private static final String[] opSymbols;
    private static final String[] opNames;

    public OPunary(TypesStack typesStack, int n) throws IllegalStateException {
        if (n == 3) {
            n = 12;
        }
        this.code = n;
        int n2 = typesStack.peekID();
        if (una[n][n2] == 255) {
            throw new IllegalStateException("The '" + opNames[n] + "' operation " + "is not supported on " + TypesStack.primitiveTypeNames[n2] + "s");
        }
        typesStack.pop();
        if (n != 12) {
            this.resID = unary_prmtns[n2];
            typesStack.pushID(this.resID, null);
        } else {
            this.resID = n2;
        }
    }

    public OPunary(TypesStack typesStack, int n, Class clazz, boolean bl) {
        this.code = n + 3;
        this.resID = n;
        Class clazz2 = typesStack.peek();
        if (n == 8) {
            this.str_to_tsb = TypesStack.isString(clazz2) && TypesStack.isTSB(clazz);
            this.tsb_to_str = TypesStack.isString(clazz) && TypesStack.isTSB(clazz2);
            this.resType = clazz;
        } else {
            this.resType = TypesStack.primitiveTypes[this.resID];
        }
        if (una[this.code][typesStack.peekID()] == 255) {
            throw new IllegalStateException("Can not convert " + typesStack.peek() + " to " + this.resType + " .");
        }
        if (!bl && !TypesStack.isWidening(clazz2, this.resType)) {
            throw new IllegalStateException("You must specify narrowing conversion from " + typesStack.peek() + " to " + this.resType + " explicitly.");
        }
        typesStack.pop();
        typesStack.pushID(this.resID, this.resType);
    }

    public OPunary(TypesStack typesStack, Class clazz, boolean bl) {
        this(typesStack, TypesStack.primitiveID(clazz), clazz, bl);
    }

    public int getNParams() {
        return 1;
    }

    protected void compile_pre(ClassFile classFile) {
        if (this.code == 2) {
            classFile.labels_block();
        }
        if (this.str_to_tsb) {
            classFile.code(187);
            classFile.codeI(classFile.getIndex(sb_class, 9));
            classFile.code(89);
            classFile.typesStk.pushID(8, sb_class);
            classFile.typesStk.pushID(8, sb_class);
        }
    }

    protected void compile(ClassFile classFile) {
        if (this.str_to_tsb) {
            classFile.code(183);
            classFile.codeI(classFile.getIndex(sb_constructor, 10));
            classFile.typesStk.pop();
            classFile.typesStk.pop();
        } else if (this.tsb_to_str) {
            classFile.code(182);
            classFile.codeI(classFile.getIndex(sb_toString, 10));
            classFile.typesStk.pop();
            classFile.typesStk.pushID(8, string_class);
        } else if (this.code == 2) {
            classFile.labels_unblock_not();
        } else {
            classFile.ensure_value();
            classFile.code(una[this.code][classFile.typesStk.peekID()]);
            if (this.code == 1) {
                classFile.typesStk.tempExcessWords(TypesStack.stkoccup[this.resID]);
            } else if (this.code == 11) {
                classFile.codeI(classFile.getIndex(this.resType, 9));
            }
            classFile.typesStk.pop();
            if (this.code != 12) {
                classFile.typesStk.pushID(this.resID, this.resType);
            }
        }
    }

    protected void eval(OPlist oPlist) {
        if (this.code == 12) {
            return;
        }
        if (!(this.prev instanceof OPload)) {
            return;
        }
        OPload oPload = (OPload)this.prev;
        if (this.code == 2) {
            oPload.what = ((Boolean)oPload.what).booleanValue() ? Boolean.FALSE : Boolean.TRUE;
        } else if (this.code < 2) {
            Number number = TypesStack.widen(oPload.what, oPload.resID);
            switch (this.code) {
                case 0: {
                    if (oPload.resID > 5) {
                        number = new Double(-number.doubleValue());
                        break;
                    }
                    number = new Long(-number.longValue());
                    break;
                }
                case 1: {
                    number = new Long(number.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    break;
                }
            }
            oPload.what = TypesStack.narrow(number, this.resID);
            oPload.resID = this.resID;
        } else if (oPload.resID != this.resID) {
            oPload.what = TypesStack.narrow(TypesStack.widen(oPload.what, oPload.resID), this.resID);
            oPload.resID = this.resID;
        } else if (this.code == 11) {
            if (this.tsb_to_str) {
                oPload.what = oPload.what.toString();
            }
            if (this.str_to_tsb) {
                oPload.what = new StringBuffer((String)oPload.what);
            }
        }
        oPlist.remove(this);
    }

    public String toString() {
        if (this.str_to_tsb) {
            return "->TSB";
        }
        if (this.tsb_to_str) {
            return "TSB->";
        }
        return opSymbols[this.code];
    }

    static {
        try {
            sb_class = Class.forName("java.lang.StringBuffer");
            string_class = Class.forName("java.lang.String");
            Class[] classArray = new Class[]{string_class};
            sb_constructor = new Method(sb_class.getConstructor(classArray));
            classArray = new Class[]{};
            sb_toString = new Method(sb_class.getMethod("toString", classArray));
        }
        catch (Exception exception) {
            // empty catch block
        }
        unary_prmtns = new int[]{0, 4, 4, 4, 4, 5, 6, 7, 8, 9};
        una = new int[][]{{116, 116, 255, 116, 116, 117, 118, 119, 255, 255}, {255, 33282, 33282, 33282, 33282, 8619266, 255, 255, 255, 255}, {0, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {0, 255, 255, 255, 255, 255, 255, 255, 255, 255}, {145, 0, 145, 145, 145, 37256, 37259, 37262, 255, 255}, {146, 146, 0, 146, 146, 37512, 37515, 37518, 255, 255}, {147, 147, 147, 0, 147, 37768, 37771, 37774, 255, 255}, {0, 0, 0, 0, 0, 136, 139, 142, 255, 255}, {133, 133, 133, 133, 133, 0, 140, 143, 255, 255}, {134, 134, 134, 134, 134, 137, 0, 144, 255, 255}, {135, 135, 135, 135, 135, 138, 141, 0, 255, 255}, {255, 255, 255, 255, 255, 255, 255, 255, 192, 255}, {172, 172, 172, 172, 172, 173, 174, 175, 176, 177}};
        opSymbols = new String[]{"--", "~", "!", "(Z)", "(B)", "(C)", "(S)", "(I)", "(J)", "(F)", "(D)", "(L)", "<RET>"};
        opNames = new String[]{"negation", "bitwise inversion", "logical inversion", "cast to boolean", "cast to byte", "cast to char", "cast to short", "cast to int", "cast to long", "cast to float", "cast to double", "cast to reference", "return"};
    }
}

