/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010, 2013
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : SERVER_SKEL
    Description : General code for Server Implementations
    Author      : David Martnez Oliviera
    Date        : 12/04/2001
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class SERVER_SKEL
***************************************************
*/
 
typedef struct
  {
     EUint32		Port;
     EUint32		BackLog;
     OBJID		Channel;
}DtSERVER_SKEL;
/*
***************************************************
  Method Declaration for class Channel
***************************************************
*/
 
ESint32 EDMAPROC 
SERVER_SKELinitZrS32 (OBJID IdObj, EPChar res)
{
  DtSERVER_SKEL	*m;
  ESint32       r;
  
  m = (DtSERVER_SKEL*) edma_get_data_ref (IdObj);
  
  /* We create the incomming request channel*/
  m->Channel = edma_new_obj ("CHANNEL");
  if (m->Channel == -1) 
    {
      edma_printf_obj (IdObj, "%s", "[ERROR] Can't create \"CHANNEL\" object");
      return -1;
    }
  /* Configure Server*/
  r = (ESint32) edma_met3 (m->Channel, "open", res);
  if (r == -1) 
    {
      edma_printf_obj (IdObj, "[ERROR] Can't open \"%s\"", res);
      return -1;
    }
  return 0;
}


ESint32 EDMAPROC 
SERVER_SKELrunrS32 (OBJID IdObj)
{
  DtSERVER_SKEL	*m;
  OBJID         id;

  m = (DtSERVER_SKEL*) edma_get_data_ref (IdObj);
  while (1) 
    {
      edma_met3 (m->Channel, "wait", &id);
      /* Invoke callback*/
      edma_met3 (IdObj, "onRequest", id);
    }
  return 0;
}


ESint32 EDMAPROC 
SERVER_SKELonRequestOrS32(OBJID IdObj, OBJID id)
{
  DtSERVER_SKEL	*m;
  EChar         remote[1024];

  m = (DtSERVER_SKEL*) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "%s", "[Warnning] You haven't override this method for managing requests");
  edma_rprop3 (id, "Resource", remote);
  edma_printf_obj (IdObj, "[Warnning] Request arrived from: %s", remote);
  
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
