/*
 * EDMA: Entorno de Desarrollo Modular y Abierto
 * Object Oriented and Componetware Framework
 * Copyright (C) 1998, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2010
 *    David Martnez Oliveira
 *
 * This file is part of EDMA.
 *
 * EDMA is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * EDMA is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with EDMA.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
**************************************************
    Entorno de Desarrollo Modular y Abierto (EDMA)
    EDMA 0.5.1r1
    (c) David Martnez Oliveira
    File generated by : EDMA IDF Wizard Gnomized 0.1
------------------------------------------------------
    Module Type : CLASS IMPLEMENTATION
    Class List  : GZFILE
    Description : Gzipped Files. Inherints from STREAM1
                  We'll use this class for testing dynamic
		  inheritance new features in GNU EDMA
    Author      : David Martnez Oliveira
    Date        : December, 6th, 2001
-----------------------------------------------------
  REVISIONS :
***************************************************
*/
 
/*
***************************************************
  General Header Files
***************************************************
*/
 
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <zlib.h>

/*
***************************************************
  EDMA Header Files
***************************************************
*/
 
#include <edma.h>

/*
***************************************************
  Private Data Struct for class GZFILE
***************************************************
*/
 
typedef struct
  {
    gzFile              handler;
    EDMAT_BUFFER	buffer;
}DtGZFILE;
/*
***************************************************
  Method Declaration for class buffer
***************************************************
*/
 
ESint32 EDMAPROC 
GZFILEopenZZrS32 (OBJID IdObj, EPChar name, EPChar mode)
{
  DtGZFILE	*m;
  
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  if ((m->handler = gzopen (name, mode)) == NULL) 
    {
      edma_printf_obj (IdObj, "Can't open file %s:", name);
      return -1;
    }
  
  return 0;
}


ESint32 EDMAPROC 
GZFILEcloserS32 (OBJID IdObj)
{
  DtGZFILE	*m;
  
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  
  return gzclose (m->handler);
}


ESint32 EDMAPROC 
GZFILEreadsAsS32rS32 (OBJID IdObj, EDMAT_BUFFER *buf, EPSint32 len)
{
  DtGZFILE	*m;
  
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  if (buf)
    if (buf->Size < *len) 
      {
	edma_printf_obj (IdObj, "%s", "Not enough allocated space to read data.");
	edma_printf_obj (IdObj, "Using Buffer size: %ld", buf->Size);
	*len = buf->Size;
      }
  *len = gzread (m->handler, buf->dat, *len);

  return *len;
}


ESint32 EDMAPROC 
GZFILEwriteAsS32rS32 (OBJID IdObj, EDMAT_BUFFER buf, EPSint32 len)
{
  DtGZFILE	*m;
  
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  *len = gzwrite (m->handler, buf.dat, *len);
  return *len;
}


ESint32 EDMAPROC 
GZFILEputsZS32rS32 (OBJID IdObj, EPChar s,ESint32 len)
{
  DtGZFILE	*m;
  EPChar        s1;
  ESint32       l;
  
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  s1 = strdup (s);

  l = len;
  if (l > strlen (s1))
    l = strlen(s1);
  else
    s1[l] = 0;

  gzputs (m->handler, s1);
  free (s1);

  return l;
}


ESint32 EDMAPROC 
GZFILEputcCS32rS32 (OBJID IdObj, EChar c)
{
  DtGZFILE	*m;

  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  return gzputc (m->handler, c);
}


EPChar EDMAPROC 
GZFILEgetssZsS32rS32 (OBJID IdObj, EPChar s, EPSint32 len)
{
  DtGZFILE	*m;
  
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  return gzgets (m->handler, s, *len);
}


ESint32 EDMAPROC 
GZFILEgetcsCrS32 (OBJID IdObj, EPChar c)
{
  DtGZFILE	*m;
  int           r;
  
  m = (DtGZFILE*) edma_get_data_ref(IdObj);

  r = gzgetc (m->handler);
  *c = (char) r;

  return r;
}


ESint32 EDMAPROC 
GZFILEflushrS32 (OBJID IdObj)
{
  DtGZFILE	*m;
  
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  /* FIXME: zlib allows various types of flushing*/
  return gzflush (m->handler, Z_SYNC_FLUSH);

}


ESint32 EDMAPROC 
GZFILEseekS32ZrS32 (OBJID IdObj, ESint32 off, EPChar where)
{
  DtGZFILE	*m;
  int           w;
  
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  if (strncmp (where, "SEEK_SET", 8) == 0)
    w = SEEK_SET;
  else 
    { 
      if (strncmp (where, "SEEK_END", 8) == 0) 
	{
	  /*w=SEEK_END;*/
	  edma_printf_obj (IdObj,"%s", "SEEK_END nor supported by zlib");
	  return -1;
	}
      else
	w = SEEK_CUR;
    }
  return gzseek (m->handler, off, w);
	
}


ESint32 EDMAPROC 
GZFILEtellsS32rS32 (OBJID IdObj, EPSint32 off)
{
  DtGZFILE	*m;
  
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  *off = gztell (m->handler);
  return *off;
}


ESint32 EDMAPROC 
GZFILErewindrS32 (OBJID IdObj)
{
  DtGZFILE	*m;
  
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  gztell (m->handler);
  return 0;
}


ESint32 EDMAPROC 
GZFILEeofrS32 (OBJID IdObj)
{
  DtGZFILE	*m;
 
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  return gzeof (m->handler);
}


ESint32 EDMAPROC 
GZFILEerrorrS32 (OBJID IdObj)
{
  DtGZFILE	*m;
  
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "%s", "Method still not implemented");
  return 0;
}


ESint32 EDMAPROC 
GZFILELoadZsArS32 (OBJID IdObj, EPChar Name, EDMAT_BUFFER *buf)
{
  DtGZFILE	*m;
  
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "%s", "Method still not implemented");
  return 0;
}


ESint32 EDMAPROC 
GZFILESaveZArS32 (OBJID IdObj, EPChar name, EDMAT_BUFFER buf)
{
  DtGZFILE	*m;
  
  m = (DtGZFILE*) edma_get_data_ref (IdObj);
  edma_printf_obj (IdObj, "%s", "Method still not implemented");
  return 0;
}



/********** END C IMPLEMENTATION SKELETON ******************/
