package Venus::Float;

use 5.018;

use strict;
use warnings;

use Venus::Class 'base';

base 'Venus::Number';

# METHODS

sub default {
  return '0.0';
}

1;



=head1 NAME

Venus::Float - Float Class

=cut

=head1 ABSTRACT

Float Class for Perl 5

=cut

=head1 SYNOPSIS

  package main;

  use Venus::Float;

  my $float = Venus::Float->new(1.23);

  # $float->int;

=cut

=head1 DESCRIPTION

This package provides methods for manipulating float data.

=cut

=head1 INHERITS

This package inherits behaviors from:

L<Venus::Number>

=cut

=head1 METHODS

This package provides the following methods:

=cut

=head2 cast

  cast(string $kind) (object | undef)

The cast method converts L<"value"|Venus::Kind::Value> objects between
different I<"value"> object types, based on the name of the type provided. This
method will return C<undef> if the invocant is not a L<Venus::Kind::Value>.

I<Since C<0.08>>

=over 4

=item cast example 1

  package main;

  use Venus::Float;

  my $float = Venus::Float->new;

  my $cast = $float->cast('array');

  # bless({ value => ["0.0"] }, "Venus::Array")

=back

=over 4

=item cast example 2

  package main;

  use Venus::Float;

  my $float = Venus::Float->new;

  my $cast = $float->cast('boolean');

  # bless({ value => 1 }, "Venus::Boolean")

=back

=over 4

=item cast example 3

  package main;

  use Venus::Float;

  my $float = Venus::Float->new;

  my $cast = $float->cast('code');

  # bless({ value => sub { ... } }, "Venus::Code")

=back

=over 4

=item cast example 4

  package main;

  use Venus::Float;

  my $float = Venus::Float->new;

  my $cast = $float->cast('float');

  # bless({ value => "0.0" }, "Venus::Float")

=back

=over 4

=item cast example 5

  package main;

  use Venus::Float;

  my $float = Venus::Float->new;

  my $cast = $float->cast('hash');

  # bless({ value => { "0.0" => "0.0" } }, "Venus::Hash")

=back

=over 4

=item cast example 6

  package main;

  use Venus::Float;

  my $float = Venus::Float->new;

  my $cast = $float->cast('number');

  # bless({ value => 0 }, "Venus::Number")

=back

=over 4

=item cast example 7

  package main;

  use Venus::Float;

  my $float = Venus::Float->new;

  my $cast = $float->cast('regexp');

  # bless({ value => qr/(?^u:0\.0)/ }, "Venus::Regexp")

=back

=over 4

=item cast example 8

  package main;

  use Venus::Float;

  my $float = Venus::Float->new;

  my $cast = $float->cast('scalar');

  # bless({ value => \"0.0" }, "Venus::Scalar")

=back

=over 4

=item cast example 9

  package main;

  use Venus::Float;

  my $float = Venus::Float->new;

  my $cast = $float->cast('string');

  # bless({ value => "0.0" }, "Venus::String")

=back

=over 4

=item cast example 10

  package main;

  use Venus::Float;

  my $float = Venus::Float->new;

  my $cast = $float->cast('undef');

  # bless({ value => undef }, "Venus::Undef")

=back

=cut

=head2 default

  default() (string)

The default method returns the default value, i.e. C<0.0>.

I<Since C<0.01>>

=over 4

=item default example 1

  # given: synopsis;

  my $default = $float->default;

  # "0.0"

=back

=cut

=head2 eq

  eq(any $arg) (boolean)

The eq method performs an I<"equals"> operation using the argument provided.

I<Since C<0.08>>

=over 4

=item eq example 1

  package main;

  use Venus::Array;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Array->new;

  my $result = $lvalue->eq($rvalue);

  # 0

=back

=over 4

=item eq example 2

  package main;

  use Venus::Code;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Code->new;

  my $result = $lvalue->eq($rvalue);

  # 0

=back

=over 4

=item eq example 3

  package main;

  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Float->new;

  my $result = $lvalue->eq($rvalue);

  # 1

=back

=over 4

=item eq example 4

  package main;

  use Venus::Float;
  use Venus::Hash;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Hash->new;

  my $result = $lvalue->eq($rvalue);

  # 0

=back

=over 4

=item eq example 5

  package main;

  use Venus::Float;
  use Venus::Number;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Number->new;

  my $result = $lvalue->eq($rvalue);

  # 1

=back

=over 4

=item eq example 6

  package main;

  use Venus::Float;
  use Venus::Regexp;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Regexp->new;

  my $result = $lvalue->eq($rvalue);

  # 0

=back

=over 4

=item eq example 7

  package main;

  use Venus::Float;
  use Venus::Scalar;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Scalar->new;

  my $result = $lvalue->eq($rvalue);

  # 0

=back

=over 4

=item eq example 8

  package main;

  use Venus::Float;
  use Venus::String;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::String->new;

  my $result = $lvalue->eq($rvalue);

  # 1

=back

=over 4

=item eq example 9

  package main;

  use Venus::Float;
  use Venus::Undef;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Undef->new;

  my $result = $lvalue->eq($rvalue);

  # 1

=back

=cut

=head2 ge

  ge(any $arg) (boolean)

The ge method performs a I<"greater-than-or-equal-to"> operation using the
argument provided.

I<Since C<0.08>>

=over 4

=item ge example 1

  package main;

  use Venus::Array;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Array->new;

  my $result = $lvalue->ge($rvalue);

  # 0

=back

=over 4

=item ge example 2

  package main;

  use Venus::Code;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Code->new;

  my $result = $lvalue->ge($rvalue);

  # 0

=back

=over 4

=item ge example 3

  package main;

  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Float->new;

  my $result = $lvalue->ge($rvalue);

  # 1

=back

=over 4

=item ge example 4

  package main;

  use Venus::Float;
  use Venus::Hash;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Hash->new;

  my $result = $lvalue->ge($rvalue);

  # 0

=back

=over 4

=item ge example 5

  package main;

  use Venus::Float;
  use Venus::Number;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Number->new;

  my $result = $lvalue->ge($rvalue);

  # 1

=back

=over 4

=item ge example 6

  package main;

  use Venus::Float;
  use Venus::Regexp;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Regexp->new;

  my $result = $lvalue->ge($rvalue);

  # 0

=back

=over 4

=item ge example 7

  package main;

  use Venus::Float;
  use Venus::Scalar;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Scalar->new;

  my $result = $lvalue->ge($rvalue);

  # 0

=back

=over 4

=item ge example 8

  package main;

  use Venus::Float;
  use Venus::String;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::String->new;

  my $result = $lvalue->ge($rvalue);

  # 1

=back

=over 4

=item ge example 9

  package main;

  use Venus::Float;
  use Venus::Undef;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Undef->new;

  my $result = $lvalue->ge($rvalue);

  # 1

=back

=cut

=head2 gele

  gele(any $arg1, any $arg2) (boolean)

The gele method performs a I<"greater-than-or-equal-to"> operation on the 1st
argument, and I<"lesser-than-or-equal-to"> operation on the 2nd argument.

I<Since C<0.08>>

=over 4

=item gele example 1

  package main;

  use Venus::Array;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Array->new;

  my $result = $lvalue->gele($rvalue);

  # 0

=back

=over 4

=item gele example 2

  package main;

  use Venus::Code;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Code->new;

  my $result = $lvalue->gele($rvalue);

  # 0

=back

=over 4

=item gele example 3

  package main;

  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Float->new;

  my $result = $lvalue->gele($rvalue);

  # 1

=back

=over 4

=item gele example 4

  package main;

  use Venus::Float;
  use Venus::Hash;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Hash->new;

  my $result = $lvalue->gele($rvalue);

  # 0

=back

=over 4

=item gele example 5

  package main;

  use Venus::Float;
  use Venus::Number;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Number->new;

  my $result = $lvalue->gele($rvalue);

  # 1

=back

=over 4

=item gele example 6

  package main;

  use Venus::Float;
  use Venus::Regexp;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Regexp->new;

  my $result = $lvalue->gele($rvalue);

  # 0

=back

=over 4

=item gele example 7

  package main;

  use Venus::Float;
  use Venus::Scalar;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Scalar->new;

  my $result = $lvalue->gele($rvalue);

  # 0

=back

=over 4

=item gele example 8

  package main;

  use Venus::Float;
  use Venus::String;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::String->new;

  my $result = $lvalue->gele($rvalue);

  # 1

=back

=over 4

=item gele example 9

  package main;

  use Venus::Float;
  use Venus::Undef;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Undef->new;

  my $result = $lvalue->gele($rvalue);

  # 1

=back

=cut

=head2 gt

  gt(any $arg) (boolean)

The gt method performs a I<"greater-than"> operation using the argument provided.

I<Since C<0.08>>

=over 4

=item gt example 1

  package main;

  use Venus::Array;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Array->new;

  my $result = $lvalue->gt($rvalue);

  # 0

=back

=over 4

=item gt example 2

  package main;

  use Venus::Code;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Code->new;

  my $result = $lvalue->gt($rvalue);

  # 0

=back

=over 4

=item gt example 3

  package main;

  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Float->new;

  my $result = $lvalue->gt($rvalue);

  # 0

=back

=over 4

=item gt example 4

  package main;

  use Venus::Float;
  use Venus::Hash;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Hash->new;

  my $result = $lvalue->gt($rvalue);

  # 0

=back

=over 4

=item gt example 5

  package main;

  use Venus::Float;
  use Venus::Number;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Number->new;

  my $result = $lvalue->gt($rvalue);

  # 0

=back

=over 4

=item gt example 6

  package main;

  use Venus::Float;
  use Venus::Regexp;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Regexp->new;

  my $result = $lvalue->gt($rvalue);

  # 0

=back

=over 4

=item gt example 7

  package main;

  use Venus::Float;
  use Venus::Scalar;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Scalar->new;

  my $result = $lvalue->gt($rvalue);

  # 0

=back

=over 4

=item gt example 8

  package main;

  use Venus::Float;
  use Venus::String;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::String->new;

  my $result = $lvalue->gt($rvalue);

  # 0

=back

=over 4

=item gt example 9

  package main;

  use Venus::Float;
  use Venus::Undef;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Undef->new;

  my $result = $lvalue->gt($rvalue);

  # 0

=back

=cut

=head2 gtlt

  gtlt(any $arg1, any $arg2) (boolean)

The gtlt method performs a I<"greater-than"> operation on the 1st argument, and
I<"lesser-than"> operation on the 2nd argument.

I<Since C<0.08>>

=over 4

=item gtlt example 1

  package main;

  use Venus::Array;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Array->new;

  my $result = $lvalue->gtlt($rvalue);

  # 0

=back

=over 4

=item gtlt example 2

  package main;

  use Venus::Code;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Code->new;

  my $result = $lvalue->gtlt($rvalue);

  # 0

=back

=over 4

=item gtlt example 3

  package main;

  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Float->new;

  my $result = $lvalue->gtlt($rvalue);

  # 0

=back

=over 4

=item gtlt example 4

  package main;

  use Venus::Float;
  use Venus::Hash;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Hash->new;

  my $result = $lvalue->gtlt($rvalue);

  # 0

=back

=over 4

=item gtlt example 5

  package main;

  use Venus::Float;
  use Venus::Number;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Number->new;

  my $result = $lvalue->gtlt($rvalue);

  # 0

=back

=over 4

=item gtlt example 6

  package main;

  use Venus::Float;
  use Venus::Regexp;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Regexp->new;

  my $result = $lvalue->gtlt($rvalue);

  # 0

=back

=over 4

=item gtlt example 7

  package main;

  use Venus::Float;
  use Venus::Scalar;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Scalar->new;

  my $result = $lvalue->gtlt($rvalue);

  # 0

=back

=over 4

=item gtlt example 8

  package main;

  use Venus::Float;
  use Venus::String;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::String->new;

  my $result = $lvalue->gtlt($rvalue);

  # 0

=back

=over 4

=item gtlt example 9

  package main;

  use Venus::Float;
  use Venus::Undef;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Undef->new;

  my $result = $lvalue->gtlt($rvalue);

  # 0

=back

=cut

=head2 le

  le(any $arg) (boolean)

The le method performs a I<"lesser-than-or-equal-to"> operation using the
argument provided.

I<Since C<0.08>>

=over 4

=item le example 1

  package main;

  use Venus::Array;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Array->new;

  my $result = $lvalue->le($rvalue);

  # 1

=back

=over 4

=item le example 2

  package main;

  use Venus::Code;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Code->new;

  my $result = $lvalue->le($rvalue);

  # 1

=back

=over 4

=item le example 3

  package main;

  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Float->new;

  my $result = $lvalue->le($rvalue);

  # 1

=back

=over 4

=item le example 4

  package main;

  use Venus::Float;
  use Venus::Hash;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Hash->new;

  my $result = $lvalue->le($rvalue);

  # 1

=back

=over 4

=item le example 5

  package main;

  use Venus::Float;
  use Venus::Number;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Number->new;

  my $result = $lvalue->le($rvalue);

  # 1

=back

=over 4

=item le example 6

  package main;

  use Venus::Float;
  use Venus::Regexp;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Regexp->new;

  my $result = $lvalue->le($rvalue);

  # 1

=back

=over 4

=item le example 7

  package main;

  use Venus::Float;
  use Venus::Scalar;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Scalar->new;

  my $result = $lvalue->le($rvalue);

  # 1

=back

=over 4

=item le example 8

  package main;

  use Venus::Float;
  use Venus::String;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::String->new;

  my $result = $lvalue->le($rvalue);

  # 1

=back

=over 4

=item le example 9

  package main;

  use Venus::Float;
  use Venus::Undef;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Undef->new;

  my $result = $lvalue->le($rvalue);

  # 1

=back

=cut

=head2 lt

  lt(any $arg) (boolean)

The lt method performs a I<"lesser-than"> operation using the argument provided.

I<Since C<0.08>>

=over 4

=item lt example 1

  package main;

  use Venus::Array;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Array->new;

  my $result = $lvalue->lt($rvalue);

  # 1

=back

=over 4

=item lt example 2

  package main;

  use Venus::Code;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Code->new;

  my $result = $lvalue->lt($rvalue);

  # 1

=back

=over 4

=item lt example 3

  package main;

  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Float->new;

  my $result = $lvalue->lt($rvalue);

  # 0

=back

=over 4

=item lt example 4

  package main;

  use Venus::Float;
  use Venus::Hash;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Hash->new;

  my $result = $lvalue->lt($rvalue);

  # 1

=back

=over 4

=item lt example 5

  package main;

  use Venus::Float;
  use Venus::Number;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Number->new;

  my $result = $lvalue->lt($rvalue);

  # 0

=back

=over 4

=item lt example 6

  package main;

  use Venus::Float;
  use Venus::Regexp;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Regexp->new;

  my $result = $lvalue->lt($rvalue);

  # 1

=back

=over 4

=item lt example 7

  package main;

  use Venus::Float;
  use Venus::Scalar;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Scalar->new;

  my $result = $lvalue->lt($rvalue);

  # 1

=back

=over 4

=item lt example 8

  package main;

  use Venus::Float;
  use Venus::String;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::String->new;

  my $result = $lvalue->lt($rvalue);

  # 0

=back

=over 4

=item lt example 9

  package main;

  use Venus::Float;
  use Venus::Undef;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Undef->new;

  my $result = $lvalue->lt($rvalue);

  # 0

=back

=cut

=head2 ne

  ne(any $arg) (boolean)

The ne method performs a I<"not-equal-to"> operation using the argument provided.

I<Since C<0.08>>

=over 4

=item ne example 1

  package main;

  use Venus::Array;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Array->new;

  my $result = $lvalue->ne($rvalue);

  # 1

=back

=over 4

=item ne example 2

  package main;

  use Venus::Code;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Code->new;

  my $result = $lvalue->ne($rvalue);

  # 1

=back

=over 4

=item ne example 3

  package main;

  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Float->new;

  my $result = $lvalue->ne($rvalue);

  # 0

=back

=over 4

=item ne example 4

  package main;

  use Venus::Float;
  use Venus::Hash;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Hash->new;

  my $result = $lvalue->ne($rvalue);

  # 1

=back

=over 4

=item ne example 5

  package main;

  use Venus::Float;
  use Venus::Number;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Number->new;

  my $result = $lvalue->ne($rvalue);

  # 0

=back

=over 4

=item ne example 6

  package main;

  use Venus::Float;
  use Venus::Regexp;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Regexp->new;

  my $result = $lvalue->ne($rvalue);

  # 1

=back

=over 4

=item ne example 7

  package main;

  use Venus::Float;
  use Venus::Scalar;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Scalar->new;

  my $result = $lvalue->ne($rvalue);

  # 1

=back

=over 4

=item ne example 8

  package main;

  use Venus::Float;
  use Venus::String;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::String->new;

  my $result = $lvalue->ne($rvalue);

  # 0

=back

=over 4

=item ne example 9

  package main;

  use Venus::Float;
  use Venus::Undef;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Undef->new;

  my $result = $lvalue->ne($rvalue);

  # 0

=back

=cut

=head2 tv

  tv(any $arg) (boolean)

The tv method performs a I<"type-and-value-equal-to"> operation using argument
provided.

I<Since C<0.08>>

=over 4

=item tv example 1

  package main;

  use Venus::Array;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Array->new;

  my $result = $lvalue->tv($rvalue);

  # 0

=back

=over 4

=item tv example 2

  package main;

  use Venus::Code;
  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Code->new;

  my $result = $lvalue->tv($rvalue);

  # 0

=back

=over 4

=item tv example 3

  package main;

  use Venus::Float;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Float->new;

  my $result = $lvalue->tv($rvalue);

  # 1

=back

=over 4

=item tv example 4

  package main;

  use Venus::Float;
  use Venus::Hash;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Hash->new;

  my $result = $lvalue->tv($rvalue);

  # 0

=back

=over 4

=item tv example 5

  package main;

  use Venus::Float;
  use Venus::Number;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Number->new;

  my $result = $lvalue->tv($rvalue);

  # 0

=back

=over 4

=item tv example 6

  package main;

  use Venus::Float;
  use Venus::Regexp;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Regexp->new;

  my $result = $lvalue->tv($rvalue);

  # 0

=back

=over 4

=item tv example 7

  package main;

  use Venus::Float;
  use Venus::Scalar;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Scalar->new;

  my $result = $lvalue->tv($rvalue);

  # 0

=back

=over 4

=item tv example 8

  package main;

  use Venus::Float;
  use Venus::String;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::String->new;

  my $result = $lvalue->tv($rvalue);

  # 0

=back

=over 4

=item tv example 9

  package main;

  use Venus::Float;
  use Venus::Undef;

  my $lvalue = Venus::Float->new;
  my $rvalue = Venus::Undef->new;

  my $result = $lvalue->tv($rvalue);

  # 0

=back

=cut

=head1 AUTHORS

Awncorp, C<awncorp@cpan.org>

=cut

=head1 LICENSE

Copyright (C) 2022, Awncorp, C<awncorp@cpan.org>.

This program is free software, you can redistribute it and/or modify it under
the terms of the Apache license version 2.0.

=cut