/*------------------------------------------------------------------------------
Function:       jsTrace()
Author:         Aaron Gustafson (aaron at easy-designs dot net)
Creation Date:  26 October 2005
Version:        1.0
Homepage:       http://www.easy-designs.net/code/jsTrace/
License:        Creative Commons Attribution-ShareAlike 2.0 License
                http://creativecommons.org/licenses/by-sa/2.0/
Note:           If you change or improve on this script, please let us know by 
                emailing the author (above) with a link to your demo page.
------------------------------------------------------------------------------*/
var jsTrace = { debugging_on: false, window: null, viewport: null, init: function(){ if( !document.getElementsByTagName || !document.getElementById || !document.createElement || !document.createTextNode ) return; jsTrace.createWindow(); jsTrace.debugging_on = true;}, createWindow: function(){ jsTrace.window = document.createElement( 'div' ); jsTrace.window.style.background = '#000'; jsTrace.window.style.font = '80% "Lucida Grande", "Lucida Sans Unicode", Helvetica, Arial, sans-serif'; jsTrace.window.style.padding = '2px'; jsTrace.window.style.position = 'absolute'; jsTrace.window.style.top = '50px'; jsTrace.window.style.left = '700px'; jsTrace.window.style.height = '360px'; jsTrace.window.style.zIndex = '100'; jsTrace.window.style.minHeight = '150px'; jsTrace.window.style.width = '190px'; jsTrace.window.style.minWidth = '150px'; var x = document.createElement('span'); x.style.border = '1px solid #000'; x.style.cursor = 'pointer'; x.style.color = '#000'; x.style.display = 'block'; x.style.lineHeight = '.5em'; x.style.padding = '0 0 3px'; x.style.position = 'absolute'; x.style.top = '4px'; x.style.right = '4px'; jsTrace.addEvent( x, 'click', function(){ jsTrace.kill();} ); x.setAttribute( 'title', 'Close jsTrace Debugger' ); x.appendChild( document.createTextNode( 'x' ) ); jsTrace.window.appendChild( x ); var sh = document.createElement('div'); sh.style.position = 'absolute'; sh.style.bottom = '3px'; sh.style.right = '3px'; var sg = document.createElement('span'); sg.style.border = '5px solid #ccc'; sg.style.borderLeftColor = sg.style.borderTopColor = '#000'; sg.style.cursor = 'pointer'; sg.style.color = '#ccc'; sg.style.display = 'block'; sg.style.height = '0'; sg.style.width = '0'; sg.style.overflow = 'hidden'; sg.setAttribute( 'title', 'Resize the jsTrace Debugger' ); if( typeof( Drag ) != 'undefined' ){ sg.xFrom = 0; sg.yFrom = 0; Drag.init( sg, null, null, null, null, null, true, true ); sg.onDrag = function( x, y ){ jsTrace.resizeX( x, this ); jsTrace.resizeY( y, this );}; sh.appendChild( sg ); jsTrace.window.appendChild( sh );} var tools = document.createElement( 'div' ); tools.style.fontSize = '.7em'; tools.style.fontVariant = 'small-caps'; tools.style.lineHeight = '10px'; tools.style.position = 'absolute'; tools.style.bottom = '5px'; tools.style.left = '3px'; var dl = document.createElement( 'span' ); dl.style.color = '#ccc'; dl.style.padding = '0 10px 0 0'; dl.style.overflow = 'hidden'; dl.style.cursor = 'pointer'; dl.setAttribute( 'title', 'Add a Delimeter' ); dl.appendChild( document.createTextNode( 'delimit' ) ); jsTrace.addEvent( dl, 'click', function(){ jsTrace.sendDelimeter();} ); tools.appendChild( dl ); var cl = document.createElement( 'span' ); cl.style.color = '#ccc'; cl.style.padding = '0 10px 0 0'; cl.style.overflow = 'hidden'; cl.style.cursor = 'pointer'; cl.setAttribute( 'title', 'Add a Delimeter' ); cl.appendChild( document.createTextNode( 'clear' ) ); jsTrace.addEvent( cl, 'click', function(){ jsTrace.clearWindow();} ); tools.appendChild( cl ); jsTrace.window.appendChild( tools ); var header = document.createElement( 'h3' ); header.style.background = '#ccc'; header.style.color = '#000'; header.style.cursor = 'pointer'; header.style.fontSize = '1em'; header.style.fontVariant = 'small-caps'; header.style.margin = '0 0 2px'; header.style.padding = '5px 10px'; header.style.lineHeight = '15px'; header.appendChild( document.createTextNode( 'jsTrace Debugger' ) ); jsTrace.window.appendChild( header ); jsTrace.viewport = document.createElement( 'pre' ); jsTrace.viewport.style.border = '1px solid #ccc'; jsTrace.viewport.style.color = '#ebebeb'; jsTrace.viewport.style.fontSize = '1.2em'; jsTrace.viewport.style.margin = '0'; jsTrace.viewport.style.padding = '0 3px'; jsTrace.viewport.style.position = 'absolute'; jsTrace.viewport.style.top = '30px'; jsTrace.viewport.style.left = '2px'; jsTrace.viewport.style.overflow = 'auto'; jsTrace.viewport.style.width = ( parseInt( jsTrace.window.style.width ) - 8 ) + 'px'; jsTrace.viewport.style.height = ( parseInt( jsTrace.window.style.height ) - 45 ) + 'px'; jsTrace.window.appendChild( jsTrace.viewport ); document.getElementsByTagName( 'body' )[0].appendChild( jsTrace.window ); if( typeof( Drag ) != 'undefined' ){ Drag.init( header, jsTrace.window );} }, resizeX: function( x, grip ){ var width = parseInt( jsTrace.window.style.width ); var newWidth = Math.abs( width - ( x - grip.xFrom ) ) + 'px'; if( parseInt( newWidth ) < parseInt( jsTrace.window.style.minWidth ) ) newWidth = jsTrace.window.style.minWidth; jsTrace.window.style.width = newWidth; grip.xFrom = x; jsTrace.viewport.style.width = ( parseInt( jsTrace.window.style.width ) - 8 ) + 'px';}, resizeY: function( y, grip ){ var height = parseInt( jsTrace.window.style.height ); var newHeight = Math.abs( height - ( y - grip.yFrom ) ) + 'px'; if( parseInt( newHeight ) < parseInt( jsTrace.window.style.minHeight ) ) newHeight = jsTrace.window.style.minHeight; jsTrace.window.style.height = newHeight; grip.yFrom = y; jsTrace.viewport.style.height = ( parseInt( jsTrace.window.style.height ) - 45 ) + 'px';}, send: function( text ){ text = text + "<br />"; jsTrace.viewport.innerHTML += text;}, sendDelimeter: function(){ jsTrace.send( '<span style="color: #f00">--------------------</span>' );}, clearWindow: function(){ jsTrace.viewport.innerHTML = '';}, kill: function() { jsTrace.window.parentNode.removeChild( jsTrace.window ); jsTrace.debugging_on = false;}, addEvent: function( obj, type, fn ){ if (obj.addEventListener) obj.addEventListener( type, fn, false ); else if (obj.attachEvent) { obj["e"+type+fn] = fn; obj[type+fn] = function() { obj["e"+type+fn]( window.event );}; obj.attachEvent( "on"+type, obj[type+fn] );} }, removeEvent: function ( obj, type, fn ) { if (obj.removeEventListener) obj.removeEventListener( type, fn, false ); else if (obj.detachEvent) { obj.detachEvent( "on"+type, obj[type+fn] ); obj[type+fn] = null; obj["e"+type+fn] = null;} } }; jsTrace.addEvent( window, 'load', jsTrace.init ); 