/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.resource;

import java.util.Map;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.lib.Resource;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.FunctionItemType;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataResource
implements Resource {
    private Map<String, Sequence> properties;
    private String resourceURI;
    private Resource content;

    public MetadataResource(String resourceURI, Resource content, Map<String, Sequence> properties) {
        this.resourceURI = resourceURI;
        this.content = content;
        this.properties = properties;
    }

    @Override
    public String getContentType() {
        return this.content.getContentType();
    }

    @Override
    public String getResourceURI() {
        return this.resourceURI;
    }

    @Override
    public Item getItem(XPathContext context) throws XPathException {
        HashTrieMap map = new HashTrieMap();
        for (Map.Entry<String, Sequence> entry : this.properties.entrySet()) {
            map = map.addEntry(StringValue.makeStringValue(entry.getKey()), entry.getValue());
        }
        map = map.addEntry(StringValue.makeStringValue("name"), StringValue.makeStringValue(this.resourceURI));
        Callable fetcher = new Callable(){

            public Item call(XPathContext context, Sequence[] arguments) throws XPathException {
                return MetadataResource.this.content.getItem(context);
            }
        };
        SpecificFunctionType fetcherType = new SpecificFunctionType(new SequenceType[0], SequenceType.SINGLE_ITEM);
        CallableFunction fetcherFunction = new CallableFunction(0, fetcher, (FunctionItemType)fetcherType);
        map = map.addEntry(StringValue.makeStringValue("fetch"), fetcherFunction);
        return map;
    }
}

