# Generated by default/object.tt
package Paws::Proton::Environment;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest'], required => 1);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest'], required => 1);
  has DeploymentStatus => (is => 'ro', isa => 'Str', request_name => 'deploymentStatus', traits => ['NameInRequest'], required => 1);
  has DeploymentStatusMessage => (is => 'ro', isa => 'Str', request_name => 'deploymentStatusMessage', traits => ['NameInRequest']);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest']);
  has EnvironmentAccountConnectionId => (is => 'ro', isa => 'Str', request_name => 'environmentAccountConnectionId', traits => ['NameInRequest']);
  has EnvironmentAccountId => (is => 'ro', isa => 'Str', request_name => 'environmentAccountId', traits => ['NameInRequest']);
  has LastDeploymentAttemptedAt => (is => 'ro', isa => 'Str', request_name => 'lastDeploymentAttemptedAt', traits => ['NameInRequest'], required => 1);
  has LastDeploymentSucceededAt => (is => 'ro', isa => 'Str', request_name => 'lastDeploymentSucceededAt', traits => ['NameInRequest'], required => 1);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has ProtonServiceRoleArn => (is => 'ro', isa => 'Str', request_name => 'protonServiceRoleArn', traits => ['NameInRequest']);
  has Provisioning => (is => 'ro', isa => 'Str', request_name => 'provisioning', traits => ['NameInRequest']);
  has Spec => (is => 'ro', isa => 'Str', request_name => 'spec', traits => ['NameInRequest']);
  has TemplateMajorVersion => (is => 'ro', isa => 'Str', request_name => 'templateMajorVersion', traits => ['NameInRequest'], required => 1);
  has TemplateMinorVersion => (is => 'ro', isa => 'Str', request_name => 'templateMinorVersion', traits => ['NameInRequest'], required => 1);
  has TemplateName => (is => 'ro', isa => 'Str', request_name => 'templateName', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Proton::Environment

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Proton::Environment object:

  $service_obj->Method(Att1 => { Arn => $value, ..., TemplateName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Proton::Environment object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

The environment detail data. An AWS Proton environment is a set
resources shared across an AWS Proton service.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Arn => Str

The Amazon Resource Name (ARN) of the environment.


=head2 B<REQUIRED> CreatedAt => Str

The time when the environment was created.


=head2 B<REQUIRED> DeploymentStatus => Str

The environment deployment status.


=head2 DeploymentStatusMessage => Str

An environment deployment status message.


=head2 Description => Str

The description of the environment.


=head2 EnvironmentAccountConnectionId => Str

The ID of the environment account connection that's used to provision
infrastructure resources in an environment account.


=head2 EnvironmentAccountId => Str

The ID of the environment account that the environment infrastructure
resources are provisioned in.


=head2 B<REQUIRED> LastDeploymentAttemptedAt => Str

The time when a deployment of the environment was last attempted.


=head2 B<REQUIRED> LastDeploymentSucceededAt => Str

The time when the environment was last deployed successfully.


=head2 B<REQUIRED> Name => Str

The name of the environment.


=head2 ProtonServiceRoleArn => Str

The ARN of the AWS Proton service role that allows AWS Proton to make
calls to other services on your behalf.


=head2 Provisioning => Str

When included, indicates that the environment template is for customer
provisioned and managed infrastructure.


=head2 Spec => Str

The environment spec.


=head2 B<REQUIRED> TemplateMajorVersion => Str

The ID of the major version of the environment template.


=head2 B<REQUIRED> TemplateMinorVersion => Str

The ID of the minor version of the environment template.


=head2 B<REQUIRED> TemplateName => Str

The ARN of the environment template.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Proton>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

