package IO::Iron::IronCache::Api;

## no critic (Documentation::RequirePodAtEnd)
## no critic (Documentation::RequirePodSections)

use 5.010_000;
use strict;
use warnings;

# Global Creator
BEGIN {
}

# Global Destructor
END {
}


# ABSTRACT: IronCache API reference for Perl Client Libraries!

our $VERSION = '0.12_01'; # TRIAL VERSION: generated by DZP::OurPkgVersion





sub IRONCACHE_LIST_CACHES {
	return {
			'action_name'  => 'IRONCACHE_LIST_CACHES',
			'href'         => '{Protocol}://{Host}:{Port}/{API Version}/projects/{Project ID}/caches',
			'action'       => 'GET',
			'return'       => 'LIST',
			'retry'        => 0,
			'require_body' => 0,
			'paged'        => 1,
			'per_page'     => 100,
			'url_escape'   => { '{Project ID}' => 1 },
			'log_message'  => '(project={Project ID}). Listed caches.',
		};
}


sub IRONCACHE_GET_INFO_ABOUT_A_CACHE {
	return {
			'action_name'  => 'IRONCACHE_GET_INFO_ABOUT_A_CACHE',
			'href'         => '{Protocol}://{Host}:{Port}/{API Version}/projects/{Project ID}/caches/{Cache Name}',
			'action'       => 'GET',
			'return'       => 'HASH',
			'retry'        => 1,
			'require_body' => 0,
			'url_escape'   => { '{Project ID}' => 1, '{Cache Name}' => 1 },
			'log_message'  => '(project={Project ID}, cache={Cache Name}). Got info about a cache.',
		};
}


sub IRONCACHE_DELETE_A_CACHE {
	return {
			'action_name'  => 'IRONCACHE_DELETE_A_CACHE',
			'href'         => '{Protocol}://{Host}:{Port}/{API Version}/projects/{Project ID}/caches/{Cache Name}',
			'action'       => 'DELETE',
			'return'       => 'MESSAGE',
			'retry'        => 1,
			'require_body' => 0,
			'url_escape'   => { '{Project ID}' => 1, '{Cache Name}' => 1 },
			'log_message'  => '(project={Project ID}, cache={Cache Name}). Deleted cache.',
		};
}


sub IRONCACHE_CLEAR_A_CACHE {
	return {
			'action_name'  => 'IRONCACHE_CLEAR_A_CACHE',
			'href'         => '{Protocol}://{Host}:{Port}/{API Version}/projects/{Project ID}/caches/{Cache Name}/clear',
			'action'       => 'POST',
			'return'       => 'MESSAGE',
			'retry'        => 0,
			'require_body' => 0,
			'paged'        => 0,
			'per_page'     => 0,
			'url_escape'   => { '{Project ID}' => 1, '{Cache Name}' => 1 },
			'log_message'  => '(project={Project ID}, cache={Cache Name}). Cleared cache.',
		};
}


sub IRONCACHE_PUT_AN_ITEM_INTO_A_CACHE {
	return {
			'action_name'  => 'IRONCACHE_PUT_AN_ITEM_INTO_A_CACHE',
			'href'         => '{Protocol}://{Host}:{Port}/{API Version}/projects/{Project ID}/caches/{Cache Name}/items/{Key}',
			'action'       => 'PUT',
			'return'       => 'MESSAGE',
			'retry'        => 0,
			'require_body' => 1,
			'paged'        => 0,
			'per_page'     => 0,
			'request_fields' => {'value' => '{Value}', 'expires_in' => '{Expires In}', 'replace' => '{Replace}', 'add' => '{Put}', 'cas' => '{Cas}'},
			'url_escape'   => { '{Project ID}' => 1, '{Cache Name}' => 1, '{Key}' => 1 },
			'log_message'  => '(project={Project ID}, cache={Cache Name}, item={Key}). Put item into cache. Value: \'{Value}\', Expires in: \'{Expires In}\', Replace: \'{Replace}\', Put: \'{Put}\', Cas: \'{Cas}\'.',
		};
}


sub IRONCACHE_INCREMENT_AN_ITEMS_VALUE {
	return {
			'action_name'  => 'IRONCACHE_INCREMENT_AN_ITEMS_VALUE',
			'href'         => '{Protocol}://{Host}:{Port}/{API Version}/projects/{Project ID}/caches/{Cache Name}/items/{Key}/increment',
			'action'       => 'POST',
			'return'       => 'HASH',
			'retry'        => 0,
			'require_body' => 1,
			'paged'        => 0,
			'per_page'     => 0,
			'request_fields' => {'amount' => '{Amount}'},
			'url_escape'   => { '{Project ID}' => 1, '{Cache Name}' => 1, '{Key}' => 1 },
			'log_message'  => '(project={Project ID}, cache={Cache Name}, item={Key}). Incremented items value by \'{Amount}\'.',
		};
}


sub IRONCACHE_GET_AN_ITEM_FROM_A_CACHE {
	return {
			'action_name'  => 'IRONCACHE_GET_AN_ITEM_FROM_A_CACHE',
			'href'         => '{Protocol}://{Host}:{Port}/{API Version}/projects/{Project ID}/caches/{Cache Name}/items/{Key}',
			'action'       => 'GET',
			'return'       => 'HASH',
			'retry'        => 0,
			'require_body' => 0,
			'url_escape'   => { '{Project ID}' => 1, '{Cache Name}' => 1, '{Key}' => 1 },
			'log_message'  => '(project={Project ID}, cache={Cache Name}, item={Key}). Got item from cache.',
		};
}


sub IRONCACHE_DELETE_AN_ITEM_FROM_A_CACHE {
	return {
			'action_name'  => 'IRONCACHE_DELETE_AN_ITEM_FROM_A_CACHE',
			'href'         => '{Protocol}://{Host}:{Port}/{API Version}/projects/{Project ID}/caches/{Cache Name}/items/{Key}',
			'action'       => 'DELETE',
			'return'       => 'MESSAGE',
			'retry'        => 0,
			'require_body' => 0,
			'url_escape'   => { '{Project ID}' => 1, '{Cache Name}' => 1, '{Key}' => 1 },
			'log_message'  => '(project={Project ID}, cache={Cache Name}, item={Key}). Deleted item from cache.',
		};
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

IO::Iron::IronCache::Api - IronCache API reference for Perl Client Libraries!

=head1 VERSION

version 0.12_01

=head1 SYNOPSIS

This package is for internal use of IO::Iron::IronCache::Client/Cache packages.

=head1 DESCRIPTION

The APIs to IronCache REST services.

=for stopwords IronCache API APIs Mikko Koivunalho perldoc CPAN AnnoCPAN

=for stopwords ACKNOWLEDGMENTS TODO tradename licensable MERCHANTABILITY

=head1 FUNCTIONS

=head2 Operate caches.

=head3 IRONCACHE_LIST_CACHES

/projects/{Project ID}/caches

=head3 IRONCACHE_GET_INFO_ABOUT_A_CACHE

/projects/{Project ID}/caches/{Cache Name}

=head3 IRONCACHE_DELETE_A_CACHE

/projects/{Project ID}/caches/{Cache Name}

=head2 Operate cache items.

=head3 IRONCACHE_CLEAR_A_CACHE

/projects/{Project ID}/caches/{Cache Name}/clear

=head3 IRONCACHE_PUT_AN_ITEM_INTO_A_CACHE

/projects/{Project ID}/caches/{Cache Name}/items/{Key}

=head3 IRONCACHE_INCREMENT_AN_ITEMS_VALUE

/projects/{Project ID}/caches/{Cache Name}/items/{Key}/increment

=head3 IRONCACHE_GET_AN_ITEM_FROM_A_CACHE

/projects/{Project ID}/caches/{Cache Name}/items/{Key}

=head3 IRONCACHE_DELETE_AN_ITEM_FROM_A_CACHE

/projects/{Project ID}/caches/{Cache Name}/items/{Key}

=head1 AUTHOR

Mikko Koivunalho <mikko.koivunalho@iki.fi>

=head1 BUGS

Please report any bugs or feature requests to bug-io-iron@rt.cpan.org or through the web interface at:
 http://rt.cpan.org/Public/Dist/Display.html?Name=IO-Iron

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Mikko Koivunalho.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

The full text of the license can be found in the
F<LICENSE> file included with this distribution.

=cut
