package App::Manoc::Form::TraitFor::SaveButton;
#ABSTRACT: Role for adding a BS3 'Save' button

use HTML::FormHandler::Moose::Role;

our $VERSION = '2.99.4'; ##TRIAL VERSION


has_field 'save' => (
    type           => 'Submit',
    widget         => 'ButtonTag',
    element_attr   => { class => [ 'btn', 'btn-primary' ] },
    widget_wrapper => 'None',
    value          => "Save",
    order          => 1000,
);

no HTML::FormHandler::Moose::Role;

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Form::TraitFor::SaveButton - Role for adding a BS3 'Save' button

=head1 VERSION

version 2.99.4

=head1 DESCRIPTION

Include this role to add a Bootstrap 3 submit button labeled 'Save'

=head1 FIELDS

=head2 save

The save button itself. Order is set to 1000 to make sure it is always at the bottom of the form.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
