package App::Manoc::DB::ResultSet::Rack;
#ABSTRACT: ResultSet class for Rack

use strict;
use warnings;

our $VERSION = '2.99.3'; ##TRIAL VERSION

use parent 'App::Manoc::DB::ResultSet';


sub manoc_search {
    my ( $self, $query, $result ) = @_;

    my $type = $query->query_type;
    return unless $type eq 'asset' or $type eq 'rack';

    my $pattern = $query->sql_pattern;

    my $rs = $self->search(
        [ { description => { -like => $pattern } }, { name => { -like => $pattern } } ],
        { order_by => 'name' } );

    while ( my $e = $rs->next ) {
        my $item = App::Manoc::DB::Search::Result::Row->new(
            match => $e->name,
            row   => $e,
        );
        $result->add_item($item);
    }
}

1;
# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::DB::ResultSet::Rack - ResultSet class for Rack

=head1 VERSION

version 2.99.3

=head1 METHODS

=head2 manoc_search(  $query, $result)

Support for Manoc search feature

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
