package App::Manoc::Controller::Auth;
#ABSTRACT: Auth Catalyst Controller

use Moose;

our $VERSION = '2.99.3'; ##TRIAL VERSION

use namespace::autoclean;
use App::Manoc::Form::Login;

BEGIN { extends 'Catalyst::Controller'; }


sub index : Path : Args(0) {
    my ( $self, $c ) = @_;
    $c->response->redirect( $c->uri_for('/auth/login') );
    $c->detach();
}


sub login : Local : CaptureArgs(0) {
    my ( $self, $c ) = @_;

    my $login_redirect = $c->req->params()->{login_redirect};
    my $redirect =
        $login_redirect ? $c->req->base . $login_redirect :
        $c->uri_for('/search');

    my $form = App::Manoc::Form::Login->new( ctx => $c );
    my $success = $form->process(
        posted => ( $c->req->method eq 'POST' ),
        params => $c->req->params
    );

    if ($success) {
        my $username = $c->user->username;
        $c->log->info( 'User ' . $username . ' logged' );
        $c->response->redirect($redirect);
    }

    $c->stash(
        form     => $form,
        template => 'auth/login.tt',
    );
}


sub logout : Local : CaptureArgs(0) {
    my ( $self, $c ) = @_;
    $c->logout();
    $c->delete_session();
    $c->response->redirect( $c->uri_for('/auth/login') );
}

__PACKAGE__->meta->make_immutable;

1;

__END__

=pod

=head1 NAME

App::Manoc::Controller::Auth - Auth Catalyst Controller

=head1 VERSION

version 2.99.3

=head1 ACTIONS

=head2 index

=head2 login

=head2 logout

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
