/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.string;

import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.string.LiteralStringExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class SimpleStringExpression
extends LiteralStringExpression {
    private final String value;

    public static String stripEscapes(String str) {
        String result = str.replaceAll("\\\\\\\\", "\\\\");
        return result.replaceAll("\\\\\\\"", "\\\"");
    }

    public SimpleStringExpression(String value) {
        if (value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        this.value = SimpleStringExpression.stripEscapes(value);
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        return this.getValue();
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }
}

