/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.cde.ui;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.uima.ruta.addons.RutaAddonsPlugin;
import org.apache.uima.ruta.cde.ui.DocumentTableContentProvider;
import org.apache.uima.ruta.cde.ui.DocumentTableLabelProvider;
import org.apache.uima.ruta.cde.utils.CDEComparatorFactory;
import org.apache.uima.ruta.cde.utils.DocumentData;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.part.FileEditorInput;

public class DocumentSelectComposite
extends Composite {
    private Clipboard clipboard;
    private Table table;
    private TableViewer tableViewer;
    private DocumentTableLabelProvider labelProvider;
    private DocumentTableContentProvider contentProvider;
    private ArrayList<DocumentData> documentList;
    private HashMap<String, Image> images;
    private Label directoryLabel;
    private Label typeSystemLabel;
    private Text inputDirectoryText;
    private Label testDataLabel;
    private Text testDirectoryText;
    private Button testDataButton;
    private Button dirButton;
    private Button delButton;
    private Button tsButton;
    private Text tsLocationText;
    private TableColumn tc0;
    private TableColumn tc1;
    private TableColumn tc2;
    private TableColumn tc3;
    private Text measuresText;
    private CDEComparatorFactory compareFactory;

    public DocumentSelectComposite(Composite parent, int style) {
        super(parent, style);
        this.initGui();
        this.clipboard = new Clipboard(parent.getDisplay());
        this.compareFactory = new CDEComparatorFactory();
    }

    public void initGui() {
        this.documentList = new ArrayList();
        this.setLayout((Layout)new FormLayout());
        this.setSize(600, 380);
        this.directoryLabel = new Label((Composite)this, 0);
        FormData label1LData = new FormData();
        label1LData.left = new FormAttachment(0, 10);
        label1LData.top = new FormAttachment(0, 10);
        label1LData.width = 80;
        this.directoryLabel.setLayoutData((Object)label1LData);
        this.directoryLabel.setText("Documents:");
        this.delButton = new Button((Composite)this, 0x1000008);
        FormData delButtonData = new FormData();
        delButtonData.width = 25;
        delButtonData.height = 25;
        delButtonData.top = new FormAttachment((Control)this.directoryLabel, 0, 0x1000000);
        delButtonData.right = new FormAttachment(100, -10);
        this.delButton.setLayoutData((Object)delButtonData);
        Image folderIcon = this.getImage("delete");
        this.delButton.setImage(folderIcon);
        this.delButton.setToolTipText("Remove selected documents");
        this.delButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int[] indices = DocumentSelectComposite.this.table.getSelectionIndices();
                for (int i = indices.length - 1; i >= 0; --i) {
                    DocumentSelectComposite.this.documentList.remove(indices[i]);
                }
                DocumentSelectComposite.this.tableViewer.setInput(DocumentSelectComposite.this.documentList);
                DocumentSelectComposite.this.tableViewer.refresh();
            }
        });
        this.dirButton = new Button((Composite)this, 0x1000008);
        FormData dirButtonData = new FormData();
        dirButtonData.width = 25;
        dirButtonData.height = 25;
        dirButtonData.top = new FormAttachment((Control)this.directoryLabel, 0, 0x1000000);
        dirButtonData.right = new FormAttachment((Control)this.delButton, -10);
        this.dirButton.setLayoutData((Object)dirButtonData);
        folderIcon = this.getImage("folder");
        this.dirButton.setImage(folderIcon);
        this.dirButton.setToolTipText("Select document Folder");
        this.dirButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg = new DirectoryDialog(DocumentSelectComposite.this.getShell());
                dlg.setFilterPath(DocumentSelectComposite.this.inputDirectoryText.getText());
                dlg.setText("Input Directory");
                dlg.setMessage("Select a directory with input document files.");
                String dir = dlg.open();
                if (dir != null) {
                    String[] files;
                    DocumentSelectComposite.this.documentList = new ArrayList();
                    File directory = new File(dir);
                    for (String filePath : files = directory.list()) {
                        DocumentData documentData = new DocumentData(new File(directory + System.getProperty("file.separator") + filePath));
                        DocumentSelectComposite.this.documentList.add(documentData);
                    }
                    DocumentSelectComposite.this.inputDirectoryText.setText(dir);
                    DocumentSelectComposite.this.tableViewer.setInput(DocumentSelectComposite.this.documentList);
                    DocumentSelectComposite.this.tableViewer.refresh();
                }
            }
        });
        this.inputDirectoryText = new Text((Composite)this, 2052);
        FormData inputDirectoryTextData = new FormData();
        inputDirectoryTextData.left = new FormAttachment((Control)this.directoryLabel, 10);
        inputDirectoryTextData.top = new FormAttachment((Control)this.directoryLabel, 0, 0x1000000);
        inputDirectoryTextData.right = new FormAttachment((Control)this.dirButton, -12);
        this.inputDirectoryText.setLayoutData((Object)inputDirectoryTextData);
        this.inputDirectoryText.setText("");
        this.inputDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                t.getText();
            }
        });
        this.testDataLabel = new Label((Composite)this, 0);
        FormData testDataLabelData = new FormData();
        testDataLabelData.left = new FormAttachment(0, 10);
        testDataLabelData.top = new FormAttachment((Control)this.directoryLabel, 15);
        this.testDataLabel.setLayoutData((Object)testDataLabelData);
        this.testDataLabel.setText("Test Data:");
        this.testDataButton = new Button((Composite)this, 0x1000008);
        FormData testDataButtonData = new FormData();
        testDataButtonData.width = 25;
        testDataButtonData.height = 25;
        testDataButtonData.top = new FormAttachment((Control)this.testDataLabel, 0, 0x1000000);
        testDataButtonData.right = new FormAttachment(100, -10);
        this.testDataButton.setLayoutData((Object)testDataButtonData);
        folderIcon = this.getImage("folder");
        this.testDataButton.setImage(folderIcon);
        this.testDataButton.setToolTipText("Select the folder containing the test files");
        this.testDataButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dlg2 = new DirectoryDialog(DocumentSelectComposite.this.getShell());
                dlg2.setFilterPath(DocumentSelectComposite.this.testDirectoryText.getText());
                dlg2.setText("Location of the test files");
                String dir = dlg2.open();
                if (dir != null) {
                    DocumentSelectComposite.this.testDirectoryText.setText(dir);
                }
            }
        });
        this.testDirectoryText = new Text((Composite)this, 2052);
        FormData testDirectoryTextData = new FormData();
        testDirectoryTextData.top = new FormAttachment((Control)this.testDataLabel, 0, 0x1000000);
        testDirectoryTextData.left = new FormAttachment((Control)this.directoryLabel, 10);
        testDirectoryTextData.right = new FormAttachment((Control)this.testDataButton, -10);
        this.testDirectoryText.setLayoutData((Object)testDirectoryTextData);
        this.testDirectoryText.setText("");
        this.testDirectoryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                t.getText();
            }
        });
        this.typeSystemLabel = new Label((Composite)this, 0);
        FormData tSLabelData = new FormData();
        tSLabelData.left = new FormAttachment(0, 10);
        tSLabelData.top = new FormAttachment((Control)this.testDataLabel, 15);
        tSLabelData.width = 80;
        this.typeSystemLabel.setLayoutData((Object)tSLabelData);
        this.typeSystemLabel.setText("Type System:");
        this.tsButton = new Button((Composite)this, 0x1000008);
        FormData tsButtonData = new FormData();
        tsButtonData.width = 25;
        tsButtonData.height = 25;
        tsButtonData.top = new FormAttachment((Control)this.typeSystemLabel, 0, 0x1000000);
        tsButtonData.right = new FormAttachment(100, -10);
        this.tsButton.setLayoutData((Object)tsButtonData);
        folderIcon = this.getImage("folder");
        this.tsButton.setImage(folderIcon);
        this.tsButton.setToolTipText("Select the Type System");
        this.tsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dlg = new FileDialog(DocumentSelectComposite.this.getShell());
                dlg.setFilterPath(DocumentSelectComposite.this.tsLocationText.getText());
                dlg.setText("Type System Location");
                String dir = dlg.open();
                if (dir != null) {
                    DocumentSelectComposite.this.tsLocationText.setText(dir);
                }
            }
        });
        this.tsLocationText = new Text((Composite)this, 2052);
        FormData tsLocationTextData = new FormData();
        tsLocationTextData.left = new FormAttachment((Control)this.typeSystemLabel, 10);
        tsLocationTextData.top = new FormAttachment((Control)this.typeSystemLabel, 0, 0x1000000);
        tsLocationTextData.right = new FormAttachment((Control)this.tsButton, -10);
        this.tsLocationText.setLayoutData((Object)tsLocationTextData);
        this.tsLocationText.setText("");
        this.tsLocationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                t.getText();
            }
        });
        this.measuresText = new Text((Composite)this, 8);
        FormData cNrTextData = new FormData();
        cNrTextData.left = new FormAttachment(0, 10);
        cNrTextData.top = new FormAttachment((Control)this.typeSystemLabel, 15);
        cNrTextData.right = new FormAttachment(100, -10);
        this.measuresText.setLayoutData((Object)cNrTextData);
        this.measuresText.setText("... no measures available yet");
        this.tableViewer = new TableViewer((Composite)this, 68354);
        this.labelProvider = new DocumentTableLabelProvider();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.contentProvider = new DocumentTableContentProvider();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection;
                Object object;
                if (event.getSelection() instanceof IStructuredSelection && (object = (selection = (IStructuredSelection)DocumentSelectComposite.this.tableViewer.getSelection()).getFirstElement()) instanceof DocumentData) {
                    DocumentData data = (DocumentData)object;
                    Path path = new Path(data.getDocument().getAbsolutePath());
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    IFile file = workspace.getRoot().getFileForLocation((IPath)path);
                    if (file == null) {
                        try {
                            IFile extFile;
                            IProject project = workspace.getRoot().getProject("External Files");
                            if (!project.exists()) {
                                project.create(null);
                            }
                            if (!project.isOpen()) {
                                project.open(null);
                            }
                            if ((extFile = project.getFile(path.lastSegment())).exists()) {
                                extFile.delete(true, false, (IProgressMonitor)new NullProgressMonitor());
                            }
                            extFile.createLink((IPath)path, 0, null);
                            file = extFile;
                        }
                        catch (Exception e) {
                            RutaAddonsPlugin.error(e);
                        }
                    }
                    if (file != null) {
                        IWorkbenchPage page = Workbench.getInstance().getActiveWorkbenchWindow().getActivePage();
                        try {
                            page.openEditor((IEditorInput)new FileEditorInput(file), "org.apache.uima.caseditor.editor");
                        }
                        catch (PartInitException e) {
                            RutaAddonsPlugin.error(e);
                        }
                    }
                }
            }
        });
        this.table = this.tableViewer.getTable();
        FormData tableFormData = new FormData();
        tableFormData.top = new FormAttachment((Control)this.measuresText, 15);
        tableFormData.bottom = new FormAttachment(100, 0);
        tableFormData.left = new FormAttachment(0, 0);
        tableFormData.right = new FormAttachment(100, 0);
        this.table.setLayoutData((Object)tableFormData);
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) == 262144 && e.keyCode == 99) {
                    TableItem[] items;
                    Object output = "";
                    for (TableItem item : items = DocumentSelectComposite.this.table.getSelection()) {
                        DocumentData data = (DocumentData)item.getData();
                        output = (String)output + data.getDocument().getName() + ", " + data.getAugmentedResult() + ", " + data.getFMeasure() + ", \n";
                    }
                    DocumentSelectComposite.this.clipboard.setContents(new Object[]{output}, new Transfer[]{TextTransfer.getInstance()});
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        this.tc0 = new TableColumn(this.table, 16384);
        this.tc0.setText("  ");
        this.tc0.setWidth(25);
        this.tc1 = new TableColumn(this.table, 16384);
        this.tc1.setText("Document");
        this.tc1.setWidth(160);
        this.tc1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Comparator comparator = DocumentSelectComposite.this.compareFactory.getComparator(DocumentSelectComposite.this.tc1);
                Collections.sort(DocumentSelectComposite.this.documentList, comparator);
                DocumentSelectComposite.this.tableViewer.setInput(DocumentSelectComposite.this.documentList);
                DocumentSelectComposite.this.tableViewer.refresh();
            }
        });
        this.tc2 = new TableColumn(this.table, 131072);
        this.tc2.setText("CDE");
        this.tc2.setWidth(45);
        this.tc2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Comparator comparator = DocumentSelectComposite.this.compareFactory.getComparator(DocumentSelectComposite.this.tc2);
                Collections.sort(DocumentSelectComposite.this.documentList, comparator);
                DocumentSelectComposite.this.tableViewer.setInput(DocumentSelectComposite.this.documentList);
                DocumentSelectComposite.this.tableViewer.refresh();
            }
        });
        this.tc3 = new TableColumn(this.table, 131072);
        this.tc3.setText("F1");
        this.tc3.setWidth(45);
        this.tc3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Comparator comparator = DocumentSelectComposite.this.compareFactory.getComparator(DocumentSelectComposite.this.tc3);
                Collections.sort(DocumentSelectComposite.this.documentList, comparator);
                DocumentSelectComposite.this.tableViewer.setInput(DocumentSelectComposite.this.documentList);
                DocumentSelectComposite.this.tableViewer.refresh();
            }
        });
        DropTarget dt = new DropTarget((Control)this.table, 18);
        dt.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList != null && fileList.length > 0) {
                    for (int i = 0; i < fileList.length; ++i) {
                        File file = new File(fileList[i]);
                        if (file.isDirectory()) continue;
                        DocumentData newDocument = new DocumentData(file);
                        DocumentSelectComposite.this.documentList.add(newDocument);
                        DocumentSelectComposite.this.tableViewer.setInput(DocumentSelectComposite.this.documentList);
                        DocumentSelectComposite.this.tableViewer.refresh();
                    }
                }
            }
        });
        DropTarget dt2 = new DropTarget((Control)this.inputDirectoryText, 18);
        dt2.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt2.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList != null && fileList.length == 1) {
                    String string = fileList[0];
                    DocumentSelectComposite.this.inputDirectoryText.setText(string);
                    DocumentSelectComposite.this.setDocumentsByDir();
                }
            }
        });
        DropTarget dt3 = new DropTarget((Control)this.testDirectoryText, 18);
        dt3.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt3.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList != null && fileList.length == 1) {
                    String string = fileList[0];
                    DocumentSelectComposite.this.testDirectoryText.setText(string);
                }
            }
        });
        DropTarget dt4 = new DropTarget((Control)this.tsLocationText, 18);
        dt4.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        dt4.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                String string;
                File file;
                String[] fileList = null;
                FileTransfer ft = FileTransfer.getInstance();
                if (ft.isSupportedType(event.currentDataType)) {
                    fileList = (String[])event.data;
                }
                if (fileList != null && fileList.length == 1 && (file = new File(string = fileList[0])).isFile()) {
                    if (file.getName().endsWith(".ruta")) {
                        String typeSystemDescriptorLocation = "";
                        try {
                            typeSystemDescriptorLocation = RutaProjectUtils.getTypeSystemDescriptorPath((String)string).toPortableString();
                        }
                        catch (CoreException e) {
                            RutaAddonsPlugin.error(e);
                        }
                        DocumentSelectComposite.this.tsLocationText.setText(typeSystemDescriptorLocation);
                    } else if (file.getName().endsWith(".xml")) {
                        DocumentSelectComposite.this.tsLocationText.setText(string);
                    }
                }
            }
        });
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer.refresh();
        this.layout();
    }

    private void initImages() {
        this.images = new HashMap();
        ImageDescriptor desc = RutaAddonsPlugin.getImageDescriptor("/icons/delete.png");
        Image image = desc.createImage();
        String name = "delete";
        this.images.put(name, image);
        desc = RutaAddonsPlugin.getImageDescriptor("/icons/folder.png");
        image = desc.createImage();
        name = "folder";
        this.images.put(name, image);
    }

    public Image getImage(String name) {
        if (this.images == null) {
            this.initImages();
        }
        return this.images.get(name);
    }

    public void updateViewer(String documentPath) {
        File folder = new File(documentPath);
        File[] documents = folder.listFiles();
        this.tableViewer.setInput((Object)documents);
    }

    public TableViewer getViewer() {
        return this.tableViewer;
    }

    public ArrayList<DocumentData> getDocumentList() {
        return this.documentList;
    }

    public File getTypeSystem() {
        return new File(this.tsLocationText.getText());
    }

    public void saveState(IMemento memento) {
        memento.createChild("inputDirectory", this.inputDirectoryText.getText());
        memento.createChild("testDirectory", this.testDirectoryText.getText());
        memento.createChild("tsLocation", this.tsLocationText.getText());
        memento.createChild("documents");
        for (DocumentData documentData : this.documentList) {
            String docPath = documentData.getDocument().getAbsolutePath();
            String docName = "document";
            IMemento documentMemento = memento.getChild("documents");
            documentMemento.createChild(docName, docPath);
        }
    }

    public void restoreState(IMemento memento) {
        IMemento documents;
        IMemento tsLocation;
        IMemento testDirectory;
        if (memento == null) {
            return;
        }
        IMemento inputDirectory = memento.getChild("inputDirectory");
        if (inputDirectory != null) {
            this.inputDirectoryText.setText(inputDirectory.getID());
        }
        if ((testDirectory = memento.getChild("testDirectory")) != null) {
            this.testDirectoryText.setText(testDirectory.getID());
        }
        if ((tsLocation = memento.getChild("tsLocation")) != null) {
            this.tsLocationText.setText(tsLocation.getID());
        }
        if ((documents = memento.getChild("documents")) != null) {
            for (IMemento document : documents.getChildren("document")) {
                DocumentData docData = new DocumentData(new File(document.getID()));
                this.documentList.add(docData);
            }
            this.tableViewer.setInput(this.documentList);
            this.tableViewer.refresh();
        }
    }

    public String getTestDataPath() {
        return this.testDirectoryText.getText();
    }

    public String getDocumentFolderPath() {
        return this.inputDirectoryText.getText();
    }

    public void updateMeasureReport(String measureReport) {
        this.measuresText.setText(measureReport);
        this.measuresText.redraw();
    }

    public void setDocumentsByDir(File dir) {
        this.documentList = new ArrayList();
        Iterator iterateFiles = FileUtils.iterateFiles((File)dir, (String[])new String[]{"xmi"}, (boolean)true);
        while (iterateFiles.hasNext()) {
            File file = (File)iterateFiles.next();
            DocumentData documentData = new DocumentData(file);
            this.documentList.add(documentData);
        }
        this.tableViewer.setInput(this.documentList);
        this.tableViewer.refresh();
    }

    public void setDocumentsByDir() {
        File file = new File(this.inputDirectoryText.getText());
        this.setDocumentsByDir(file);
    }
}

