/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.yaafi.interceptor.javasimon;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.Reconfigurable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.fulcrum.yaafi.framework.interceptor.AvalonInterceptorContext;
import org.apache.fulcrum.yaafi.framework.reflection.Clazz;
import org.apache.fulcrum.yaafi.interceptor.baseservice.BaseInterceptorServiceImpl;
import org.apache.fulcrum.yaafi.interceptor.javasimon.JavaSimonInterceptorService;
import org.apache.fulcrum.yaafi.interceptor.javasimon.JavaSimonPerformanceMonitor;

public class JavaSimonInterceptorServiceImpl
extends BaseInterceptorServiceImpl
implements JavaSimonInterceptorService,
Reconfigurable,
ThreadSafe,
Disposable,
Initializable {
    private boolean isJavaSimonAvailable;
    private File reportFile;
    private long reportTimeout;
    private boolean reportOnExit;
    private long nextReportTimestamp;
    private String performanceMonitorClassName;
    private Class<?> performanceMonitorClass;
    private static final String MONITORFACTORY_CLASSNAME = "org.javasimon.SimonManager";
    private static final String DEFAULT_PERFORMANCEMONITOR_CLASSNAME = "org.apache.fulcrum.yaafi.interceptor.javasimon.JavaSimon4PerformanceMonitorImpl";

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.reportTimeout = configuration.getChild("reportTimeout").getValueAsLong(0L);
        this.performanceMonitorClassName = configuration.getChild("performanceMonitorClassName").getValue(DEFAULT_PERFORMANCEMONITOR_CLASSNAME);
        String reportFileName = configuration.getChild("reportFile").getValue("./javasimon.html");
        this.reportFile = this.makeAbsoluteFile(reportFileName);
        this.nextReportTimestamp = System.currentTimeMillis() + this.reportTimeout;
        this.reportOnExit = configuration.getChild("reportOnExit").getValueAsBoolean(false);
    }

    public void initialize() throws Exception {
        ClassLoader classLoader = this.getClassLoader();
        if (!Clazz.hasClazz(classLoader, MONITORFACTORY_CLASSNAME)) {
            String msg = "The JavaSimonInterceptorService is disabled since the JavaSimon classes are not found in the classpath";
            this.getLogger().warn(msg);
            this.isJavaSimonAvailable = false;
            return;
        }
        if (!Clazz.hasClazz(classLoader, this.performanceMonitorClassName)) {
            String msg = "The JavaSimonInterceptorService is disabled since the performance monitor class is not found in the classpath";
            this.getLogger().warn(msg);
            this.isJavaSimonAvailable = false;
            return;
        }
        this.performanceMonitorClass = Clazz.getClazz(this.getClassLoader(), this.performanceMonitorClassName);
        JavaSimonPerformanceMonitor testMonitor = this.createJavaSimonPerformanceMonitor(null, null, true);
        if (testMonitor == null) {
            String msg = "The JavaSimonInterceptorService is disabled since the performance monitor can't be instantiated";
            this.getLogger().warn(msg);
            this.isJavaSimonAvailable = false;
            return;
        }
        this.getLogger().debug("The JavaSimonInterceptorService is enabled");
        this.isJavaSimonAvailable = true;
    }

    @Override
    public void reconfigure(Configuration configuration) throws ConfigurationException {
        super.reconfigure(configuration);
        this.configure(configuration);
    }

    public void dispose() {
        if (this.reportOnExit) {
            this.run();
        }
        this.reportFile = null;
    }

    @Override
    public void onEntry(AvalonInterceptorContext interceptorContext) {
        if (this.isJavaSimonAvailable()) {
            this.writeReport();
            String serviceShortHand = interceptorContext.getServiceShorthand();
            Method serviceMethod = interceptorContext.getMethod();
            boolean isEnabled = this.isServiceMonitored(interceptorContext);
            JavaSimonPerformanceMonitor monitor = this.createJavaSimonPerformanceMonitor(serviceShortHand, serviceMethod, isEnabled);
            monitor.start();
            interceptorContext.getRequestContext().put(this.getServiceName(), monitor);
        }
    }

    @Override
    public void onExit(AvalonInterceptorContext interceptorContext, Object result) {
        if (this.isJavaSimonAvailable()) {
            JavaSimonPerformanceMonitor monitor = (JavaSimonPerformanceMonitor)interceptorContext.getRequestContext().remove(this.getServiceName());
            monitor.stop();
        }
    }

    @Override
    public void onError(AvalonInterceptorContext interceptorContext, Throwable t) {
        if (this.isJavaSimonAvailable()) {
            JavaSimonPerformanceMonitor monitor = (JavaSimonPerformanceMonitor)interceptorContext.getRequestContext().remove(this.getServiceName());
            monitor.stop(t);
        }
    }

    @Override
    public void run() {
        this.writeReport(this.reportFile);
    }

    protected final boolean isJavaSimonAvailable() {
        return this.isJavaSimonAvailable;
    }

    protected JavaSimonPerformanceMonitor createJavaSimonPerformanceMonitor(String serviceName, Method method, boolean isEnabled) {
        JavaSimonPerformanceMonitor result = null;
        try {
            Class[] signature = new Class[]{String.class, Method.class, Boolean.class};
            Object[] args = new Object[]{serviceName, method, isEnabled ? Boolean.TRUE : Boolean.FALSE};
            result = (JavaSimonPerformanceMonitor)Clazz.newInstance(this.performanceMonitorClass, signature, args);
        }
        catch (Exception e) {
            String msg = "Failed to create a performance monitor instance : " + this.performanceMonitorClassName;
            this.getLogger().error(msg, (Throwable)e);
        }
        return result;
    }

    protected void writeReport() {
        long currTimestamp;
        if (this.reportTimeout > 0L && (currTimestamp = System.currentTimeMillis()) > this.nextReportTimestamp) {
            this.nextReportTimestamp = currTimestamp + this.reportTimeout;
            this.writeReport(this.reportFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeReport(File reportFile) {
        PrintWriter printWriter = null;
        if (this.isJavaSimonAvailable()) {
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Writing JavaSimon report to " + reportFile.getAbsolutePath());
                }
                OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), "UTF-8");
                printWriter = new PrintWriter(w);
                String report = "Not implemented yet ...";
                printWriter.write(report);
                printWriter.close();
            }
            catch (Throwable t) {
                String msg = "Generating the JavaSimon report failed for " + reportFile.getAbsolutePath();
                this.getLogger().error(msg, t);
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
    }
}

