/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import nl.basjes.parse.useragent.analyze.InvalidParserConfigurationException;
import nl.basjes.parse.useragent.config.MatcherConfig;
import nl.basjes.parse.useragent.config.TestCase;

public final class AnalyzerConfig
implements Serializable {
    private Set<String> wantedFieldNames = null;
    private final Map<String, MatcherConfig> matcherConfigs = new LinkedHashMap<String, MatcherConfig>();
    private final Map<String, Map<String, String>> lookups = new LinkedHashMap<String, Map<String, String>>(128);
    private final Map<String, Set<String>> lookupSets = new LinkedHashMap<String, Set<String>>(128);
    private int userAgentMaxLength = -1;
    private final List<TestCase> testCases = new ArrayList<TestCase>(8192);

    private AnalyzerConfig() {
    }

    public static AnalyzerConfigBuilder newBuilder() {
        return new AnalyzerConfigBuilder();
    }

    public void merge(AnalyzerConfig additionalConfig) {
        this.testCases.addAll(additionalConfig.testCases);
        this.lookups.putAll(additionalConfig.lookups);
        this.lookupSets.putAll(additionalConfig.lookupSets);
        this.matcherConfigs.putAll(additionalConfig.matcherConfigs);
        if (additionalConfig.userAgentMaxLength >= 0) {
            this.userAgentMaxLength = Math.min(this.userAgentMaxLength, additionalConfig.userAgentMaxLength);
        }
        if (additionalConfig.wantedFieldNames == null) {
            this.wantedFieldNames = null;
        } else if (this.wantedFieldNames == null) {
            this.wantedFieldNames = new TreeSet<String>(additionalConfig.wantedFieldNames);
        } else {
            this.wantedFieldNames.addAll(additionalConfig.wantedFieldNames);
        }
    }

    public Set<String> getWantedFieldNames() {
        return this.wantedFieldNames;
    }

    public Map<String, MatcherConfig> getMatcherConfigs() {
        return this.matcherConfigs;
    }

    public Map<String, Map<String, String>> getLookups() {
        return this.lookups;
    }

    public Map<String, Set<String>> getLookupSets() {
        return this.lookupSets;
    }

    public List<TestCase> getTestCases() {
        return this.testCases;
    }

    public int getUserAgentMaxLength() {
        return this.userAgentMaxLength;
    }

    public AnalyzerConfig setUserAgentMaxLength(int newUserAgentMaxLength) {
        this.userAgentMaxLength = newUserAgentMaxLength < 0 ? 2048 : newUserAgentMaxLength;
        return this;
    }

    public AnalyzerConfig wantedFieldNames(Set<String> newWantedFieldNames) {
        this.wantedFieldNames = newWantedFieldNames == null || newWantedFieldNames.isEmpty() ? null : new TreeSet<String>(newWantedFieldNames);
        return this;
    }

    public String toString() {
        return "AnalyzerConfig {\n   matcherConfigs=" + this.matcherConfigs + ",\n   lookups=" + this.lookups.size() + ",\n   lookupSets=" + this.lookupSets.size() + ",\n   testCases=" + this.testCases.size() + ",\n   userAgentMaxLength=" + this.userAgentMaxLength + ",\n\n}";
    }

    public static class AnalyzerConfigBuilder {
        private final Map<String, Set<String>> lookupMerge = new LinkedHashMap<String, Set<String>>(128);
        private final Map<String, Set<String>> lookupSetMerge = new LinkedHashMap<String, Set<String>>(128);
        private final AnalyzerConfig analyzerConfig = new AnalyzerConfig();

        public void addMatcherConfigs(String filename, MatcherConfig matcherConfig) {
            this.analyzerConfig.matcherConfigs.put(filename, matcherConfig);
        }

        public AnalyzerConfigBuilder putLookup(String name, Map<String, String> values) {
            Map existing = (Map)this.analyzerConfig.lookups.get(name);
            if (existing == null) {
                this.analyzerConfig.lookups.put(name, values);
            } else {
                for (Map.Entry<String, String> valueEntry : values.entrySet()) {
                    String existingValue = (String)existing.get(valueEntry.getKey());
                    if (existingValue != null) {
                        if (existingValue.equals(valueEntry.getValue())) continue;
                        throw new InvalidParserConfigurationException("For lookup \"" + name + "\" a multiple different values for the key \"" + valueEntry.getKey() + "\" were found from separate definitions of this lookup.");
                    }
                    existing.put(valueEntry.getKey(), valueEntry.getValue());
                }
            }
            return this;
        }

        public AnalyzerConfigBuilder putLookups(Map<String, Map<String, String>> newLookups) {
            for (Map.Entry<String, Map<String, String>> entry : newLookups.entrySet()) {
                this.putLookup(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public AnalyzerConfigBuilder putLookupMerges(String name, Set<String> lookupNames) {
            this.lookupMerge.put(name, lookupNames);
            return this;
        }

        public AnalyzerConfigBuilder putLookupSets(String name, Set<String> values) {
            Set existing = (Set)this.analyzerConfig.lookupSets.get(name);
            if (existing == null) {
                this.analyzerConfig.lookupSets.put(name, values);
            } else {
                existing.addAll(values);
            }
            return this;
        }

        public AnalyzerConfigBuilder putLookupSets(Map<String, Set<String>> newLookupSets) {
            for (Map.Entry<String, Set<String>> entry : newLookupSets.entrySet()) {
                this.putLookupSets(entry.getKey(), entry.getValue());
            }
            return this;
        }

        public AnalyzerConfigBuilder putLookupSetsMerges(String name, Set<String> setNames) {
            this.lookupSetMerge.put(name, setNames);
            return this;
        }

        public AnalyzerConfigBuilder clearAllTestCases() {
            this.analyzerConfig.testCases.clear();
            return this;
        }

        public AnalyzerConfigBuilder addTestCase(TestCase testCase) {
            this.analyzerConfig.testCases.add(testCase);
            return this;
        }

        public AnalyzerConfigBuilder withUserAgentMaxLength(int userAgentMaxLength) {
            this.analyzerConfig.setUserAgentMaxLength(userAgentMaxLength);
            return this;
        }

        public AnalyzerConfig build() {
            if (!this.analyzerConfig.lookups.isEmpty()) {
                if (!this.lookupMerge.isEmpty()) {
                    this.lookupMerge.forEach((mapName, allExtraToLoad) -> {
                        Map theMap = (Map)this.analyzerConfig.lookups.get(mapName);
                        if (theMap != null) {
                            allExtraToLoad.forEach(extraToLoad -> {
                                if (this.lookupMerge.containsKey(extraToLoad)) {
                                    throw new InvalidParserConfigurationException("Unable to merge lookup '" + extraToLoad + "' into '" + mapName + "' because it is a recursive merge.");
                                }
                                Map extraMap = (Map)this.analyzerConfig.lookups.get(extraToLoad);
                                if (extraMap == null) {
                                    throw new InvalidParserConfigurationException("Unable to merge lookup '" + extraToLoad + "' into '" + mapName + "'.");
                                }
                                theMap.putAll(extraMap);
                            });
                        }
                    });
                }
                LinkedHashMap cleanedLookups = new LinkedHashMap(this.analyzerConfig.lookups.size());
                for (Map.Entry lookupsEntry : this.analyzerConfig.lookups.entrySet()) {
                    LinkedHashMap<String, String> cleanedLookup = new LinkedHashMap<String, String>(((Map)lookupsEntry.getValue()).size());
                    for (Map.Entry entry : ((Map)lookupsEntry.getValue()).entrySet()) {
                        cleanedLookup.put(((String)entry.getKey()).toLowerCase(Locale.ROOT), (String)entry.getValue());
                    }
                    cleanedLookups.put((String)lookupsEntry.getKey(), cleanedLookup);
                }
                this.analyzerConfig.lookups.clear();
                this.analyzerConfig.lookups.putAll(cleanedLookups);
            }
            if (!this.lookupSetMerge.isEmpty()) {
                this.lookupSetMerge.forEach((setName, allExtraToLoad) -> {
                    Set theSet = (Set)this.analyzerConfig.lookupSets.get(setName);
                    if (theSet != null) {
                        allExtraToLoad.forEach(extraToLoad -> {
                            Set extralookupSet;
                            Map extralookup = (Map)this.analyzerConfig.lookups.get(extraToLoad);
                            if (extralookup != null) {
                                theSet.addAll(extralookup.keySet());
                            }
                            if ((extralookupSet = (Set)this.analyzerConfig.lookupSets.get(extraToLoad)) != null) {
                                theSet.addAll(extralookupSet);
                            }
                            if (extralookup == null && extralookupSet == null) {
                                throw new InvalidParserConfigurationException("Unable to merge set '" + extraToLoad + "' into '" + setName + "'.");
                            }
                            if (this.lookupMerge.containsKey(extraToLoad) || this.lookupSetMerge.containsKey(extraToLoad)) {
                                throw new InvalidParserConfigurationException("Unable to merge lookupSET '" + extraToLoad + "' into '" + setName + "' because it is a recursive merge.");
                            }
                        });
                    }
                });
            }
            return this.analyzerConfig;
        }
    }
}

