/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.calculate;

import java.util.Collections;
import java.util.Set;
import nl.basjes.parse.useragent.AgentField;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.utils.Splitter;
import nl.basjes.parse.useragent.utils.VersionSplitter;

public class MajorVersionCalculator
extends FieldCalculator {
    private String versionName;
    private String majorVersionName;
    private static final Splitter VERSION_SPLITTER = new VersionSplitter(){

        @Override
        public boolean isSeparator(char c) {
            switch (c) {
                case ',': 
                case '.': 
                case '|': {
                    return true;
                }
            }
            return false;
        }
    };

    public MajorVersionCalculator(String majorVersionName, String versionName) {
        this.majorVersionName = majorVersionName;
        this.versionName = versionName;
    }

    private MajorVersionCalculator() {
    }

    @Override
    public void calculate(UserAgent.MutableUserAgent userAgent) {
        AgentField.MutableAgentField agentVersionMajor = userAgent.get(this.majorVersionName);
        if (agentVersionMajor.isDefaultValue()) {
            AgentField.MutableAgentField agentVersion = userAgent.get(this.versionName);
            String version = "<<<null>>>";
            if (!agentVersion.isDefaultValue()) {
                version = VERSION_SPLITTER.getSingleSplit(agentVersion.getValue(), 1);
            }
            userAgent.setForced(this.majorVersionName, version, agentVersion.getConfidence());
        }
    }

    @Override
    public String getCalculatedFieldName() {
        return this.majorVersionName;
    }

    @Override
    public Set<String> getDependencies() {
        return Collections.singleton(this.versionName);
    }

    @Override
    public String toString() {
        return "Calculate " + this.versionName + " --> " + this.majorVersionName;
    }
}

