/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.io.File;
import java.util.StringTokenizer;
import java.util.stream.Stream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.turbine.Turbine;

public class ServletUtils {
    public static String expandRelative(ServletConfig config, String text) {
        String expandedText;
        if (StringUtils.isEmpty((CharSequence)text)) {
            return text;
        }
        if (config == null) {
            return null;
        }
        if (Stream.of("/", "./", "\\", ".\\").noneMatch(text::startsWith)) {
            StringBuilder sb = new StringBuilder();
            sb.append("./");
            sb.append(text);
            expandedText = sb.toString();
        } else {
            expandedText = text;
        }
        ServletContext context = config.getServletContext();
        String base = (String)StringUtils.defaultIfEmpty((CharSequence)context.getRealPath("/"), (CharSequence)Turbine.getApplicationRoot());
        if (StringUtils.isEmpty((CharSequence)base)) {
            return expandedText;
        }
        StringTokenizer tokenizer = new StringTokenizer(expandedText, File.pathSeparator);
        StringBuilder buffer = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            buffer.append(base).append(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            buffer.append(File.pathSeparator);
        }
        return buffer.toString();
    }
}

