/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules.actions;

import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.model.turbine.TurbineAccessControlList;
import org.apache.fulcrum.security.util.FulcrumSecurityException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.Action;
import org.apache.turbine.om.security.User;
import org.apache.turbine.pipeline.PipelineData;
import org.apache.turbine.services.security.SecurityService;
import org.apache.turbine.util.RunData;

public class AccessController
implements Action {
    private static final Logger log = LogManager.getLogger(AccessController.class);
    @TurbineService
    private SecurityService security;

    @Override
    public void doPerform(PipelineData pipelineData) throws FulcrumSecurityException {
        RunData data = pipelineData.getRunData();
        Object user = data.getUser();
        if (!this.security.isAnonymousUser((User)user) && user.hasLoggedIn()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> user.getName();
            log.debug("Fetching ACL for {}", supplierArray);
            Object acl = (AccessControlList)data.getSession().getAttribute("turbine.AccessControlList");
            if (acl == null) {
                log.debug("No ACL found in Session, building fresh ACL");
                acl = this.security.getACL((User)user);
                data.getSession().setAttribute("turbine.AccessControlList", acl);
                log.debug("ACL is {}", acl);
            }
            data.setACL(acl);
        }
        pipelineData.get(Turbine.class).put(TurbineAccessControlList.class, data.getACL());
    }
}

