/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.cache.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.fulcrum.cache.CachedObject;
import org.apache.fulcrum.cache.GlobalCacheService;
import org.apache.fulcrum.cache.ObjectExpiredException;
import org.apache.fulcrum.cache.RefreshableCachedObject;

public class DefaultGlobalCacheService
extends AbstractLogEnabled
implements GlobalCacheService,
Runnable,
Configurable,
Initializable,
Disposable,
ThreadSafe {
    public static final int DEFAULT_INITIAL_CACHE_SIZE = 20;
    public static final String INITIAL_CACHE_SIZE = "cacheInitialSize";
    public static final String CACHE_CHECK_FREQUENCY = "cacheCheckFrequency";
    public static final long DEFAULT_CACHE_CHECK_FREQUENCY = 5000L;
    protected transient ConcurrentHashMap<String, CachedObject<?>> cache = null;
    private transient long cacheCheckFrequency;
    private transient int cacheInitialSize;
    private transient Thread houseKeepingThread;
    private transient boolean continueThread;

    public long getCacheCheckFrequency() {
        return this.cacheCheckFrequency;
    }

    @Override
    public <T> CachedObject<T> getObject(String objectId) throws ObjectExpiredException {
        RefreshableCachedObject refreshableCachedObj;
        CachedObject<?> cachedObject = this.cache.get(objectId);
        if (cachedObject == null) {
            throw new ObjectExpiredException();
        }
        if (cachedObject.isStale()) {
            if (cachedObject instanceof RefreshableCachedObject) {
                refreshableCachedObj = (RefreshableCachedObject)cachedObject;
                if (refreshableCachedObj.isUntouched()) {
                    throw new ObjectExpiredException();
                }
                refreshableCachedObj.refresh();
                if (refreshableCachedObj.isStale()) {
                    throw new ObjectExpiredException();
                }
            } else {
                throw new ObjectExpiredException();
            }
        }
        if (cachedObject instanceof RefreshableCachedObject) {
            refreshableCachedObj = (RefreshableCachedObject)cachedObject;
            refreshableCachedObj.touch();
        }
        return cachedObject;
    }

    @Override
    public <T> void addObject(String objectId, CachedObject<T> object) {
        if (this.cache.containsKey(objectId)) {
            this.cache.remove(objectId);
        }
        this.cache.put(objectId, object);
    }

    @Override
    public void removeObject(String objectId) {
        this.cache.remove(objectId);
    }

    @Override
    public List<String> getKeys() {
        ArrayList<String> keys = new ArrayList<String>(this.cache.size());
        for (String key : this.cache.keySet()) {
            try {
                this.getObject(key);
            }
            catch (ObjectExpiredException oee) {
                continue;
            }
            keys.add(key);
        }
        return keys;
    }

    @Override
    public List<CachedObject<?>> getCachedObjects() {
        ArrayList objects = new ArrayList(this.cache.size());
        for (String key : this.cache.keySet()) {
            CachedObject cachedObject = null;
            try {
                cachedObject = this.getObject(key);
                if (cachedObject == null) continue;
                objects.add(cachedObject);
            }
            catch (ObjectExpiredException oee) {}
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.continueThread) {
            DefaultGlobalCacheService defaultGlobalCacheService = this;
            synchronized (defaultGlobalCacheService) {
                try {
                    this.wait(this.cacheCheckFrequency);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.clearCache();
        }
    }

    public void clearCache() {
        CachedObject<?> cachedObject;
        ArrayList<String> refreshThese = new ArrayList<String>(20);
        for (String key : this.cache.keySet()) {
            cachedObject = this.cache.get(key);
            if (cachedObject instanceof RefreshableCachedObject) {
                RefreshableCachedObject refreshableObject = (RefreshableCachedObject)cachedObject;
                if (refreshableObject.isUntouched()) {
                    this.cache.remove(key);
                    continue;
                }
                if (!refreshableObject.isStale()) continue;
                refreshThese.add(key);
                continue;
            }
            if (!cachedObject.isStale()) continue;
            this.cache.remove(key);
        }
        for (String key : refreshThese) {
            cachedObject = this.cache.get(key);
            RefreshableCachedObject refreshableCachedObject = (RefreshableCachedObject)cachedObject;
            refreshableCachedObject.refresh();
        }
    }

    @Override
    public int getNumberOfObjects() {
        return this.cache.size();
    }

    @Override
    public int getCacheSize() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(this.cache);
        out.flush();
        return baos.toByteArray().length - 4;
    }

    @Override
    public void flushCache() {
        this.cache.clear();
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.cacheCheckFrequency = conf.getAttributeAsLong(CACHE_CHECK_FREQUENCY, 5000L);
        this.cacheInitialSize = conf.getAttributeAsInteger(INITIAL_CACHE_SIZE, 20);
    }

    public void initialize() throws Exception {
        this.cache = new ConcurrentHashMap(this.cacheInitialSize);
        this.continueThread = true;
        this.houseKeepingThread = new Thread(this);
        this.houseKeepingThread.setDaemon(true);
        this.houseKeepingThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DefaultGlobalCacheService defaultGlobalCacheService = this;
        synchronized (defaultGlobalCacheService) {
            this.continueThread = false;
            this.notifyAll();
        }
    }
}

