package org.apache.turbine.services.schedule;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.ResultSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.Column;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.TorqueRuntimeException;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.TableMap;
import org.apache.torque.map.ColumnMap;
import org.apache.torque.map.ForeignKeyMap;
import org.apache.torque.map.InheritanceMap;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.om.mapper.CompositeMapper;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;



/**
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Tue May 28 10:27:12 CEST 2019]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to JobEntryTorquePeer
 */

public abstract class BaseJobEntryTorquePeer
{
    /** The class log. */
    private static Log log = LogFactory.getLog(BaseJobEntryTorquePeerImpl.class);
    /** The default database name for this class. */
    public static final String DATABASE_NAME;

     /** The table name for this class. */
    public static final String TABLE_NAME;

     /** The table map for this class. */
    public static final TableMap TABLE;
    /** The column for the JOB_ID field */
    public static final ColumnMap JOB_ID;
    /** The column for the SECOND field */
    public static final ColumnMap SECOND;
    /** The column for the MINUTE field */
    public static final ColumnMap MINUTE;
    /** The column for the HOUR field */
    public static final ColumnMap HOUR;
    /** The column for the WEEK_DAY field */
    public static final ColumnMap WEEK_DAY;
    /** The column for the DAY_OF_MONTH field */
    public static final ColumnMap DAY_OF_MONTH;
    /** The column for the TASK field */
    public static final ColumnMap TASK;
    /** The column for the EMAIL field */
    public static final ColumnMap EMAIL;
    /** The column for the PROPERTY field */
    public static final ColumnMap PROPERTY;

    /** number of columns for this peer */
    public static final int numColumns = 9;


    /** The implementation of the peer. */
    private static JobEntryTorquePeerImpl jobEntryTorquePeerImpl;


    static
    {
        DatabaseMap dbMap = Torque.getOrCreateDatabase("default")
                .getDatabaseMap();
        if (dbMap.getTable("TURBINE_SCHEDULED_JOB") == null)
        {
            dbMap.addTable("TURBINE_SCHEDULED_JOB");
        }
        DATABASE_NAME = "default";
        TABLE_NAME = "TURBINE_SCHEDULED_JOB";

        TABLE = dbMap.getTable("TURBINE_SCHEDULED_JOB");
        TABLE.setJavaName("JobEntryTorque");
        TABLE.setOMClass(org.apache.turbine.services.schedule.JobEntryTorque.class);
        TABLE.setPeerClass(org.apache.turbine.services.schedule.JobEntryTorquePeer.class);
        TABLE.setPrimaryKeyMethod(IDMethod.ID_BROKER);
        TABLE.setPrimaryKeyMethodInfo(IDMethod.ID_BROKER, TABLE.getName());
        TABLE.setPrimaryKeyMethodInfo(IDMethod.SEQUENCE, "$sequenceName");
        TABLE.setPrimaryKeyMethodInfo(IDMethod.AUTO_INCREMENT, "TURBINE_SCHEDULED_JOB");
        TABLE.setUseInheritance(true);


    // ------------- Column: JOB_ID --------------------
        JOB_ID = new ColumnMap("JOB_ID", TABLE);
        JOB_ID.setType(Integer.valueOf(0));
        JOB_ID.setTorqueType("INTEGER");
        JOB_ID.setUsePrimitive(true);
        JOB_ID.setPrimaryKey(true);
        JOB_ID.setNotNull(true);
        JOB_ID.setJavaName("JobId");
        JOB_ID.setAutoIncrement(true);
        JOB_ID.setProtected(false);
        JOB_ID.setJavaType( "int" );
        JOB_ID.setPosition(1);
        TABLE.addColumn(JOB_ID);
    // ------------- Column: SECOND --------------------
        SECOND = new ColumnMap("SECOND", TABLE);
        SECOND.setType(Integer.valueOf(0));
        SECOND.setTorqueType("INTEGER");
        SECOND.setUsePrimitive(true);
        SECOND.setPrimaryKey(false);
        SECOND.setNotNull(true);
        SECOND.setJavaName("Second");
        SECOND.setAutoIncrement(true);
        SECOND.setProtected(false);
        SECOND.setJavaType( "int" );
        SECOND.setDefault("-1");
        SECOND.setPosition(2);
        TABLE.addColumn(SECOND);
    // ------------- Column: MINUTE --------------------
        MINUTE = new ColumnMap("MINUTE", TABLE);
        MINUTE.setType(Integer.valueOf(0));
        MINUTE.setTorqueType("INTEGER");
        MINUTE.setUsePrimitive(true);
        MINUTE.setPrimaryKey(false);
        MINUTE.setNotNull(true);
        MINUTE.setJavaName("Minute");
        MINUTE.setAutoIncrement(true);
        MINUTE.setProtected(false);
        MINUTE.setJavaType( "int" );
        MINUTE.setDefault("-1");
        MINUTE.setPosition(3);
        TABLE.addColumn(MINUTE);
    // ------------- Column: HOUR --------------------
        HOUR = new ColumnMap("HOUR", TABLE);
        HOUR.setType(Integer.valueOf(0));
        HOUR.setTorqueType("INTEGER");
        HOUR.setUsePrimitive(true);
        HOUR.setPrimaryKey(false);
        HOUR.setNotNull(true);
        HOUR.setJavaName("Hour");
        HOUR.setAutoIncrement(true);
        HOUR.setProtected(false);
        HOUR.setJavaType( "int" );
        HOUR.setDefault("-1");
        HOUR.setPosition(4);
        TABLE.addColumn(HOUR);
    // ------------- Column: WEEK_DAY --------------------
        WEEK_DAY = new ColumnMap("WEEK_DAY", TABLE);
        WEEK_DAY.setType(Integer.valueOf(0));
        WEEK_DAY.setTorqueType("INTEGER");
        WEEK_DAY.setUsePrimitive(true);
        WEEK_DAY.setPrimaryKey(false);
        WEEK_DAY.setNotNull(true);
        WEEK_DAY.setJavaName("WeekDay");
        WEEK_DAY.setAutoIncrement(true);
        WEEK_DAY.setProtected(false);
        WEEK_DAY.setJavaType( "int" );
        WEEK_DAY.setDefault("-1");
        WEEK_DAY.setPosition(5);
        TABLE.addColumn(WEEK_DAY);
    // ------------- Column: DAY_OF_MONTH --------------------
        DAY_OF_MONTH = new ColumnMap("DAY_OF_MONTH", TABLE);
        DAY_OF_MONTH.setType(Integer.valueOf(0));
        DAY_OF_MONTH.setTorqueType("INTEGER");
        DAY_OF_MONTH.setUsePrimitive(true);
        DAY_OF_MONTH.setPrimaryKey(false);
        DAY_OF_MONTH.setNotNull(true);
        DAY_OF_MONTH.setJavaName("DayOfMonth");
        DAY_OF_MONTH.setAutoIncrement(true);
        DAY_OF_MONTH.setProtected(false);
        DAY_OF_MONTH.setJavaType( "int" );
        DAY_OF_MONTH.setDefault("-1");
        DAY_OF_MONTH.setPosition(6);
        TABLE.addColumn(DAY_OF_MONTH);
    // ------------- Column: TASK --------------------
        TASK = new ColumnMap("TASK", TABLE);
        TASK.setType("");
        TASK.setTorqueType("VARCHAR");
        TASK.setUsePrimitive(false);
        TASK.setPrimaryKey(false);
        TASK.setNotNull(true);
        TASK.setJavaName("Task");
        TASK.setAutoIncrement(true);
        TASK.setProtected(false);
        TASK.setJavaType( "String" );
        TASK.setSize(99);
        TASK.setPosition(7);
        TABLE.addColumn(TASK);
    // ------------- Column: EMAIL --------------------
        EMAIL = new ColumnMap("EMAIL", TABLE);
        EMAIL.setType("");
        EMAIL.setTorqueType("VARCHAR");
        EMAIL.setUsePrimitive(false);
        EMAIL.setPrimaryKey(false);
        EMAIL.setNotNull(false);
        EMAIL.setJavaName("Email");
        EMAIL.setAutoIncrement(true);
        EMAIL.setProtected(false);
        EMAIL.setJavaType( "String" );
        EMAIL.setSize(99);
        EMAIL.setPosition(8);
        TABLE.addColumn(EMAIL);
    // ------------- Column: PROPERTY --------------------
        PROPERTY = new ColumnMap("PROPERTY", TABLE);
        PROPERTY.setType(new Object());
        PROPERTY.setTorqueType("VARBINARY");
        PROPERTY.setUsePrimitive(false);
        PROPERTY.setPrimaryKey(false);
        PROPERTY.setNotNull(false);
        PROPERTY.setJavaName("Property");
        PROPERTY.setAutoIncrement(true);
        PROPERTY.setProtected(false);
        PROPERTY.setJavaType( "byte[]" );
        PROPERTY.setPosition(9);
        TABLE.addColumn(PROPERTY);



        initDatabaseMap();
    }

    /**
     * Creates a new instance of the  implementation of the peer.
     *
     * @return the new instance.
     */
    protected static JobEntryTorquePeerImpl createJobEntryTorquePeerImpl()
    {
        JobEntryTorquePeerImpl instance = new JobEntryTorquePeerImpl();
        return instance;
    }


    /**
     * Returns an instance of the implementation of the peer.
     * If no instance is currently cached, a new instance is created and cached.
     *
     * @return an instance of the implementation of the peer, not null.
     */
    public static JobEntryTorquePeerImpl getJobEntryTorquePeerImpl()
    {
        JobEntryTorquePeerImpl peerImplInstance = jobEntryTorquePeerImpl;
        if (peerImplInstance == null)
        {
            peerImplInstance = JobEntryTorquePeer.createJobEntryTorquePeerImpl();
            jobEntryTorquePeerImpl = peerImplInstance;
        }
        return peerImplInstance;
    }



    /**
     * Sets the instance of the implementation of the peer.
     *
     * @param an instance of the implementation of the peer, or null
     *        if a new instance should be created automatically.
     */
    public static void setJobEntryTorquePeerImpl(JobEntryTorquePeerImpl peerImplInstance)
    {
        jobEntryTorquePeerImpl = peerImplInstance;
    }


    /**
     * Add all the columns needed to create a new object.
     *
     * @param criteria object containing the columns to add.
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void addSelectColumns(Criteria criteria)
            throws TorqueException
    {
        getJobEntryTorquePeerImpl().addSelectColumns(criteria);
    }

    /**
     * changes the boolean values in the criteria to the appropriate type,
     * whenever a booleanchar or booleanint column is involved.
     * This enables the user to create criteria using Boolean values
     * for booleanchar or booleanint columns.
     *
     * @param criteria the criteria in which the boolean values
     *        should be corrected.
     *
     * @throws TorqueException if the database map for the criteria cannot be 
               obtained.
     */
    public static void correctBooleans(Criteria criteria) throws TorqueException
    {
        getJobEntryTorquePeerImpl().correctBooleans(criteria);
    }

    /**
     * Checks all columns in the criteria to see whether
     * booleanchar and booleanint columns are queried with a boolean.
     * If yes, the query values are mapped onto values the database
     * does understand, i.e. 0 and 1 for booleanints and N and Y for
     * booleanchar columns.
     *
     * @param columnValues The value to be checked for booleanint
     *        and booleanchar columns.
     * @throws TorqueException if the database map for the criteria cannot be
     *         retrieved.
     */
    public static void correctBooleans(
            ColumnValues columnValues)
        throws TorqueException
    {
        getJobEntryTorquePeerImpl().correctBooleans(columnValues);
    }
    
    /**
     * Selects JobEntryTorque objects from a database.
     *
     * @param criteria object used to create the SELECT statement.
     *
     * @return the list of selected objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List<JobEntryTorque> doSelect(Criteria criteria)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doSelect(criteria);
    }

    /**
     * Selects JobEntryTorque objects from a database
     * within a transaction.
     *
     * @param criteria object used to create the SELECT statement.
     * @param connection the connection holding the transaction, not null.
     *
     * @return The list of selected objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List<JobEntryTorque> doSelect(
                Criteria criteria,
                Connection connection)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doSelect(criteria, connection);
    }

    /**
     * Selects rows from a database an maps them to objects.
     *
     * @param criteria A Criteria specifying the records to select, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     *
     * @return The results of the query, not null.
     *
     * @throws TorqueException if querying the database fails.
     */
    public static <T> List<T> doSelect(
                Criteria criteria,
                RecordMapper<T> mapper)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doSelect(criteria, mapper);
    }

    /**
     * Selects rows from a database an maps them to objects.
     *
     * @param criteria A Criteria specifying the records to select, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     * @param connection the database connection for selecting records,
     *        not null.
     *
     * @return The results of the query, not null.
     * @throws TorqueException Error performing database query.
     */
    public static <T> List<T> doSelect(
            Criteria criteria,
            RecordMapper<T> mapper,
            Connection connection)
        throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doSelect(
                criteria,
                mapper,
                connection);
    }

    /**
     * Selects rows from a database an maps them to objects.
     *
     * @param query the sql query to execute, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     * @param dbName The name of the database to create the connection for,
     *        or null for the default SDB.
     *
     * @return The results of the query, not null.
     *
     * @throws TorqueException if querying the database fails.
     */
    public static <T> List<T> doSelect(
                String query,
                RecordMapper<T> mapper,
                String dbName)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doSelect(
                query,
                mapper,
                dbName);
    }

    /**
     * Selects rows from a database an maps them to objects.
     *
     * @param query the SQL Query to execute, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     * @param connection the database connection, not null.
     *
     * @return The results of the query, not null.
     *
     * @throws TorqueException if querying the database fails.
     */
    public static <T> List<T> doSelect(
                String query,
                RecordMapper<T> mapper,
                Connection connection)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doSelect(
                query,
                mapper,
                connection);
    }

    /**
     * Selects JobEntryTorque objects from the database which have
     * the same content as the passed object.
     *
     * @return The list of selected objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List<JobEntryTorque> doSelect(JobEntryTorque obj)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doSelect(obj);
    }

    /**
     * Selects at most one JobEntryTorque object from a database.
     *
     * @param criteria object used to create the SELECT statement.
     *
     * @return the selected Object, or null if no object was selected.
     *
     * @throws TorqueException If more than one record is selected or if
     *         an error occurs when processing the query.
     */
    public static JobEntryTorque doSelectSingleRecord(
                Criteria criteria)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doSelectSingleRecord(criteria);
    }

    /**
     * Selects at most one JobEntryTorque object from a database
     * within a transaction.
     *
     * @param criteria object used to create the SELECT statement.
     * @param connection the connection holding the transaction, not null.
     *
     * @return the selected Object, or null if no object was selected.
     *
     * @throws TorqueException If more than one record is selected or if
     *         an error occurs when processing the query.
     */
    public static JobEntryTorque doSelectSingleRecord(
                Criteria criteria,
                Connection connection)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doSelectSingleRecord(criteria, connection);
    }

    /**
     * Selects at most a single row from a database an maps them to objects.
     *
     * @param criteria A Criteria specifying the records to select, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     *
     * @return The selected row, or null if no records was selected.
     *
     * @throws TorqueException if querying the database fails.
     */
    public static <T> T doSelectSingleRecord(
                org.apache.torque.criteria.Criteria criteria,
                RecordMapper<T> mapper)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doSelectSingleRecord(
                criteria,
                mapper);
    }

    /**
     * Selects at most a single row from a database an maps them to objects.
     *
     * @param criteria A Criteria specifying the records to select, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     * @param connection the database connection, not null.
     *
     * @return The selected row, or null if no records was selected.
     *
     * @throws TorqueException if querying the database fails.
     */
    public static <T> T doSelectSingleRecord(
                org.apache.torque.criteria.Criteria criteria,
                RecordMapper<T> mapper,
                Connection connection)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doSelectSingleRecord(
                criteria,
                mapper,
                connection);
    }

    /**
     * Selects at most one JobEntryTorque object from the database
     * which has the same content as the passed object.
     *
     * @return the selected Object, or null if no object was selected.
     *
     * @throws TorqueException If more than one record is selected or if
     *         an error occurs when processing the query.
     */
    public static JobEntryTorque doSelectSingleRecord(
                JobEntryTorque obj)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doSelectSingleRecord(obj);
    }


    /**
     * Returns a new instance of the Data object class
     */
    public static JobEntryTorque getDbObjectInstance()
    {
        return getJobEntryTorquePeerImpl().getDbObjectInstance();
    }


    /**
     * Method to do inserts.
     *
     * @param columnValues the values to insert.
     *
     * @return the primary key of the inserted row.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static ObjectKey doInsert(ColumnValues columnValues) 
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doInsert(columnValues);
    }

    /**
     * Method to do inserts.  This method is to be used during a transaction,
     * otherwise use the doInsert(Criteria) method.
     *
     * @param columnValues the values to insert.
     * @param con the connection to use, not null.
     *
     * @return the primary key of the inserted row.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static ObjectKey doInsert(ColumnValues columnValues, Connection con)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doInsert(columnValues, con);
    }
    /**
     * Method to do inserts
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doInsert(JobEntryTorque obj)
            throws TorqueException
    {
        getJobEntryTorquePeerImpl().doInsert(obj);
    }

    /**
     * Method to do inserts.  This method is to be used during a transaction,
     * otherwise use the doInsert(JobEntryTorque) method.  It will take
     * care of the connection details internally.
     *
     * @param obj the data object to insert into the database.
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doInsert(JobEntryTorque obj, Connection con)
            throws TorqueException
    {
        getJobEntryTorquePeerImpl().doInsert(obj, con);
    }

    /**
     * Method to do updates.
     *
     * @param columnValues the values to update plus the primary key
     *        identifying the row to update.
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doUpdate(ColumnValues columnValues) throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doUpdate(columnValues);
    }

    /**
     * Method to do updates.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Criteria) method.  It will take care of
     * the connection details internally.
     *
     * @param columnValues the values to update plus the primary key
     *        identifying the row to update.
     * @param con the connection to use, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doUpdate(ColumnValues columnValues, Connection con)
        throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doUpdate(columnValues, con);
    }

    /**
     * Executes an update against the database. The rows to be updated
     * are selected using <code>criteria</code> and updated using the values
     * in <code>updateValues</code>.
     *
     * @param criteria selects which rows of which table should be updated.
     * @param updateValues Which columns to update with which values, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException if updating fails.
     */
    public static int doUpdate(
                Criteria selectCriteria,
                ColumnValues updateValues)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doUpdate(
            selectCriteria,
            updateValues);
    }

    /**
     * Executes an update against the database. The rows to be updated
     * are selected using <code>criteria</code> and updated using the values
     * in <code>updateValues</code>.
     *
     * @param criteria selects which rows of which table should be updated.
     * @param updateValues Which columns to update with which values, not null.
     * @param connection the database connection to use, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException if updating fails.
     */
    public static int doUpdate(
                Criteria criteria,
                ColumnValues updateValues,
                Connection connection)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doUpdate(
            criteria,
             updateValues,
              connection);
    }

    /**
     * Updates an JobEntryTorque in the database.
     * The primary key is used to identify the object to update.
     *
     * @param obj the data object to update in the database.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doUpdate(JobEntryTorque obj) throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doUpdate(obj);
    }

    /**
     * Updates a JobEntryTorque in the database.
     * The primary key is used to identify the object to update.
     * This method is to be used during a transaction,
     * otherwise the doUpdate(JobEntryTorque) method can be used.
     *
     * @param obj the data object to update in the database.
     * @param con the connection to use, not null.
     
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doUpdate(JobEntryTorque obj, Connection con)
        throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doUpdate(obj, con);
    }

    /**
     * Utility method which executes a given sql statement
     * as prepared statement.
     * This method should be used for update, insert, and delete statements.
     * Use executeQuery() for selects.
     *
     * @param statementString A String with the sql statement to execute.
     *
     * @return The number of rows affected.
     *
     * @throws TorqueException if executing the statement fails
     *         or no database connection can be established.
     */
    public static int executeStatement(String statementString) 
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().executeStatement(statementString);
    }

    /**
     * Utility method which executes a given sql statement
     * as prepared statement.
     * This method should be used for update, insert, and delete statements.
     * Use executeQuery() for selects.
     *
     * @param statementString A String with the sql statement to execute.
     * @param replacementValues values to use as placeholders in the query.
     *        or null or empty if no placeholders need to be filled.
     *
     * @return The number of rows affected.
     *
     * @throws TorqueException if executing the statement fails
     *         or no database connection can be established.
     */
    public static int executeStatement(
                String statementString,
                List<JdbcTypedValue> replacementValues)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().executeStatement(
                statementString, 
                replacementValues);
    }

    /**
     * Utility method which executes a given sql statement
     * as prepared statement.
     * This method should be used for update, insert, and delete statements.
     * Use executeQuery() for selects.
     *
     * @param statementString A String with the sql statement to execute.
     * @param dbName The name of the database to execute the statement against,
     *        or null for the default DB.
     * @param replacementValues values to use as placeholders in the query.
     *        or null or empty if no placeholders need to be filled.
     *
     * @return The number of rows affected.
     *
     * @throws TorqueException if executing the statement fails
     *         or no database connection can be established.
     */
    public static int executeStatement(
            String statementString,
            String dbName,
            List<JdbcTypedValue> replacementValues)
        throws TorqueException
    {
        return getJobEntryTorquePeerImpl().executeStatement(
                statementString, 
                dbName,
                replacementValues);
    }

    /**
     * Utility method which executes a given sql statement
     * as prepared statement.
     * This method should be used for update, insert, and delete statements.
     * Use executeQuery() for selects.
     *
     * @param statementString A String with the sql statement to execute.
     * @param con The database connection to use.
     * @param replacementValues values to use as placeholders in the query.
     *        or null or empty if no placeholders need to be filled.
     *
     * @return The number of rows affected.
     *
     * @throws TorqueException if executing the statement fails.
     */
    public static int executeStatement(
            String statementString,
            Connection con,
            List<JdbcTypedValue> replacementValues)
        throws TorqueException
    {
        return getJobEntryTorquePeerImpl().executeStatement(
                statementString, 
                con,
                replacementValues);
    }

    /**
     * Deletes rows from a database table.
     *
     * @param criteria defines the rows to be deleted, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
     public static int doDelete(Criteria criteria) throws TorqueException
     {
        return getJobEntryTorquePeerImpl().doDelete(criteria);
     }

    /**
     * Deletes rows from a table.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
    *
     * @param criteria defines the rows to be deleted, not null.
     * @param con the connection to use, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
     public static int doDelete(Criteria criteria, Connection con)
        throws TorqueException
     {
        return getJobEntryTorquePeerImpl().doDelete(criteria, con);
     }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     *
     * @param obj the data object to delete in the database, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doDelete(JobEntryTorque obj) throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doDelete(obj);
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param obj the data object to delete in the database, not null.
     * @param con the connection to use, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doDelete(JobEntryTorque obj, Connection con)
        throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doDelete(obj, con);
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     *
     * @param objects the datas object to delete in the database, not null,
     *        may not contain null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doDelete(Collection<JobEntryTorque> objects)
            throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doDelete(objects);
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param objects the datas object to delete in the database, not null,
     *        may not contain null.
     * @param con the connection to use for deleting, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doDelete(
            Collection<JobEntryTorque> objects,
            Connection con)
        throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doDelete(objects, con);
    }

    /**
     * Deletes a row in the database.
     *
     * @param pk the ObjectKey that identifies the row to delete.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doDelete(ObjectKey pk) throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doDelete(pk);
    }

    /**
     * Deletes a row in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param pk the ObjectKey that identifies the row to delete.
     * @param con the connection to use for deleting, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doDelete(ObjectKey pk, Connection con)
        throws TorqueException
    {
        return getJobEntryTorquePeerImpl().doDelete(pk, con);
    }

    /** 
     * Build a Criteria object which selects all objects which have a given
     * primary key.
     *
     * @param pk the primary key value to build the criteria from, not null.
     */
    public static Criteria buildCriteria(ObjectKey pk)
    {
        return getJobEntryTorquePeerImpl().buildCriteria(pk);
    }

    /** 
     * Build a Criteria object which selects all objects which primary keys
     * are contained in the passed collection.
     *
     * @param pks the primary key values to build the criteria from, not null,
     *        may not contain null.
     */
    public static Criteria buildCriteria(Collection<ObjectKey> pks)
    {
        return getJobEntryTorquePeerImpl().buildCriteria(pks);
    }

    /** 
     * Build a Criteria object which selects all passed objects using their
     * primary key. Objects which do not yet have a primary key are ignored.
     *
     * @param objects the objects to build the criteria from, not null,
     *        may not contain null.
     */
    public static Criteria buildPkCriteria(
            Collection<JobEntryTorque> objects)
    {
        return getJobEntryTorquePeerImpl().buildPkCriteria(objects);
    }

    /** 
     * Build a Criteria object from the data object for this peer.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public static Criteria buildCriteria(JobEntryTorque obj)
    {
        return getJobEntryTorquePeerImpl().buildCriteria(obj);
    }

    /** 
     * Build a Criteria object from the data object for this peer,
     * skipping all binary columns.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public static Criteria buildSelectCriteria(JobEntryTorque obj)
    {
        return getJobEntryTorquePeerImpl().buildSelectCriteria(obj);
    }

    /** 
     * Returns the contents of the object as ColumnValues object
     *
     * @throws TorqueException if the table map cannot be retrieved
     *         (should not happen).
     */
    public static ColumnValues buildColumnValues(JobEntryTorque jobEntryTorque)
            throws TorqueException
    {
        
        return getJobEntryTorquePeerImpl().buildColumnValues(jobEntryTorque);
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public static JobEntryTorque retrieveByPK(int pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        return getJobEntryTorquePeerImpl().retrieveByPK(pk);
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public static JobEntryTorque retrieveByPK(int pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        return getJobEntryTorquePeerImpl().retrieveByPK(pk, con);
    }
    
    
    

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public static JobEntryTorque retrieveByPK(ObjectKey pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        return getJobEntryTorquePeerImpl().retrieveByPK(pk);
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public static JobEntryTorque retrieveByPK(ObjectKey pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        return getJobEntryTorquePeerImpl().retrieveByPK(pk, con);
    }


    /**
     * Retrieve a multiple objects by pk
     *
     * @param pks List of primary keys
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List<JobEntryTorque> retrieveByPKs(Collection<ObjectKey> pks)
        throws TorqueException
    {
        return getJobEntryTorquePeerImpl().retrieveByPKs(pks);
    }

    /**
     * Retrieve multiple objects by pk
     *
     * @param pks List of primary keys
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List<JobEntryTorque> retrieveByPKs(Collection<ObjectKey> pks, Connection con)
        throws TorqueException
    {
        return getJobEntryTorquePeerImpl().retrieveByPKs(pks,con);
    }





    /**
     * Returns the TableMap related to this peer.
     *
     * @return the table map, not null.
     *
     * @throws TorqueException if the Peer instance does not hold a Table map.
     */
    public static TableMap getTableMap()
        throws TorqueException
    {
        return getJobEntryTorquePeerImpl().getTableMap();
    }

    public static void initDatabaseMap()
    {
    }


}
