/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.schedule;

import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.turbine.services.schedule.JobEntry;
import org.apache.turbine.util.TurbineException;

public abstract class AbstractJobEntry
implements JobEntry {
    protected static final Logger log = LogManager.getLogger((String)"scheduler");
    private boolean jobIsActive = false;
    private long runtime = 0L;

    public AbstractJobEntry() {
    }

    public AbstractJobEntry(int sec, int min, int hour, int wd, int day_mo, String task) throws TurbineException {
        this();
        if (StringUtils.isEmpty((CharSequence)task)) {
            throw new TurbineException("Error in JobEntry. Bad Job parameter. Task not set.");
        }
        this.setSecond(sec);
        this.setMinute(min);
        this.setHour(hour);
        this.setWeekDay(wd);
        this.setDayOfMonth(day_mo);
        this.setTask(task);
        this.calcRunTime();
    }

    @Override
    public int compareTo(JobEntry je) {
        return this.getJobId() - je.getJobId();
    }

    @Override
    public void setActive(boolean isActive) {
        this.jobIsActive = isActive;
    }

    @Override
    public boolean isActive() {
        return this.jobIsActive;
    }

    @Override
    public long getNextRuntime() {
        return this.runtime;
    }

    @Override
    public Date getNextRunDate() {
        return new Date(this.runtime);
    }

    @Override
    public String getNextRunAsString() {
        return this.getNextRunDate().toString();
    }

    @Override
    public void calcRunTime() throws TurbineException {
        Calendar schedrun = Calendar.getInstance();
        Calendar now = Calendar.getInstance();
        switch (this.evaluateJobType()) {
            case SECOND: {
                schedrun.add(13, this.getSecond());
                this.runtime = schedrun.getTime().getTime();
                break;
            }
            case MINUTE: {
                schedrun.add(13, this.getSecond());
                schedrun.add(12, this.getMinute());
                this.runtime = schedrun.getTime().getTime();
                break;
            }
            case WEEK_DAY: {
                schedrun.set(13, this.getSecond());
                schedrun.set(12, this.getMinute());
                schedrun.set(11, this.getHour());
                schedrun.set(7, this.getWeekDay());
                if (now.before(schedrun)) {
                    this.runtime = schedrun.getTime().getTime();
                    break;
                }
                schedrun.add(7, 7);
                this.runtime = schedrun.getTime().getTime();
                break;
            }
            case DAY_OF_MONTH: {
                schedrun.set(13, this.getSecond());
                schedrun.set(12, this.getMinute());
                schedrun.set(11, this.getHour());
                schedrun.set(5, this.getDayOfMonth());
                if (now.before(schedrun)) {
                    this.runtime = schedrun.getTime().getTime();
                    break;
                }
                schedrun.add(2, 1);
                this.runtime = schedrun.getTime().getTime();
                break;
            }
            case DAILY: {
                schedrun.set(13, this.getSecond());
                schedrun.set(12, this.getMinute());
                schedrun.set(11, this.getHour());
                if (now.before(schedrun)) {
                    this.runtime = schedrun.getTime().getTime();
                    break;
                }
                schedrun.add(11, 24);
                this.runtime = schedrun.getTime().getTime();
                break;
            }
        }
        log.info("Next runtime for task {} is {}", new Supplier[]{this::getTask, this::getNextRunDate});
    }

    private ScheduleType evaluateJobType() throws TurbineException {
        if (this.getDayOfMonth() < 0) {
            if (this.getWeekDay() < 0) {
                if (this.getHour() < 0) {
                    if (this.getMinute() < 0) {
                        if (this.getSecond() < 0) {
                            throw new TurbineException("Error in JobEntry. Bad Job parameter.");
                        }
                        return ScheduleType.SECOND;
                    }
                    if (this.getMinute() < 0 || this.getSecond() < 0) {
                        throw new TurbineException("Error in JobEntry. Bad Job parameter.");
                    }
                    return ScheduleType.MINUTE;
                }
                if (this.getMinute() < 0 || this.getHour() < 0 || this.getSecond() < 0) {
                    throw new TurbineException("Error in JobEntry. Bad Job parameter.");
                }
                return ScheduleType.DAILY;
            }
            if (this.getMinute() < 0 || this.getHour() < 0 || this.getSecond() < 0) {
                throw new TurbineException("Error in JobEntry. Bad Job parameter.");
            }
            return ScheduleType.WEEK_DAY;
        }
        if (this.getMinute() < 0 || this.getHour() < 0) {
            throw new TurbineException("Error in JobEntry. Bad Job parameter.");
        }
        return ScheduleType.DAY_OF_MONTH;
    }

    @Override
    public abstract int getJobId();

    @Override
    public abstract void setJobId(int var1);

    public abstract int getSecond();

    public abstract void setSecond(int var1);

    public abstract int getMinute();

    public abstract void setMinute(int var1);

    public abstract int getHour();

    public abstract void setHour(int var1);

    public abstract int getWeekDay();

    public abstract void setWeekDay(int var1);

    public abstract int getDayOfMonth();

    public abstract void setDayOfMonth(int var1);

    @Override
    public abstract String getTask();

    @Override
    public abstract void setTask(String var1);

    protected static enum ScheduleType {
        SECOND,
        MINUTE,
        WEEK_DAY,
        DAY_OF_MONTH,
        DAILY;

    }
}

