/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.security.model.turbine.TurbineAccessControlList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.turbine.Turbine;
import org.apache.turbine.annotation.TurbineConfiguration;
import org.apache.turbine.annotation.TurbineLoader;
import org.apache.turbine.annotation.TurbineRequiredPermission;
import org.apache.turbine.annotation.TurbineRequiredRole;
import org.apache.turbine.annotation.TurbineService;
import org.apache.turbine.modules.Assembler;
import org.apache.turbine.modules.Loader;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.util.TurbineException;

public class AnnotationProcessor {
    private static Logger log = LogManager.getLogger(AnnotationProcessor.class);
    private static ConcurrentMap<String, Annotation[]> annotationCache = new ConcurrentHashMap<String, Annotation[]>();

    public static Annotation[] getAnnotations(AccessibleObject object) {
        Annotation[] newAnnotations;
        String key = object.getClass() + object.toString();
        Annotation[] annotations = (Annotation[])annotationCache.get(key);
        if (annotations == null && (annotations = annotationCache.putIfAbsent(key, newAnnotations = object.getDeclaredAnnotations())) == null) {
            annotations = newAnnotations;
        }
        return annotations;
    }

    public static <A extends TurbineAccessControlList<?>> boolean isAuthorized(AccessibleObject object, A acl) {
        return AnnotationProcessor.isAuthorized(object, acl, ConditionType.COMPOUND);
    }

    public static <A extends TurbineAccessControlList<?>> boolean isAuthorized(AccessibleObject object, A acl, ConditionType conditonType) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = AnnotationProcessor.getAnnotations(object)) {
            String group;
            if (annotation instanceof TurbineRequiredRole) {
                TurbineRequiredRole trr = (TurbineRequiredRole)annotation;
                String[] roleNames = trr.value();
                group = trr.group();
                if (StringUtils.isEmpty((CharSequence)group)) {
                    block13: for (String roleName : roleNames) {
                        switch (conditonType) {
                            default: {
                                if (acl.hasRole(roleName)) continue block13;
                                return false;
                            }
                            case ANY: {
                                if (!acl.hasRole(roleName)) continue block13;
                                return true;
                            }
                        }
                    }
                    if (conditonType != ConditionType.ANY) continue;
                    return false;
                }
                block14: for (String roleName : roleNames) {
                    switch (conditonType) {
                        default: {
                            if (acl.hasRole(roleName, group)) continue block14;
                            return false;
                        }
                        case ANY: {
                            if (!acl.hasRole(roleName, group)) continue block14;
                            return true;
                        }
                    }
                }
                continue;
            }
            if (!(annotation instanceof TurbineRequiredPermission)) continue;
            TurbineRequiredPermission trp = (TurbineRequiredPermission)annotation;
            String[] permissionNames = trp.value();
            group = trp.group();
            if (StringUtils.isEmpty((CharSequence)group)) {
                block15: for (String permissionName : permissionNames) {
                    switch (conditonType) {
                        default: {
                            if (acl.hasPermission(permissionName)) continue block15;
                            return false;
                        }
                        case ANY: {
                            if (!acl.hasPermission(permissionName)) continue block15;
                            return true;
                        }
                    }
                }
                continue;
            }
            block16: for (String permissionName : permissionNames) {
                switch (conditonType) {
                    default: {
                        if (acl.hasPermission(permissionName, group)) continue block16;
                        return false;
                    }
                    case ANY: {
                        if (!acl.hasPermission(permissionName, group)) continue block16;
                        return true;
                    }
                }
            }
        }
        return true;
    }

    public static void process(Object object) throws TurbineException {
        ServiceManager manager = null;
        Configuration config = null;
        AssemblerBrokerService assembler = null;
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                Annotation[] annotations;
                for (Annotation a : annotations = AnnotationProcessor.getAnnotations(field)) {
                    if (a instanceof TurbineService) {
                        if (manager == null) {
                            manager = TurbineServices.getInstance();
                        }
                        AnnotationProcessor.injectTurbineService(object, manager, field, (TurbineService)a);
                        continue;
                    }
                    if (a instanceof TurbineConfiguration) {
                        if (config == null) {
                            config = Turbine.getConfiguration();
                        }
                        AnnotationProcessor.injectTurbineConfiguration(object, config, field, (TurbineConfiguration)a);
                        continue;
                    }
                    if (!(a instanceof TurbineLoader)) continue;
                    if (assembler == null) {
                        assembler = (AssemblerBrokerService)TurbineServices.getInstance().getService("AssemblerBrokerService");
                    }
                    AnnotationProcessor.injectTurbineLoader(object, assembler, field, (TurbineLoader)a);
                }
            }
        }
    }

    private static void injectTurbineLoader(Object object, AssemblerBrokerService assembler, Field field, TurbineLoader annotation) throws TurbineException {
        Loader<? extends Assembler> loader = assembler.getLoader(annotation.value());
        field.setAccessible(true);
        try {
            log.debug("Injection of {} into object {}", loader, object);
            field.set(object, loader);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new TurbineException("Could not inject loader " + loader + " into object " + object, e);
        }
    }

    private static void injectTurbineConfiguration(Object object, Configuration conf, Field field, TurbineConfiguration annotation) throws TurbineException {
        Class<?> type = field.getType();
        String key = annotation.value();
        try {
            if (Configuration.class.isAssignableFrom(type)) {
                Configuration injectConfiguration = StringUtils.isNotEmpty((CharSequence)key) ? conf.subset(key) : conf;
                log.debug("Injection of {} into object {}", (Object)injectConfiguration, object);
                field.setAccessible(true);
                field.set(object, injectConfiguration);
            } else if (conf.containsKey(key)) {
                if (String.class.isAssignableFrom(type)) {
                    String value = conf.getString(key);
                    log.debug("Injection of {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.set(object, value);
                } else if (Boolean.TYPE.isAssignableFrom(type)) {
                    boolean value = conf.getBoolean(key);
                    log.debug("Injection of {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setBoolean(object, value);
                } else if (Integer.TYPE.isAssignableFrom(type)) {
                    int value = conf.getInt(key);
                    log.debug("Injection of {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setInt(object, value);
                } else if (Long.TYPE.isAssignableFrom(type)) {
                    long value = conf.getLong(key);
                    log.debug("Injection of {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setLong(object, value);
                } else if (Short.TYPE.isAssignableFrom(type)) {
                    short value = conf.getShort(key);
                    log.debug("Injection of {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setShort(object, value);
                } else if (Long.TYPE.isAssignableFrom(type)) {
                    long value = conf.getLong(key);
                    log.debug("Injection of {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setLong(object, value);
                } else if (Float.TYPE.isAssignableFrom(type)) {
                    float value = conf.getFloat(key);
                    log.debug("Injection of {} into object {}", (Object)Float.valueOf(value), object);
                    field.setAccessible(true);
                    field.setFloat(object, value);
                } else if (Double.TYPE.isAssignableFrom(type)) {
                    double value = conf.getDouble(key);
                    log.debug("Injection of {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setDouble(object, value);
                } else if (Byte.TYPE.isAssignableFrom(type)) {
                    byte value = conf.getByte(key);
                    log.debug("Injection of {} into object {}", (Object)value, object);
                    field.setAccessible(true);
                    field.setByte(object, value);
                } else if (List.class.isAssignableFrom(type)) {
                    List values = conf.getList(key);
                    log.debug("Injection of {} into object {}", (Object)values, object);
                    field.setAccessible(true);
                    field.set(object, values);
                }
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new TurbineException("Could not inject configuration " + conf + " into object " + object, e);
        }
    }

    private static void injectTurbineService(Object object, ServiceManager manager, Field field, TurbineService annotation) throws TurbineException {
        String serviceName = null;
        if (StringUtils.isNotEmpty((CharSequence)annotation.value())) {
            serviceName = annotation.value();
        } else {
            Field[] typeFields;
            for (Field f : typeFields = field.getType().getFields()) {
                if ("SERVICE_NAME".equals(f.getName())) {
                    try {
                        serviceName = (String)f.get(null);
                        break;
                    }
                    catch (IllegalAccessException | IllegalArgumentException e) {
                        continue;
                    }
                }
                if (!"ROLE".equals(f.getName())) continue;
                try {
                    serviceName = (String)f.get(null);
                    break;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    // empty catch block
                }
            }
        }
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            serviceName = field.getType().getName();
        }
        log.debug("Looking up service for injection: {} for object {}", (Object)serviceName, object);
        Object service = manager.getService(serviceName);
        field.setAccessible(true);
        try {
            log.debug("Injection of {} into object {}", (Object)serviceName, object);
            field.set(object, service);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new TurbineException("Could not inject service " + serviceName + " into object " + object, e);
        }
    }

    public static enum ConditionType {
        COMPOUND,
        ANY;

    }
}

