/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import org.apache.commons.lang3.StringUtils;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.XmlField;
import org.apache.fulcrum.intake.validator.StringValidator;

public class StringField
extends Field<String> {
    private static final long serialVersionUID = -7218385325093690333L;

    public StringField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    @Override
    protected String getDefaultValidator() {
        return StringValidator.class.getName();
    }

    @Override
    public void setDefaultValue(String prop) {
        this.defaultValue = prop;
    }

    @Override
    public void setEmptyValue(String prop) {
        this.emptyValue = prop;
    }

    @Override
    protected void doSetValue() {
        if (this.isMultiValued()) {
            String[] ss = this.parser.getStrings(this.getKey());
            String[] sval = new String[ss.length];
            for (int i = 0; i < ss.length; ++i) {
                sval[i] = StringUtils.isNotEmpty((CharSequence)ss[i]) ? ss[i] : (String)this.getEmptyValue();
            }
            this.setTestValue(sval);
        } else {
            String val = this.parser.getString(this.getKey());
            this.setTestValue(StringUtils.isNotEmpty((CharSequence)val) ? val : (String)this.getEmptyValue());
        }
    }

    @Override
    public void setRequired(boolean v, String message) {
        super.setRequired(v, message);
        if (v) {
            if (this.isMultiValued()) {
                String[] ss = (String[])this.getTestValue();
                if (ss == null || ss.length == 0) {
                    this.setValid(false);
                    this.setMessage(message);
                } else {
                    boolean set = false;
                    for (int i = 0; i < ss.length && !(set |= StringUtils.isNotEmpty((CharSequence)ss[i])); ++i) {
                    }
                    if (!set) {
                        this.setValid(false);
                        this.setMessage(message);
                    }
                }
            } else if (!this.isSet() || StringUtils.isEmpty((CharSequence)((String)this.getTestValue()))) {
                this.setValid(false);
                this.setMessage(message);
            }
        }
    }
}

