/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.AvalonFormatter;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.output.io.FileTarget;
import org.apache.log.util.Closeable;

public class SimpleLogKitManager
extends AbstractLogEnabled
implements LoggerManager,
Contextualizable,
Configurable,
Disposable {
    private static final String DEFAULT_FORMAT = "%7.7{priority} %23.23{time:yyyy-MM-dd' 'HH:mm:ss.SSS} [%8.8{category}] (%{context}): %{message}\n%{throwable}";
    private File m_baseDirectory;
    private final Hierarchy m_hierarchy = new Hierarchy();
    private final Logger m_logkitLogger = this.m_hierarchy.getLoggerFor("");
    private org.apache.avalon.framework.logger.Logger m_logger = new LogKitLogger(this.m_logkitLogger);
    private Collection m_targets;

    public void contextualize(Context context) throws ContextException {
        try {
            this.m_baseDirectory = (File)context.get((Object)"app.home");
        }
        catch (ContextException e) {
            this.m_baseDirectory = new File(".");
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration[] targets = configuration.getChildren("log-target");
        HashMap targetSet = this.configureTargets(targets);
        this.m_targets = targetSet.values();
        Configuration[] categories = configuration.getChildren("category");
        this.configureCategories(categories, targetSet);
    }

    public void dispose() {
        Iterator iterator = this.m_targets.iterator();
        while (iterator.hasNext()) {
            LogTarget logTarget = (LogTarget)iterator.next();
            if (!(logTarget instanceof Closeable)) continue;
            ((Closeable)logTarget).close();
        }
    }

    public org.apache.avalon.framework.logger.Logger getLoggerForCategory(String name) {
        return this.m_logger.getChildLogger(name);
    }

    public org.apache.avalon.framework.logger.Logger getDefaultLogger() {
        return this.m_logger;
    }

    private HashMap configureTargets(Configuration[] targets) throws ConfigurationException {
        HashMap<String, FileTarget> targetSet = new HashMap<String, FileTarget>();
        for (int i = 0; i < targets.length; ++i) {
            Configuration target = targets[i];
            String name = target.getAttribute("name");
            String location = target.getAttribute("location").trim();
            String format = target.getAttribute("format", DEFAULT_FORMAT);
            boolean append = target.getAttributeAsBoolean("append", true);
            if ('/' == location.charAt(0)) {
                location = location.substring(1);
            }
            AvalonFormatter formatter = new AvalonFormatter(format);
            File file = new File(this.m_baseDirectory, location);
            FileTarget logTarget = null;
            try {
                logTarget = new FileTarget(file.getAbsoluteFile(), append, (Formatter)formatter);
            }
            catch (IOException ioe) {
                String message = "Error creating LogTarget named \"" + name + "\" for file " + file + ". (Reason: " + ioe.getMessage() + ").";
                throw new ConfigurationException(message, (Throwable)ioe);
            }
            targetSet.put(name, logTarget);
        }
        return targetSet;
    }

    private void configureCategories(Configuration[] categories, HashMap targets) throws ConfigurationException {
        for (int i = 0; i < categories.length; ++i) {
            String message;
            Configuration category = categories[i];
            String name = category.getAttribute("name", "");
            String target = category.getAttribute("target");
            String priorityName = category.getAttribute("priority");
            Logger logger = this.m_logkitLogger.getChildLogger(name);
            LogTarget logTarget = (LogTarget)targets.get(target);
            if (null == target) {
                String message2 = "Unable to locate LogTarget named \"" + target + "\" for Logger named \"" + name + "\".";
                throw new ConfigurationException(message2);
            }
            Priority priority = Priority.getPriorityForName((String)priorityName);
            if (!priority.getName().equals(priorityName)) {
                message = "Unknown priority \"" + priorityName + "\" for Logger named \"" + name + "\".";
                throw new ConfigurationException(message);
            }
            if (this.getLogger().isDebugEnabled()) {
                message = "Creating a log category named \"" + name + "\" that writes to \"" + target + "\" target at priority \"" + priorityName + "\".";
                this.getLogger().debug(message);
            }
            if (name.equals("")) {
                this.m_logkitLogger.setPriority(priority);
                this.m_logkitLogger.setLogTargets(new LogTarget[]{logTarget});
                continue;
            }
            logger.setPriority(priority);
            logger.setLogTargets(new LogTarget[]{logTarget});
        }
    }
}

