/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.jsonrpc;

import com.metaparadigm.jsonrpc.AbstractSerializer;
import com.metaparadigm.jsonrpc.MarshallException;
import com.metaparadigm.jsonrpc.ObjectMatch;
import com.metaparadigm.jsonrpc.SerializerState;
import com.metaparadigm.jsonrpc.UnmarshallException;

public class StringSerializer
extends AbstractSerializer {
    private static final long serialVersionUID = 1L;
    private static Class[] _serializableClasses = new Class[]{String.class, Character.TYPE, Character.class, [B.class, [C.class};
    private static Class[] _JSONClasses = new Class[]{String.class, Integer.class};

    public Class[] getSerializableClasses() {
        return _serializableClasses;
    }

    public Class[] getJSONClasses() {
        return _JSONClasses;
    }

    public ObjectMatch tryUnmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        return ObjectMatch.OKAY;
    }

    public Object unmarshall(SerializerState state, Class clazz, Object jso) throws UnmarshallException {
        String val;
        String string = val = jso instanceof String ? (String)jso : jso.toString();
        if (clazz == Character.TYPE) {
            return new Character(val.charAt(0));
        }
        if (clazz == [B.class) {
            return val.getBytes();
        }
        if (clazz == [C.class) {
            return val.toCharArray();
        }
        return val;
    }

    public Object marshall(SerializerState state, Object o) throws MarshallException {
        if (o instanceof Character) {
            return o.toString();
        }
        if (o instanceof byte[]) {
            return new String((byte[])o);
        }
        if (o instanceof char[]) {
            return new String((char[])o);
        }
        return o;
    }
}

