/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.apache.turbine.util.FormMessage;

public class FormMessages {
    private final Hashtable<String, Vector<String>> forms_messages = new Hashtable();
    private final Hashtable<String, Vector<String>> fields_messages = new Hashtable();
    private final Hashtable<String, Vector<String>> messages_fields = new Hashtable();
    private final Hashtable<String, Vector<String>> forms_fields = new Hashtable();

    public void setMessage(String formName, String fieldName, long returnCode) {
        this.setMessage(formName, fieldName, String.valueOf(returnCode));
    }

    public void setMessage(String formName, String fieldName, String messageName) {
        fieldName = formName + "-" + fieldName;
        this.addValue(this.forms_messages, formName, messageName);
        this.addValue(this.fields_messages, fieldName, messageName);
        this.addValue(this.messages_fields, messageName, fieldName);
        this.addValue(this.forms_fields, formName, fieldName);
    }

    private void addValue(Hashtable<String, Vector<String>> table, String key, String value) {
        if (!table.containsKey(key)) {
            Vector<String> values = new Vector<String>();
            values.addElement(value);
            table.put(key, values);
        } else {
            Vector<String> values = table.get(key);
            if (!values.contains(value)) {
                values.addElement(value);
            }
        }
    }

    private final Vector<String> getValues(Hashtable<String, Vector<String>> table, String key) {
        return table.get(key);
    }

    public FormMessage[] getFormMessages(String formName) {
        Vector<String> messages = this.getValues(this.forms_messages, formName);
        if (messages != null) {
            FormMessage[] result = new FormMessage[messages.size()];
            for (int i = 0; i < messages.size(); ++i) {
                result[i] = new FormMessage(formName);
                String messageName = messages.elementAt(i);
                result[i].setMessage(messageName);
                Vector<String> fields = this.getValues(this.messages_fields, messageName);
                for (int j = 0; j < fields.size(); ++j) {
                    String fieldName = fields.elementAt(j);
                    if (!this.formHasField(formName, fieldName)) continue;
                    result[i].setFieldName(fieldName);
                }
            }
            return result;
        }
        return null;
    }

    public FormMessage[] getFormMessages(String formName, String fieldName) {
        String key = formName + "-" + fieldName;
        Vector<String> messages = this.getValues(this.fields_messages, key);
        if (messages != null) {
            FormMessage[] result = new FormMessage[messages.size()];
            for (int i = 0; i < messages.size(); ++i) {
                result[i] = new FormMessage(formName, fieldName);
                String messageName = messages.elementAt(i);
                result[i].setMessage(messageName);
            }
            return result;
        }
        return null;
    }

    private boolean formHasField(String formName, String fieldName) {
        Vector<String> fields = this.getValues(this.forms_fields, formName);
        Iterator iter = fields.iterator();
        while (iter.hasNext()) {
            if (!fieldName.equals(iter.next().toString())) continue;
            return true;
        }
        return false;
    }
}

