/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.security;

import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.crypto.CryptoAlgorithm;
import org.apache.fulcrum.crypto.CryptoService;
import org.apache.fulcrum.factory.FactoryService;
import org.apache.turbine.om.security.Group;
import org.apache.turbine.om.security.Permission;
import org.apache.turbine.om.security.Role;
import org.apache.turbine.om.security.User;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.ServiceManager;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.security.SecurityService;
import org.apache.turbine.services.security.UserManager;
import org.apache.turbine.util.security.AccessControlList;
import org.apache.turbine.util.security.DataBackendException;
import org.apache.turbine.util.security.EntityExistsException;
import org.apache.turbine.util.security.GroupSet;
import org.apache.turbine.util.security.PasswordMismatchException;
import org.apache.turbine.util.security.PermissionSet;
import org.apache.turbine.util.security.RoleSet;
import org.apache.turbine.util.security.UnknownEntityException;

public abstract class BaseSecurityService
extends TurbineBaseService
implements SecurityService {
    private int readerCount = 0;
    private UserManager userManager = null;
    private Class userClass = null;
    private Class groupClass = null;
    private Class permissionClass = null;
    private Class roleClass = null;
    private Class aclClass = null;
    private FactoryService aclFactoryService = null;
    private static Group globalGroup = null;
    private static Log log = LogFactory.getLog(BaseSecurityService.class);

    @Override
    public String encryptPassword(String password) {
        return this.encryptPassword(password, null);
    }

    @Override
    public String encryptPassword(String password, String salt) {
        if (password == null) {
            return null;
        }
        String secure = this.getConfiguration().getString("secure.passwords", "false").toLowerCase();
        String algorithm = this.getConfiguration().getString("secure.passwords.algorithm", "SHA");
        CryptoService cs = null;
        try {
            ServiceManager serviceManager = TurbineServices.getInstance();
            cs = (CryptoService)serviceManager.getService(CryptoService.ROLE);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not access Crypto Service", e);
        }
        if (cs != null && (secure.equals("true") || secure.equals("yes"))) {
            try {
                CryptoAlgorithm ca = cs.getCryptoAlgorithm(algorithm);
                ca.setSeed(salt);
                String result = ca.encrypt(password);
                return result;
            }
            catch (Exception e) {
                log.error((Object)"Unable to encrypt password: ", (Throwable)e);
                return null;
            }
        }
        return password;
    }

    @Override
    public boolean checkPassword(String checkpw, String encpw) {
        String result = this.encryptPassword(checkpw, encpw);
        return result == null ? false : result.equals(encpw);
    }

    @Override
    public void init() throws InitializationException {
        String userManagerClassName;
        Configuration conf;
        block10: {
            conf = this.getConfiguration();
            userManagerClassName = conf.getString("user.manager", SecurityService.USER_MANAGER_DEFAULT);
            String userClassName = conf.getString("user.class", SecurityService.USER_CLASS_DEFAULT);
            String groupClassName = conf.getString("group.class", SecurityService.GROUP_CLASS_DEFAULT);
            String permissionClassName = conf.getString("permission.class", SecurityService.PERMISSION_CLASS_DEFAULT);
            String roleClassName = conf.getString("role.class", SecurityService.ROLE_CLASS_DEFAULT);
            String aclClassName = conf.getString("acl.class", SecurityService.ACL_CLASS_DEFAULT);
            try {
                this.userClass = Class.forName(userClassName);
                this.groupClass = Class.forName(groupClassName);
                this.permissionClass = Class.forName(permissionClassName);
                this.roleClass = Class.forName(roleClassName);
                this.aclClass = Class.forName(aclClassName);
            }
            catch (Exception e) {
                if (this.userClass == null) {
                    throw new InitializationException("Failed to create a Class object for User implementation", e);
                }
                if (this.groupClass == null) {
                    throw new InitializationException("Failed to create a Class object for Group implementation", e);
                }
                if (this.permissionClass == null) {
                    throw new InitializationException("Failed to create a Class object for Permission implementation", e);
                }
                if (this.roleClass == null) {
                    throw new InitializationException("Failed to create a Class object for Role implementation", e);
                }
                if (this.aclClass != null) break block10;
                throw new InitializationException("Failed to create a Class object for ACL implementation", e);
            }
        }
        try {
            UserManager userManager = (UserManager)Class.forName(userManagerClassName).newInstance();
            userManager.init(conf);
            this.setUserManager(userManager);
        }
        catch (Exception e) {
            throw new InitializationException("Failed to instantiate UserManager", e);
        }
        try {
            this.aclFactoryService = (FactoryService)TurbineServices.getInstance().getService(FactoryService.ROLE);
        }
        catch (Exception e) {
            throw new InitializationException("BaseSecurityService.init: Failed to get the Factory Service object", e);
        }
        this.setInit(true);
    }

    @Override
    public Class getUserClass() throws UnknownEntityException {
        if (this.userClass == null) {
            throw new UnknownEntityException("Failed to create a Class object for User implementation");
        }
        return this.userClass;
    }

    @Override
    public User getUserInstance() throws UnknownEntityException {
        User user;
        try {
            user = (User)this.getUserClass().newInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed instantiate an User implementation object", e);
        }
        return user;
    }

    @Override
    public User getUserInstance(String userName) throws UnknownEntityException {
        User user = this.getUserInstance();
        user.setName(userName);
        return user;
    }

    @Override
    public Class getGroupClass() throws UnknownEntityException {
        if (this.groupClass == null) {
            throw new UnknownEntityException("Failed to create a Class object for Group implementation");
        }
        return this.groupClass;
    }

    @Override
    public Group getGroupInstance() throws UnknownEntityException {
        Group group;
        try {
            group = (Group)this.getGroupClass().newInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate a Group implementation object", e);
        }
        return group;
    }

    @Override
    public Group getGroupInstance(String groupName) throws UnknownEntityException {
        Group group = this.getGroupInstance();
        group.setName(groupName);
        return group;
    }

    @Override
    public Class getPermissionClass() throws UnknownEntityException {
        if (this.permissionClass == null) {
            throw new UnknownEntityException("Failed to create a Class object for Permission implementation");
        }
        return this.permissionClass;
    }

    @Override
    public Permission getPermissionInstance() throws UnknownEntityException {
        Permission permission;
        try {
            permission = (Permission)this.getPermissionClass().newInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate a Permission implementation object", e);
        }
        return permission;
    }

    @Override
    public Permission getPermissionInstance(String permName) throws UnknownEntityException {
        Permission perm = this.getPermissionInstance();
        perm.setName(permName);
        return perm;
    }

    @Override
    public Class getRoleClass() throws UnknownEntityException {
        if (this.roleClass == null) {
            throw new UnknownEntityException("Failed to create a Class object for Role implementation");
        }
        return this.roleClass;
    }

    @Override
    public Role getRoleInstance() throws UnknownEntityException {
        Role role;
        try {
            role = (Role)this.getRoleClass().newInstance();
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate a Role implementation object", e);
        }
        return role;
    }

    @Override
    public Role getRoleInstance(String roleName) throws UnknownEntityException {
        Role role = this.getRoleInstance();
        role.setName(roleName);
        return role;
    }

    @Override
    public Class getAclClass() throws UnknownEntityException {
        if (this.aclClass == null) {
            throw new UnknownEntityException("Failed to create a Class object for ACL implementation");
        }
        return this.aclClass;
    }

    @Override
    public AccessControlList getAclInstance(Map roles, Map permissions) throws UnknownEntityException {
        AccessControlList accessControlList;
        Object[] objects = new Object[]{roles, permissions};
        String[] signatures = new String[]{Map.class.getName(), Map.class.getName()};
        try {
            accessControlList = (AccessControlList)this.aclFactoryService.getInstance(this.aclClass.getName(), objects, signatures);
        }
        catch (Exception e) {
            throw new UnknownEntityException("Failed to instantiate an ACL implementation object", e);
        }
        return accessControlList;
    }

    @Override
    public UserManager getUserManager() {
        return this.userManager;
    }

    @Override
    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    @Override
    public boolean accountExists(User user) throws DataBackendException {
        return this.getUserManager().accountExists(user);
    }

    @Override
    public boolean accountExists(String userName) throws DataBackendException {
        return this.getUserManager().accountExists(userName);
    }

    @Override
    public User getAuthenticatedUser(String username, String password) throws DataBackendException, UnknownEntityException, PasswordMismatchException {
        return this.getUserManager().retrieve(username, password);
    }

    @Override
    public User getUser(String username) throws DataBackendException, UnknownEntityException {
        return this.getUserManager().retrieve(username);
    }

    @Override
    public User getAnonymousUser() throws UnknownEntityException {
        User user = this.getUserInstance();
        user.setName("");
        return user;
    }

    @Override
    public boolean isAnonymousUser(User user) {
        return user == null || StringUtils.isEmpty((String)user.getName());
    }

    @Override
    public void saveUser(User user) throws UnknownEntityException, DataBackendException {
        this.getUserManager().store(user);
    }

    @Override
    public void saveOnSessionUnbind(User user) throws UnknownEntityException, DataBackendException {
        this.userManager.saveOnSessionUnbind(user);
    }

    @Override
    public void addUser(User user, String password) throws DataBackendException, EntityExistsException {
        this.getUserManager().createAccount(user, password);
    }

    @Override
    public void removeUser(User user) throws DataBackendException, UnknownEntityException {
        this.revokeAll(user);
        this.getUserManager().removeAccount(user);
    }

    @Override
    public void changePassword(User user, String oldPassword, String newPassword) throws PasswordMismatchException, UnknownEntityException, DataBackendException {
        this.getUserManager().changePassword(user, oldPassword, newPassword);
    }

    @Override
    public void forcePassword(User user, String password) throws UnknownEntityException, DataBackendException {
        this.getUserManager().forcePassword(user, password);
    }

    protected synchronized void lockShared() {
        ++this.readerCount;
    }

    protected synchronized void unlockShared() {
        --this.readerCount;
        this.notify();
    }

    protected void lockExclusive() {
        while (this.readerCount > 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void unlockExclusive() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Group getGlobalGroup() {
        if (globalGroup != null) return globalGroup;
        Class<BaseSecurityService> clazz = BaseSecurityService.class;
        synchronized (BaseSecurityService.class) {
            if (globalGroup != null) return globalGroup;
            try {
                globalGroup = this.getAllGroups().getGroupByName("global");
            }
            catch (DataBackendException e) {
                log.error((Object)"Failed to retrieve global group object: ", (Throwable)e);
            }
            return globalGroup;
        }
    }

    @Override
    public Group getGroupByName(String name) throws DataBackendException, UnknownEntityException {
        Group group = this.getAllGroups().getGroupByName(name);
        if (group == null) {
            throw new UnknownEntityException("The specified group does not exist");
        }
        return group;
    }

    @Override
    public Group getGroupById(int id) throws DataBackendException, UnknownEntityException {
        Group group = this.getAllGroups().getGroupById(id);
        if (group == null) {
            throw new UnknownEntityException("The specified group does not exist");
        }
        return group;
    }

    @Override
    public Role getRoleByName(String name) throws DataBackendException, UnknownEntityException {
        Role role = this.getAllRoles().getRoleByName(name);
        if (role == null) {
            throw new UnknownEntityException("The specified role does not exist");
        }
        role.setPermissions(this.getPermissions(role));
        return role;
    }

    @Override
    public Role getRoleById(int id) throws DataBackendException, UnknownEntityException {
        Role role = this.getAllRoles().getRoleById(id);
        if (role == null) {
            throw new UnknownEntityException("The specified role does not exist");
        }
        role.setPermissions(this.getPermissions(role));
        return role;
    }

    @Override
    public Permission getPermissionByName(String name) throws DataBackendException, UnknownEntityException {
        Permission permission = this.getAllPermissions().getPermissionByName(name);
        if (permission == null) {
            throw new UnknownEntityException("The specified permission does not exist");
        }
        return permission;
    }

    @Override
    public Permission getPermissionById(int id) throws DataBackendException, UnknownEntityException {
        Permission permission = this.getAllPermissions().getPermissionById(id);
        if (permission == null) {
            throw new UnknownEntityException("The specified permission does not exist");
        }
        return permission;
    }

    @Override
    public abstract GroupSet getAllGroups() throws DataBackendException;

    @Override
    public abstract RoleSet getAllRoles() throws DataBackendException;

    @Override
    public abstract PermissionSet getAllPermissions() throws DataBackendException;
}

