/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.avaloncomponent;

import java.io.IOException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.CommonsLogger;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.yaafi.framework.container.ServiceContainer;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerConfiguration;
import org.apache.fulcrum.yaafi.framework.factory.ServiceContainerFactory;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.avaloncomponent.AvalonComponentService;

public class TurbineYaafiComponentService
extends TurbineBaseService
implements AvalonComponentService,
Initializable,
Disposable {
    private static Log log = LogFactory.getLog((String)"avalon");
    public static final String CONTAINER_CONFIGURATION_KEY = "containerConfiguration";
    public static final String CONTAINER_CONFIGURATION_VALUE = "/WEB-INF/conf/containerConfiguration.xml";
    public static final String COMPONENT_PARAMETERS_KEY = "parameters";
    public static final String COMPONENT_PARAMETERS_VALUE = "/WEB-INF/conf/parameters.properties";
    private ServiceContainer container;

    @Override
    public void init() throws InitializationException {
        try {
            log.info((Object)"Initializing TurbineYaafiComponentService ...");
            this.initialize();
            this.setInit(true);
        }
        catch (Exception e) {
            log.error((Object)"Exception caught initialising service: ", (Throwable)e);
            throw new InitializationException("Initializing TurbineYaafiComponentService failed", e);
        }
    }

    @Override
    public void shutdown() {
        log.info((Object)"Disposing TurbineYaafiComponentService ...");
        this.dispose();
        this.setInit(false);
    }

    public void initialize() throws Exception {
        Configuration conf = this.getConfiguration();
        String homePath = Turbine.getRealPath("/");
        log.info((Object)("Using the following home : " + homePath));
        ServiceContainerConfiguration config = this.createServiceContainerConfiguration(conf);
        config.setLogger(this.createAvalonLogger());
        config.setApplicationRootDir(homePath);
        try {
            this.container = ServiceContainerFactory.create((ServiceContainerConfiguration)config);
        }
        catch (Exception e) {
            String msg = "Initializing YAAFI failed";
            log.error((Object)msg, (Throwable)e);
            throw e;
        }
    }

    public void dispose() {
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
    }

    public Object lookup(String roleName) throws ServiceException {
        return this.container.lookup(roleName);
    }

    @Override
    public void release(Object component) {
        this.container.release(component);
    }

    public boolean hasService(String roleName) {
        return this.container.hasService(roleName);
    }

    protected ServiceContainerConfiguration createServiceContainerConfiguration(Configuration conf) throws IOException {
        ServiceContainerConfiguration result = new ServiceContainerConfiguration();
        if (conf.containsKey(CONTAINER_CONFIGURATION_KEY)) {
            String containerConfiguration = conf.getString(CONTAINER_CONFIGURATION_KEY);
            result.loadContainerConfiguration(containerConfiguration);
        } else if (conf.containsKey("componentRoles")) {
            String roleConfigurationFileName = conf.getString("componentRoles", "/WEB-INF/conf/roleConfiguration.xml");
            String componentConfigurationFileName = conf.getString("componentConfiguration", "/WEB-INF/conf/componentConfiguration.xml");
            String parametersFileName = conf.getString(COMPONENT_PARAMETERS_KEY, COMPONENT_PARAMETERS_VALUE);
            result.setComponentRolesLocation(roleConfigurationFileName);
            result.setComponentConfigurationLocation(componentConfigurationFileName);
            result.setParametersLocation(parametersFileName);
        } else {
            String containerConfiguration = conf.getString(CONTAINER_CONFIGURATION_KEY, CONTAINER_CONFIGURATION_VALUE);
            result.loadContainerConfiguration(containerConfiguration);
        }
        return result;
    }

    protected Logger createAvalonLogger() {
        CommonsLogger result = new CommonsLogger(log, "avalon");
        return result;
    }

    @Override
    public boolean exists(String roleName) {
        return this.hasService(roleName);
    }

    @Override
    public Object get(String roleName) throws InstantiationException {
        try {
            return this.lookup(roleName);
        }
        catch (ServiceException e) {
            String msg = "Unable to get the following service : " + roleName;
            log.error((Object)msg);
            throw new InstantiationException(msg);
        }
        catch (Throwable t) {
            String msg = "Unable to get the following service : " + roleName;
            log.error((Object)msg, t);
            throw new InstantiationException(msg, t);
        }
    }
}

