/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.messenger.ListenerKey;
import org.apache.commons.messenger.Messenger;
import org.apache.commons.messenger.MessengerListener;
import org.apache.commons.messenger.MessengerSession;
import org.apache.commons.messenger.SessionFactory;

public abstract class MessengerSupport
implements Messenger {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$messenger$MessengerSupport == null ? (class$org$apache$commons$messenger$MessengerSupport = MessengerSupport.class$("org.apache.commons.messenger.MessengerSupport")) : class$org$apache$commons$messenger$MessengerSupport));
    private static final Log destinationLog = LogFactory.getLog((String)"org.apache.commons.messenger.destination");
    private static final boolean CACHE_REQUESTOR = true;
    private String name;
    private boolean jndiDestinations;
    private boolean durable;
    private int deliveryMode = 2;
    private String durableName;
    private boolean noLocal;
    private boolean cacheRequestors;
    private Map listeners = new HashMap();
    private boolean cacheProducers = true;
    static /* synthetic */ Class class$org$apache$commons$messenger$MessengerSupport;

    public String toString() {
        try {
            MessengerSession session = this.borrowMessengerSession();
            String answer = super.toString() + " session: " + session.toString();
            this.returnMessengerSession(session);
            return answer;
        }
        catch (Exception e) {
            return super.toString() + " session: " + e.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination getDestination(String subject) throws JMSException {
        Session session;
        boolean debug;
        MessengerSession messengerSession;
        block5: {
            messengerSession = this.borrowMessengerSession();
            try {
                debug = destinationLog.isInfoEnabled();
                session = messengerSession.getSession();
                if (!messengerSession.isTopic()) break block5;
                if (debug) {
                    destinationLog.info((Object)("Using topic: " + subject));
                }
                Topic topic = this.getTopic((TopicSession)session, subject);
                Object var7_7 = null;
                this.returnMessengerSession(messengerSession);
                return topic;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.returnMessengerSession(messengerSession);
                throw throwable;
            }
        }
        if (debug) {
            destinationLog.info((Object)("Using queue: " + subject));
        }
        Queue queue = this.getQueue((QueueSession)session, subject);
        Object var7_8 = null;
        this.returnMessengerSession(messengerSession);
        return queue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination createTemporaryDestination() throws JMSException {
        Session session;
        MessengerSession messengerSession;
        block3: {
            messengerSession = this.borrowMessengerSession();
            try {
                session = messengerSession.getSession();
                if (!messengerSession.isTopic()) break block3;
                TopicSession topicSession = (TopicSession)session;
                TemporaryTopic temporaryTopic = topicSession.createTemporaryTopic();
                Object var6_7 = null;
                this.returnMessengerSession(messengerSession);
                return temporaryTopic;
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                this.returnMessengerSession(messengerSession);
                throw throwable;
            }
        }
        QueueSession queueSession = (QueueSession)session;
        TemporaryQueue temporaryQueue = queueSession.createTemporaryQueue();
        Object var6_8 = null;
        this.returnMessengerSession(messengerSession);
        return temporaryQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            MessageProducer producer = session.getMessageProducer(destination);
            if (session.isTopic()) {
                ((TopicPublisher)producer).publish((Topic)destination, message);
            } else {
                ((QueueSender)producer).send((Queue)destination, message);
            }
            Object var6_5 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(Destination destination) throws JMSException {
        Message message;
        MessengerSession session = this.borrowMessengerSession();
        MessageConsumer consumer = null;
        try {
            consumer = this.borrowMessageConsumer(session, session.getSession(), destination);
            message = consumer.receive();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessageConsumer(consumer);
            this.returnMessengerSession(session);
            throw throwable;
        }
        this.returnMessageConsumer(consumer);
        this.returnMessengerSession(session);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(Destination destination, String selector) throws JMSException {
        Message message;
        MessengerSession session = this.borrowMessengerSession();
        MessageConsumer consumer = null;
        try {
            consumer = this.borrowMessageConsumer(session, session.getSession(), destination, selector);
            message = consumer.receive();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.returnMessageConsumer(consumer);
            this.returnMessengerSession(session);
            throw throwable;
        }
        this.returnMessageConsumer(consumer);
        this.returnMessengerSession(session);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(Destination destination, long timeoutMillis) throws JMSException {
        Message message;
        MessengerSession session = this.borrowMessengerSession();
        MessageConsumer consumer = null;
        try {
            consumer = this.borrowMessageConsumer(session, session.getSession(), destination);
            message = consumer.receive(timeoutMillis);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.returnMessageConsumer(consumer);
            this.returnMessengerSession(session);
            throw throwable;
        }
        this.returnMessageConsumer(consumer);
        this.returnMessengerSession(session);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(Destination destination, String selector, long timeoutMillis) throws JMSException {
        Message message;
        MessengerSession session = this.borrowMessengerSession();
        MessageConsumer consumer = null;
        try {
            consumer = this.borrowMessageConsumer(session, session.getSession(), destination, selector);
            message = consumer.receive(timeoutMillis);
            Object var9_7 = null;
        }
        catch (Throwable throwable) {
            Object var9_8 = null;
            this.returnMessageConsumer(consumer);
            this.returnMessengerSession(session);
            throw throwable;
        }
        this.returnMessageConsumer(consumer);
        this.returnMessengerSession(session);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveNoWait(Destination destination) throws JMSException {
        Message message;
        MessengerSession session = this.borrowMessengerSession();
        MessageConsumer consumer = null;
        try {
            consumer = this.borrowMessageConsumer(session, session.getSession(), destination);
            message = consumer.receiveNoWait();
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessageConsumer(consumer);
            this.returnMessengerSession(session);
            throw throwable;
        }
        this.returnMessageConsumer(consumer);
        this.returnMessengerSession(session);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receiveNoWait(Destination destination, String selector) throws JMSException {
        Message message;
        MessengerSession session = this.borrowMessengerSession();
        MessageConsumer consumer = null;
        try {
            consumer = this.borrowMessageConsumer(session, session.getSession(), destination, selector);
            message = consumer.receiveNoWait();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.returnMessageConsumer(consumer);
            this.returnMessengerSession(session);
            throw throwable;
        }
        this.returnMessageConsumer(consumer);
        this.returnMessengerSession(session);
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            MessageConsumer messageConsumer = this.createMessageConsumer(session, session.getSession(), destination);
            Object var5_4 = null;
            this.returnMessengerSession(session);
            return messageConsumer;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageConsumer createConsumer(Destination destination, String selector) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            MessageConsumer messageConsumer = this.createMessageConsumer(session, session.getSession(), destination, selector);
            Object var6_5 = null;
            this.returnMessengerSession(session);
            return messageConsumer;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    public void run() {
        try {
            MessengerSession session = this.borrowMessengerSession();
            session.getSession().run();
            this.returnMessengerSession(session);
        }
        catch (JMSException e) {}
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        return this.createConnectionConsumer(destination, null, sessionPool, maxMessages);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String selector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        Connection connection = this.getConnection();
        if (this.isTopic(connection)) {
            TopicConnection topicConnection = (TopicConnection)connection;
            if (this.isDurable()) {
                return topicConnection.createDurableConnectionConsumer((Topic)destination, this.getDurableName(), selector, sessionPool, maxMessages);
            }
            return topicConnection.createConnectionConsumer((Topic)destination, selector, sessionPool, maxMessages);
        }
        QueueConnection queueConnection = (QueueConnection)connection;
        return queueConnection.createConnectionConsumer((Queue)destination, selector, sessionPool, maxMessages);
    }

    public abstract Connection getConnection() throws JMSException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Destination destination, MessageListener listener) throws JMSException {
        if (listener instanceof MessengerListener) {
            MessengerListener messengerListener = (MessengerListener)listener;
            messengerListener.setMessenger(this);
        }
        MessengerSession session = this.borrowMessengerSession();
        try {
            MessageConsumer consumer = this.createMessageConsumer(session, session.getListenerSession(), destination);
            consumer.setMessageListener(listener);
            ListenerKey key = new ListenerKey(destination, listener);
            this.listeners.put(key, consumer);
            Object var7_6 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Destination destination, String selector, MessageListener listener) throws JMSException {
        if (listener instanceof MessengerListener) {
            MessengerListener messengerListener = (MessengerListener)listener;
            messengerListener.setMessenger(this);
        }
        MessengerSession session = this.borrowMessengerSession();
        try {
            MessageConsumer consumer = this.createMessageConsumer(session, session.getListenerSession(), destination, selector);
            consumer.setMessageListener(listener);
            ListenerKey key = new ListenerKey(destination, listener, selector);
            this.listeners.put(key, consumer);
            Object var8_7 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    public void removeListener(Destination destination, MessageListener listener) throws JMSException {
        ListenerKey key = new ListenerKey(destination, listener);
        MessageConsumer consumer = (MessageConsumer)this.listeners.remove(key);
        if (consumer == null) {
            throw new JMSException("The given listener object has not been added for the given destination");
        }
        consumer.close();
    }

    public void removeListener(Destination destination, String selector, MessageListener listener) throws JMSException {
        ListenerKey key = new ListenerKey(destination, listener, selector);
        MessageConsumer consumer = (MessageConsumer)this.listeners.remove(key);
        if (consumer == null) {
            throw new JMSException("The given listener object has not been added for the given destination and selector");
        }
        consumer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BytesMessage createBytesMessage() throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            BytesMessage bytesMessage = session.getSession().createBytesMessage();
            Object var4_3 = null;
            this.returnMessengerSession(session);
            return bytesMessage;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MapMessage createMapMessage() throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            MapMessage mapMessage = session.getSession().createMapMessage();
            Object var4_3 = null;
            this.returnMessengerSession(session);
            return mapMessage;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message createMessage() throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            Message message = session.getSession().createMessage();
            Object var4_3 = null;
            this.returnMessengerSession(session);
            return message;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMessage createObjectMessage() throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            ObjectMessage objectMessage = session.getSession().createObjectMessage();
            Object var4_3 = null;
            this.returnMessengerSession(session);
            return objectMessage;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            ObjectMessage objectMessage = session.getSession().createObjectMessage(object);
            Object var5_4 = null;
            this.returnMessengerSession(session);
            return objectMessage;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamMessage createStreamMessage() throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            StreamMessage streamMessage = session.getSession().createStreamMessage();
            Object var4_3 = null;
            this.returnMessengerSession(session);
            return streamMessage;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextMessage createTextMessage() throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            TextMessage textMessage = session.getSession().createTextMessage();
            Object var4_3 = null;
            this.returnMessengerSession(session);
            return textMessage;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextMessage createTextMessage(String text) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            TextMessage textMessage = session.getSession().createTextMessage(text);
            Object var5_4 = null;
            this.returnMessengerSession(session);
            return textMessage;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            session.getSession().commit();
            Object var3_2 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            session.getSession().rollback();
            Object var3_2 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    public void close() throws JMSException {
        this.getSessionFactory().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueBrowser createBrowser(Destination destination) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        Object browser = null;
        try {
            QueueBrowser queueBrowser = this.createBrowser(session, destination);
            Object var6_5 = null;
            this.returnMessengerSession(session);
            return queueBrowser;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDeliveryMode(Destination destination) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        int deliveryMode = 0;
        try {
            MessageProducer producer = session.getMessageProducer(destination);
            deliveryMode = producer.getDeliveryMode();
            Object var6_5 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
        return deliveryMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeliveryMode(Destination destination, int deliveryMode) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        MessageProducer producer = null;
        try {
            producer = session.getMessageProducer(destination);
            producer.setDeliveryMode(deliveryMode);
            Object var6_5 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPriority(Destination destination) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        MessageProducer producer = null;
        int priority = 0;
        try {
            producer = session.getMessageProducer(destination);
            priority = producer.getPriority();
            Object var6_5 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
        return priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPriority(Destination destination, int priority) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        MessageProducer producer = null;
        try {
            producer = session.getMessageProducer(destination);
            producer.setPriority(priority);
            Object var6_5 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeToLive(Destination destination) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        long timeToLive = 0L;
        try {
            MessageProducer producer = session.getMessageProducer(destination);
            timeToLive = producer.getTimeToLive();
            Object var7_5 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
        return timeToLive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeToLive(Destination destination, long timeToLive) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            MessageProducer producer = session.getMessageProducer(destination);
            producer.setTimeToLive(timeToLive);
            Object var7_5 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDisableMessageTimestamp(Destination destination) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        boolean value = false;
        try {
            MessageProducer producer = session.getMessageProducer(destination);
            value = producer.getDisableMessageTimestamp();
            Object var6_5 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisableMessageTimestamp(Destination destination, boolean value) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            MessageProducer producer = session.getMessageProducer(destination);
            producer.setDisableMessageTimestamp(value);
            Object var6_5 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            MessageProducer producer = session.getMessageProducer(destination);
            if (session.isTopic()) {
                ((TopicPublisher)producer).publish((Topic)destination, message, deliveryMode, priority, timeToLive);
            } else {
                ((QueueSender)producer).send((Queue)destination, message, deliveryMode, priority, timeToLive);
            }
            Object var10_8 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDisableMessageID(Destination destination) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        boolean value = false;
        try {
            MessageProducer producer = session.getMessageProducer(destination);
            value = producer.getDisableMessageID();
            Object var6_5 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisableMessageID(Destination destination, boolean value) throws JMSException {
        MessengerSession session = this.borrowMessengerSession();
        try {
            MessageProducer producer = session.getMessageProducer(destination);
            producer.setDisableMessageID(value);
            Object var6_5 = null;
            this.returnMessengerSession(session);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.returnMessengerSession(session);
            throw throwable;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setJndiDestinations(boolean jndiDestinations) {
        this.jndiDestinations = jndiDestinations;
    }

    public boolean isJndiDestinations() {
        return this.jndiDestinations;
    }

    public boolean isDurable() {
        return this.durable;
    }

    public void setDurable(boolean durable) {
        this.durable = durable;
    }

    public boolean isCacheRequestors() {
        return this.cacheRequestors;
    }

    public void setCacheRequestors(boolean cacheRequestors) {
        this.cacheRequestors = cacheRequestors;
    }

    public String getDurableName() {
        return this.durableName;
    }

    public void setDurableName(String durableName) {
        this.durableName = durableName;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public boolean isCacheProducers() {
        return this.cacheProducers;
    }

    public void setCacheProducers(boolean cacheProducers) {
        this.cacheProducers = cacheProducers;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(int deliveryMode) {
        this.deliveryMode = deliveryMode;
    }

    public void setPersistentDelivery(boolean persistentDelivery) {
        if (persistentDelivery) {
            this.setDeliveryMode(2);
        } else {
            this.setDeliveryMode(1);
        }
    }

    protected abstract MessengerSession borrowMessengerSession() throws JMSException;

    protected abstract void returnMessengerSession(MessengerSession var1);

    protected abstract boolean isTopic(Connection var1) throws JMSException;

    protected abstract boolean isTopic(ConnectionFactory var1) throws JMSException;

    protected MessageProducer createMessageProducer(MessengerSession messengerSession, Destination destination) throws JMSException {
        TopicPublisher answer = null;
        Session session = messengerSession.getSession();
        if (messengerSession.isTopic()) {
            TopicSession topicSession = (TopicSession)session;
            answer = topicSession.createPublisher((Topic)destination);
        } else {
            QueueSession queueSession = (QueueSession)session;
            answer = queueSession.createSender((Queue)destination);
        }
        if (this.deliveryMode != 2) {
            answer.setDeliveryMode(this.deliveryMode);
        }
        return answer;
    }

    protected MessageConsumer borrowMessageConsumer(MessengerSession messengerSession, Session session, Destination destination) throws JMSException {
        MessageConsumer consumer = this.createMessageConsumer(messengerSession, session, destination);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new consumer: " + consumer + " on destination: " + destination));
        }
        return consumer;
    }

    protected MessageConsumer borrowMessageConsumer(MessengerSession messengerSession, Session session, Destination destination, String selector) throws JMSException {
        MessageConsumer consumer = this.createMessageConsumer(messengerSession, session, destination, selector);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created new consumer: " + consumer + " on destination: " + destination + " selector: " + selector));
        }
        return consumer;
    }

    protected void returnMessageConsumer(MessageConsumer messageConsumer) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Closing consumer: " + messageConsumer));
        }
        if (messageConsumer != null) {
            messageConsumer.close();
        }
    }

    protected MessageConsumer createMessageConsumer(MessengerSession messengerSession, Session session, Destination destination) throws JMSException {
        if (messengerSession.isTopic()) {
            TopicSession topicSession = (TopicSession)session;
            if (this.isDurable()) {
                return topicSession.createDurableSubscriber((Topic)destination, this.getDurableName(), null, this.isNoLocal());
            }
            return topicSession.createSubscriber((Topic)destination, null, this.isNoLocal());
        }
        QueueSession queueSession = (QueueSession)session;
        return queueSession.createReceiver((Queue)destination);
    }

    protected MessageConsumer createMessageConsumer(MessengerSession messengerSession, Session session, Destination destination, String selector) throws JMSException {
        if (messengerSession.isTopic()) {
            TopicSession topicSession = (TopicSession)session;
            if (this.isDurable()) {
                return topicSession.createDurableSubscriber((Topic)destination, this.getDurableName(), selector, this.isNoLocal());
            }
            return topicSession.createSubscriber((Topic)destination, selector, this.isNoLocal());
        }
        QueueSession queueSession = (QueueSession)session;
        return queueSession.createReceiver((Queue)destination, selector);
    }

    protected QueueBrowser createBrowser(MessengerSession session, Destination destination) throws JMSException {
        if (session.isTopic()) {
            return null;
        }
        QueueSession queueSession = (QueueSession)session.getSession();
        return queueSession.createBrowser((Queue)destination);
    }

    protected Queue getQueue(QueueSession session, String subject) throws JMSException {
        return session.createQueue(subject);
    }

    protected Topic getTopic(TopicSession session, String subject) throws JMSException {
        return session.createTopic(subject);
    }

    public abstract SessionFactory getSessionFactory() throws JMSException;

    public abstract ServerSessionPool createServerSessionPool(MessageListener var1, int var2) throws JMSException;

    public abstract Session getAsyncSession() throws JMSException;

    public abstract Session getSession() throws JMSException;

    public abstract Message call(Destination var1, Message var2, long var3) throws JMSException;

    public abstract Message call(Destination var1, Message var2) throws JMSException;

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

