/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import org.apache.commons.digester.Digester;

public class MessengerDigester
extends Digester {
    private String messengerManagerClass = "org.apache.commons.messenger.MessengerManager";
    private String messengerClass = "org.apache.commons.messenger.DefaultMessenger";
    private String xaMessengerClass = "org.apache.commons.messenger.XAMessenger";
    private String sessionFactory = "org.apache.commons.messenger.SessionFactory";
    private String connectionFactory = "org.apache.commons.messenger.DummyConnectionFactory";
    private String jndiSessionFactory = "org.apache.commons.messenger.JNDISessionFactory";

    protected void configure() {
        if (this.configured) {
            return;
        }
        this.configured = true;
        this.addObjectCreate("manager", this.messengerManagerClass, "className");
        this.addSetProperties("manager");
        String path = "manager/messenger";
        this.addObjectCreate(path, this.messengerClass, "className");
        this.addSetProperties(path);
        this.addSetNext(path, "addMessenger", "org.apache.commons.messenger.Messenger");
        this.addMessengerPaths(path);
        path = "manager/xaMessenger";
        this.addObjectCreate(path, this.xaMessengerClass, "className");
        this.addSetProperties(path);
        this.addSetNext(path, "addMessenger", "org.apache.commons.messenger.Messenger");
        this.addMessengerPaths(path);
    }

    protected void addMessengerPaths(String root) {
        String path = root + "/factory";
        this.addObjectCreate(path, this.sessionFactory, "className");
        this.addSetProperties(path);
        this.addSetNext(path, "setSessionFactory", "org.apache.commons.messenger.SessionFactory");
        this.addCallMethod(path + "/property", "addProperty", 2);
        this.addCallParam(path + "/property/name", 0);
        this.addCallParam(path + "/property/value", 1);
        path = root + "/factory/connectionFactory";
        this.addObjectCreate(path, this.connectionFactory, "className");
        this.addSetProperties(path);
        this.addSetNext(path, "setConnectionFactory", "javax.jms.ConnectionFactory");
        path = root + "/jndi";
        this.addObjectCreate(path, this.jndiSessionFactory, "className");
        this.addSetProperties(path);
        this.addSetNext(path, "setSessionFactory", "org.apache.commons.messenger.SessionFactory");
        this.addCallMethod(path + "/property", "addProperty", 2);
        this.addCallParam(path + "/property/name", 0);
        this.addCallParam(path + "/property/value", 1);
    }
}

